/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

public abstract class FixedEightWriter<T>
implements ValueWriter<T> {
    private int _written = 9;
    private long _value;

    @Override
    public final int writeToBuffer(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        int written = this._written;
        switch (written) {
            case 0: {
                if (!buffer.hasRemaining()) break;
                buffer.put(this.getFormatCode());
                --remaining;
                written = 1;
            }
            case 1: {
                if (remaining >= 8) {
                    buffer.putLong(this._value);
                    written = 9;
                    break;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (remaining >= 4) {
                    buffer.putInt((int)(this._value >> (5 - written << 3) & 0xFFFFFFFFFFFFFFFFL));
                    remaining -= 4;
                    written += 4;
                }
            }
            case 6: 
            case 7: {
                if (remaining >= 2 && written <= 7) {
                    buffer.putShort((short)(this._value >> (7 - written << 3) & 0xFFFFL));
                    remaining -= 2;
                    written += 2;
                }
            }
            case 8: {
                if (remaining < 1 || written == 9) break;
                buffer.put((byte)(this._value >> (8 - written << 3) & 0xFFL));
                ++written;
            }
        }
        this._written = written;
        return 9;
    }

    abstract byte getFormatCode();

    @Override
    public final void setValue(T value) {
        this._written = 0;
        this._value = this.convertValueToLong(value);
    }

    abstract long convertValueToLong(T var1);

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public final boolean isComplete() {
        return this._written == 9;
    }
}

