/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.transport.BytesProcessor;

public class CircularBytesBuffer {
    private final byte[] _buffer;
    private final int _mask;
    private final ByteBuffer _inputBuffer;
    private final ByteBuffer _outputBuffer;
    private volatile int _start;
    private volatile int _size;

    public CircularBytesBuffer(int size) {
        size = this.calculateSize(size);
        this._buffer = new byte[size];
        this._mask = size - 1;
        this._inputBuffer = ByteBuffer.wrap(this._buffer);
        this._outputBuffer = ByteBuffer.wrap(this._buffer);
    }

    public int size() {
        return this._size;
    }

    public boolean isFull() {
        return this._size == this._buffer.length;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ByteBuffer buffer) {
        if (!this.isFull()) {
            int size;
            int start;
            CircularBytesBuffer circularBytesBuffer = this;
            synchronized (circularBytesBuffer) {
                start = this._start;
                size = this._size;
            }
            int pos = start + size & this._mask;
            int length = (this._buffer.length - pos > size ? start : this._buffer.length) - pos;
            int remaining = length > buffer.remaining() ? buffer.remaining() : length;
            buffer.get(this._buffer, pos, remaining);
            CircularBytesBuffer circularBytesBuffer2 = this;
            synchronized (circularBytesBuffer2) {
                this._size += remaining;
            }
            if (buffer.hasRemaining()) {
                this.put(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(BytesProcessor processor) {
        if (!this.isFull()) {
            int size;
            int start;
            CircularBytesBuffer circularBytesBuffer = this;
            synchronized (circularBytesBuffer) {
                start = this._start;
                size = this._size;
            }
            int pos = start + size & this._mask;
            int length = (this._buffer.length - pos > size ? start : this._buffer.length) - pos;
            this._outputBuffer.position(pos);
            this._outputBuffer.limit(pos + length);
            processor.processBytes(this._outputBuffer);
            CircularBytesBuffer circularBytesBuffer2 = this;
            synchronized (circularBytesBuffer2) {
                this._size += length - this._outputBuffer.remaining();
            }
            if (this._outputBuffer.remaining() == 0) {
                this.put(processor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void get(BytesProcessor processor) {
        if (!this.isEmpty()) {
            int size;
            int start;
            CircularBytesBuffer circularBytesBuffer = this;
            synchronized (circularBytesBuffer) {
                start = this._start;
                size = this._size;
            }
            int length = start + size > this._buffer.length ? this._buffer.length - start : size;
            this._inputBuffer.position(start);
            this._inputBuffer.limit(start + length);
            processor.processBytes(this._inputBuffer);
            int consumed = length - this._inputBuffer.remaining();
            CircularBytesBuffer circularBytesBuffer2 = this;
            synchronized (circularBytesBuffer2) {
                this._start += consumed;
                this._size -= consumed;
            }
            if (!this._inputBuffer.hasRemaining()) {
                this.get(processor);
            }
        }
    }

    private int calculateSize(int size) {
        int n = 0;
        int s = size;
        do {
            ++n;
        } while ((s >>= 1) > 0);
        s = 1 << n;
        if (s < size) {
            s <<= 1;
        }
        return s;
    }
}

