/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.amqp_1_0.transport.BytesProcessor;
import org.apache.qpid.amqp_1_0.transport.BytesTransport;
import org.apache.qpid.amqp_1_0.transport.StateChangeListener;
import org.apache.qpid.amqp_1_0.type.Binary;

public class ProtocolHeaderTransport
implements BytesTransport {
    private final Object _inputLock = new Object();
    private final Object _outputLock = new Object();
    private volatile boolean _inputOpen;
    private volatile boolean _outputOpen;
    private final Map<Binary, BytesTransport> _headersMap;
    private BytesTransport _delegate;
    private ByteBuffer _bytesToSend;
    private byte[] _header = new byte[8];
    private int _received;
    private ByteBuffer _outputBuffer;

    public ProtocolHeaderTransport(Map<Binary, BytesTransport> validHeaders) {
        this._headersMap = validHeaders;
    }

    @Override
    public boolean isOpenForInput() {
        return this._inputOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputClosed() {
        Object object = this._inputLock;
        synchronized (object) {
            this._inputOpen = false;
            this._inputLock.notifyAll();
        }
    }

    @Override
    public void processBytes(ByteBuffer buf) {
        if (this._delegate != null) {
            this._delegate.processBytes(buf);
        } else {
            while (this._received < 8 && buf.hasRemaining()) {
                this._header[this._received++] = buf.get();
            }
            if (this._received == 8) {
                Binary header = new Binary(this._header);
                this._delegate = this._headersMap.get(header);
                if (this._delegate != null) {
                    this._delegate.processBytes(ByteBuffer.wrap(this._header));
                    this._delegate.processBytes(buf);
                } else {
                    this.inputClosed();
                    this._outputBuffer = this._headersMap.keySet().iterator().next().asByteBuffer();
                }
            }
        }
    }

    @Override
    public void setInputStateChangeListener(StateChangeListener listener) {
    }

    @Override
    public void getNextBytes(BytesProcessor processor) {
        if (this._bytesToSend != null && this._bytesToSend.hasRemaining()) {
            processor.processBytes(this._bytesToSend);
        } else if (this._delegate != null) {
            this._delegate.getNextBytes(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outputClosed() {
        Object object = this._outputLock;
        synchronized (object) {
            this._outputOpen = false;
            this._outputLock.notifyAll();
        }
    }

    @Override
    public boolean isOpenForOutput() {
        return this._outputOpen;
    }

    @Override
    public void setOutputStateChangeListener(StateChangeListener listener) {
    }
}

