/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.apache.qpid.amqp_1_0.jms.StreamMessage;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage {
    private List _list;
    private boolean _readOnly;
    private int _position = -1;
    private int _offset = -1;

    protected StreamMessageImpl(Header header, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties appProperties, List list, Footer footer, SessionImpl session) {
        super(header, messageAnnotations, properties, appProperties, footer, session);
        this._list = list;
    }

    StreamMessageImpl(SessionImpl session) {
        super(new Header(), new MessageAnnotations(new HashMap()), new Properties(), new ApplicationProperties(new HashMap()), new Footer(Collections.EMPTY_MAP), session);
        this._list = new ArrayList();
    }

    public StreamMessageImpl(Header header, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties appProperties, List amqpListSection, Footer footer) {
        super(header, messageAnnotations, properties, appProperties, footer, null);
        this._list = amqpListSection;
    }

    public boolean readBoolean() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String || obj == null) {
            return Boolean.valueOf((String)obj);
        }
        throw new MessageFormatException("Cannot read " + obj.getClass().getName() + " as boolean");
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._list.clear();
        this._position = -1;
        this._offset = -1;
    }

    public byte readByte() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        if (obj instanceof String || obj == null) {
            try {
                return Byte.valueOf((String)obj);
            }
            catch (RuntimeException e) {
                this.backup();
                throw e;
            }
        }
        this.backup();
        throw new MessageFormatException("Cannot convert value of type " + obj.getClass().getName());
    }

    private void backup() {
        --this._position;
    }

    public short readShort() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Short) {
            return (Short)obj;
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        if (obj instanceof String || obj == null) {
            try {
                return Short.valueOf((String)obj);
            }
            catch (RuntimeException e) {
                this.backup();
                throw e;
            }
        }
        this.backup();
        throw new MessageFormatException("Cannot convert value of type " + obj.getClass().getName());
    }

    public char readChar() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj == null) {
            this.backup();
            throw new NullPointerException();
        }
        this.backup();
        throw new MessageFormatException("Cannot read " + obj.getClass().getName() + " as boolean");
    }

    public int readInt() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        if (obj instanceof String || obj == null) {
            try {
                return Integer.valueOf((String)obj);
            }
            catch (RuntimeException e) {
                this.backup();
                throw e;
            }
        }
        this.backup();
        throw new MessageFormatException("Cannot convert value of type " + obj.getClass().getName());
    }

    public long readLong() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        if (obj instanceof String || obj == null) {
            try {
                return Long.valueOf((String)obj);
            }
            catch (RuntimeException e) {
                this.backup();
                throw e;
            }
        }
        this.backup();
        throw new MessageFormatException("Cannot convert value of type " + obj.getClass().getName());
    }

    public float readFloat() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof String || obj == null) {
            try {
                return Float.valueOf((String)obj).floatValue();
            }
            catch (RuntimeException e) {
                this.backup();
                throw e;
            }
        }
        this.backup();
        throw new MessageFormatException("Cannot convert value of type " + obj.getClass().getName());
    }

    public double readDouble() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof String || obj == null) {
            try {
                return Double.valueOf((String)obj);
            }
            catch (RuntimeException e) {
                this.backup();
                throw e;
            }
        }
        this.backup();
        throw new MessageFormatException("Cannot convert value of type " + obj.getClass().getName());
    }

    public String readString() throws JMSException {
        Object obj = this.readObject();
        if (obj instanceof Binary) {
            this.backup();
            throw new MessageFormatException("Cannot convert value of type " + obj.getClass().getName());
        }
        return String.valueOf(obj);
    }

    public int readBytes(byte[] bytes) throws JMSException {
        Object obj = this.readObject();
        if (!(obj instanceof Binary)) {
            this.backup();
            if (this._position > -1 && this._list.get(this._position) instanceof Binary) {
                return -1;
            }
            throw new MessageFormatException("Cannot convert value of type " + obj.getClass().getName());
        }
        Binary binary = (Binary)obj;
        if (bytes.length >= binary.getLength()) {
            System.arraycopy(binary.getArray(), binary.getArrayOffset(), bytes, 0, binary.getLength());
            return binary.getLength();
        }
        return -1;
    }

    public Object readObject() throws JMSException {
        this.checkReadable();
        if (this._offset == -1) {
            try {
                return this._list.get(++this._position);
            }
            catch (IndexOutOfBoundsException e) {
                throw new MessageEOFException("No more data in message stream");
            }
        }
        return null;
    }

    public void writeBoolean(boolean b) throws JMSException {
        this.checkWritable();
        this._list.add(b);
    }

    public void writeByte(byte b) throws JMSException {
        this.checkWritable();
        this._list.add(b);
    }

    public void writeShort(short i) throws JMSException {
        this.checkWritable();
        this._list.add(i);
    }

    public void writeChar(char c) throws JMSException {
        this.checkWritable();
        this._list.add(Character.valueOf(c));
    }

    public void writeInt(int i) throws JMSException {
        this.checkWritable();
        this._list.add(i);
    }

    public void writeLong(long l) throws JMSException {
        this.checkWritable();
        this._list.add(l);
    }

    public void writeFloat(float v) throws JMSException {
        this.checkWritable();
        this._list.add(Float.valueOf(v));
    }

    public void writeDouble(double v) throws JMSException {
        this.checkWritable();
        this._list.add(v);
    }

    public void writeString(String s) throws JMSException {
        this.checkWritable();
        this._list.add(s);
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.checkWritable();
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int size) throws JMSException {
        this.checkWritable();
        if (!this._list.isEmpty() && this._list.get(this._list.size() - 1) instanceof byte[]) {
            Binary oldVal = (Binary)this._list.get(this._list.size() - 1);
            byte[] allBytes = new byte[oldVal.getLength() + size];
            System.arraycopy(oldVal.getArray(), oldVal.getArrayOffset(), allBytes, 0, oldVal.getLength());
            System.arraycopy(bytes, offset, allBytes, oldVal.getLength(), size);
            this._list.set(this._list.size() - 1, allBytes);
        } else {
            byte[] dup = new byte[size];
            System.arraycopy(bytes, offset, dup, 0, size);
            this._list.add(new Binary(dup));
        }
    }

    public void writeObject(Object o) throws JMSException {
        this.checkWritable();
        if (o == null || _supportedClasses.contains(o.getClass())) {
            this._list.add(o);
        }
    }

    @Override
    public void reset() throws JMSException {
        super.reset();
        this._position = -1;
        this._offset = -1;
    }

    @Override
    Collection<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        sections.add((Section)this.getHeader());
        if (this.getMessageAnnotations() != null && this.getMessageAnnotations().getValue() != null && !this.getMessageAnnotations().getValue().isEmpty()) {
            sections.add((Section)this.getMessageAnnotations());
        }
        sections.add((Section)this.getProperties());
        sections.add((Section)this.getApplicationProperties());
        sections.add((Section)new AmqpValue((Object)this._list));
        sections.add((Section)this.getFooter());
        return sections;
    }
}

