/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.jndi;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionFactoryImpl;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;
import org.apache.qpid.amqp_1_0.jms.impl.QueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TopicImpl;
import org.apache.qpid.amqp_1_0.jms.jndi.ReadOnlyContext;

public class PropertiesFileInitialContextFactory
implements InitialContextFactory {
    private String CONNECTION_FACTORY_PREFIX = "connectionfactory.";
    private String DESTINATION_PREFIX = "destination.";
    private String QUEUE_PREFIX = "queue.";
    private String TOPIC_PREFIX = "topic.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getInitialContext(Hashtable environment) throws NamingException {
        ConcurrentHashMap data;
        block10: {
            data = new ConcurrentHashMap();
            String file = null;
            String fileName = environment.containsKey("java.naming.provider.url") ? (String)environment.get("java.naming.provider.url") : System.getProperty("java.naming.provider.url");
            try {
                file = environment.containsKey("java.naming.provider.url") ? (String)environment.get("java.naming.provider.url") : System.getProperty("java.naming.provider.url");
                if (file != null) {
                    BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                    Properties p = new Properties();
                    try {
                        p.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                    for (Map.Entry<Object, Object> me : p.entrySet()) {
                        String key = (String)me.getKey();
                        String value = (String)me.getValue();
                        environment.put(key, value);
                        if (System.getProperty(key) != null) continue;
                        System.setProperty(key, value);
                    }
                    break block10;
                }
                throw new NamingException("No Provider URL specified.");
            }
            catch (IOException ioe) {
                NamingException ne = new NamingException("Unable to load property file:" + file + ".");
                ne.setRootCause(ioe);
                throw ne;
            }
        }
        try {
            this.createConnectionFactories(data, environment);
        }
        catch (MalformedURLException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        this.createDestinations(data, environment);
        this.createQueues(data, environment);
        this.createTopics(data, environment);
        return this.createContext(data, environment);
    }

    protected ReadOnlyContext createContext(Map data, Hashtable environment) {
        return new ReadOnlyContext(environment, data);
    }

    protected void createConnectionFactories(Map data, Hashtable environment) throws MalformedURLException {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.CONNECTION_FACTORY_PREFIX)) continue;
            String jndiName = key.substring(this.CONNECTION_FACTORY_PREFIX.length());
            ConnectionFactory cf = this.createFactory(entry.getValue().toString().trim());
            if (cf == null) continue;
            data.put(jndiName, cf);
        }
    }

    protected void createDestinations(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.DESTINATION_PREFIX)) continue;
            String jndiName = key.substring(this.DESTINATION_PREFIX.length());
            DestinationImpl dest = this.createDestination(entry.getValue().toString().trim());
            if (dest == null) continue;
            data.put(jndiName, dest);
        }
    }

    protected void createQueues(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.QUEUE_PREFIX)) continue;
            String jndiName = key.substring(this.QUEUE_PREFIX.length());
            QueueImpl q = this.createQueue(entry.getValue().toString().trim());
            if (q == null) continue;
            data.put(jndiName, q);
        }
    }

    protected void createTopics(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.TOPIC_PREFIX)) continue;
            String jndiName = key.substring(this.TOPIC_PREFIX.length());
            TopicImpl t = this.createTopic(entry.getValue().toString().trim());
            if (t == null) continue;
            data.put(jndiName, t);
        }
    }

    private ConnectionFactory createFactory(String url) throws MalformedURLException {
        return ConnectionFactoryImpl.createFromURL(url);
    }

    private DestinationImpl createDestination(String str) {
        return DestinationImpl.createDestination(str);
    }

    private QueueImpl createQueue(String address) {
        return QueueImpl.createQueue(address);
    }

    private TopicImpl createTopic(String address) {
        return TopicImpl.createTopic(address);
    }
}

