/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.amqp_1_0.client.AcknowledgeMode;
import org.apache.qpid.amqp_1_0.client.ConnectionClosedException;
import org.apache.qpid.amqp_1_0.client.LinkDetachedException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.client.Transaction;
import org.apache.qpid.amqp_1_0.codec.DescribedTypeConstructor;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoder;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.LinkEventListener;
import org.apache.qpid.amqp_1_0.transport.SendingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SendingLinkListener;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.Source;
import org.apache.qpid.amqp_1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.amqp_1_0.type.messaging.Accepted;
import org.apache.qpid.amqp_1_0.type.messaging.Target;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusDurability;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.amqp_1_0.type.transaction.TransactionalState;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.SenderSettleMode;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class Sender
implements DeliveryStateHandler {
    private SendingLinkEndpoint _endpoint;
    private int _id;
    private Session _session;
    private int _windowSize;
    private Map<Binary, OutcomeAction> _outcomeActions = Collections.synchronizedMap(new HashMap());
    private boolean _closed;
    private Error _error;
    private Runnable _remoteErrorTask;
    private Outcome _defaultOutcome;

    public Sender(Session session, String linkName, String targetAddr, String sourceAddr) throws SenderCreationException, ConnectionClosedException {
        this(session, linkName, targetAddr, sourceAddr, false);
    }

    public Sender(Session session, String linkName, String targetAddr, String sourceAddr, boolean synchronous) throws SenderCreationException, ConnectionClosedException {
        this(session, linkName, targetAddr, sourceAddr, synchronous ? 1 : 0);
    }

    public Sender(Session session, String linkName, String targetAddr, String sourceAddr, int window) throws SenderCreationException, ConnectionClosedException {
        this(session, linkName, targetAddr, sourceAddr, window, AcknowledgeMode.ALO);
    }

    public Sender(Session session, String linkName, Target target, org.apache.qpid.amqp_1_0.type.messaging.Source source, int window) throws SenderCreationException, ConnectionClosedException {
        this(session, linkName, target, source, window, AcknowledgeMode.ALO);
    }

    public Sender(Session session, String linkName, String targetAddr, String sourceAddr, int window, AcknowledgeMode mode) throws SenderCreationException, ConnectionClosedException {
        this(session, linkName, targetAddr, sourceAddr, window, mode, null);
    }

    public Sender(Session session, String linkName, Target target, org.apache.qpid.amqp_1_0.type.messaging.Source source, int window, AcknowledgeMode mode) throws SenderCreationException, ConnectionClosedException {
        this(session, linkName, target, source, window, mode, null);
    }

    public Sender(Session session, String linkName, String targetAddr, String sourceAddr, int window, AcknowledgeMode mode, Map<Binary, Outcome> unsettled) throws SenderCreationException, ConnectionClosedException {
        this(session, linkName, targetAddr, sourceAddr, window, mode, false, unsettled);
    }

    public Sender(Session session, String linkName, String targetAddr, String sourceAddr, int window, AcknowledgeMode mode, boolean isDurable, Map<Binary, Outcome> unsettled) throws SenderCreationException, ConnectionClosedException {
        this(session, linkName, Sender.createTarget(targetAddr, isDurable), Sender.createSource(sourceAddr), window, mode, unsettled);
    }

    protected void configureSource(org.apache.qpid.amqp_1_0.type.messaging.Source source) {
    }

    protected void configureTarget(Target target) {
    }

    private static org.apache.qpid.amqp_1_0.type.messaging.Source createSource(String sourceAddr) {
        org.apache.qpid.amqp_1_0.type.messaging.Source source = new org.apache.qpid.amqp_1_0.type.messaging.Source();
        source.setAddress(sourceAddr);
        return source;
    }

    private static Target createTarget(String targetAddr, boolean isDurable) {
        Target target = new Target();
        target.setAddress(targetAddr);
        if (isDurable) {
            target.setDurable(TerminusDurability.UNSETTLED_STATE);
            target.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sender(Session session, String linkName, Target target, org.apache.qpid.amqp_1_0.type.messaging.Source source, int window, AcknowledgeMode mode, Map<Binary, Outcome> unsettled) throws SenderCreationException, ConnectionClosedException {
        this._session = session;
        this._windowSize = window;
        session.getConnection().checkNotClosed();
        this.configureSource(source);
        this.configureTarget(target);
        this._endpoint = session.createSendingLinkEndpoint(linkName, target, source, mode, unsettled, this);
        Object object = this._endpoint.getLock();
        synchronized (object) {
            while (!this._endpoint.isAttached() && !this._endpoint.isDetached()) {
                try {
                    this._endpoint.getLock().wait();
                }
                catch (InterruptedException e) {
                    throw new SenderCreationException((Throwable)e);
                }
            }
            if (session.getEndpoint().isEnded()) {
                throw new SenderCreationException("Session is closed while creating link, target: " + target.getAddress());
            }
            if (this._endpoint.getTarget() == null) {
                throw new SenderCreationException("Peer did not create remote endpoint for link, target: " + target.getAddress());
            }
        }
        this._endpoint.setLinkEventListener((LinkEventListener)new SendingLinkListener.DefaultLinkEventListener(){

            public void remoteDetached(LinkEndpoint endpoint, Detach detach) {
                Sender.this._error = detach.getError();
                if (Sender.this._error != null) {
                    Sender.this.remoteError();
                }
                super.remoteDetached(endpoint, detach);
            }
        });
        this._defaultOutcome = source.getDefaultOutcome();
        if (this._defaultOutcome == null) {
            Object impliedOutcome;
            AMQPDescribedTypeRegistry describedTypeRegistry;
            DescribedTypeConstructor constructor;
            if (source.getOutcomes() == null || source.getOutcomes().length == 0) {
                this._defaultOutcome = new Accepted();
            } else if (source.getOutcomes().length == 1 && (constructor = (describedTypeRegistry = this._endpoint.getSession().getConnection().getDescribedTypeRegistry()).getConstructor((Object)source.getOutcomes()[0])) != null && (impliedOutcome = constructor.construct((Object)Collections.EMPTY_LIST)) instanceof Outcome) {
                this._defaultOutcome = (Outcome)impliedOutcome;
            }
        }
    }

    public Source getSource() {
        return this._endpoint.getSource();
    }

    public org.apache.qpid.amqp_1_0.type.Target getTarget() {
        return this._endpoint.getTarget();
    }

    public void send(Message message) throws LinkDetachedException {
        this.send(message, null, null);
    }

    public void send(Message message, OutcomeAction action) throws LinkDetachedException {
        this.send(message, null, action);
    }

    public void send(Message message, Transaction txn) throws LinkDetachedException {
        this.send(message, txn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, Transaction txn, OutcomeAction action) throws LinkDetachedException {
        Object lock;
        List<Section> sections = message.getPayload();
        Transfer xfr = new Transfer();
        if (sections != null && !sections.isEmpty()) {
            SectionEncoder encoder = this._session.getSectionEncoder();
            encoder.reset();
            boolean sectionNumber = false;
            for (Section section : sections) {
                encoder.encodeObject((Object)section);
            }
            Binary encoding = encoder.getEncoding();
            ByteBuffer payload = encoding.asByteBuffer();
            xfr.setPayload(payload);
        }
        if (message.getDeliveryTag() == null) {
            message.setDeliveryTag(new Binary(String.valueOf(this._id++).getBytes()));
        }
        if (message.isResume()) {
            xfr.setResume(Boolean.TRUE);
        }
        if (message.getDeliveryState() != null) {
            xfr.setState(message.getDeliveryState());
        }
        xfr.setDeliveryTag(message.getDeliveryTag());
        if (txn != null) {
            xfr.setSettled(Boolean.valueOf(false));
            TransactionalState deliveryState = new TransactionalState();
            deliveryState.setTxnId(txn.getTxnId());
            xfr.setState((DeliveryState)deliveryState);
        } else {
            xfr.setSettled(Boolean.valueOf(message.getSettled() || this._endpoint.getSendingSettlementMode() == SenderSettleMode.SETTLED));
        }
        Object object = lock = this._endpoint.getLock();
        synchronized (object) {
            while (!this._endpoint.hasCreditToSend() && !this._endpoint.isDetached()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this._endpoint.isDetached()) {
                throw new LinkDetachedException(this._error);
            }
            if (action != null) {
                this._outcomeActions.put(message.getDeliveryTag(), action);
            }
            this._endpoint.transfer(xfr);
        }
        if (this._windowSize != 0) {
            object = lock;
            synchronized (object) {
                while (this._endpoint.getUnsettledCount() >= this._windowSize) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SenderClosingException {
        Object object;
        if (this._windowSize != 0) {
            object = this._endpoint.getLock();
            synchronized (object) {
                while (this._endpoint.getUnsettledCount() > 0) {
                    try {
                        this._endpoint.getLock().wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this._session.removeSender(this);
        this._endpoint.setSource(null);
        this._endpoint.detach();
        this._closed = true;
        object = this._endpoint.getLock();
        synchronized (object) {
            while (!this._endpoint.isDetached()) {
                try {
                    this._endpoint.getLock().wait();
                }
                catch (InterruptedException e) {
                    throw new SenderClosingException((Throwable)e);
                }
            }
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void handle(Binary deliveryTag, DeliveryState state, Boolean settled) {
        OutcomeAction action;
        if (state instanceof Outcome) {
            OutcomeAction action2 = this._outcomeActions.remove(deliveryTag);
            if (action2 != null) {
                Outcome outcome = (Outcome)state;
                action2.onOutcome(deliveryTag, outcome == null && settled != false ? this._defaultOutcome : outcome);
            }
            if (!Boolean.TRUE.equals(settled)) {
                this._endpoint.updateDisposition(deliveryTag, state, true);
            }
        } else if (state instanceof TransactionalState && (action = this._outcomeActions.remove(deliveryTag)) != null) {
            Outcome outcome = ((TransactionalState)state).getOutcome();
            action.onOutcome(deliveryTag, outcome == null ? this._defaultOutcome : outcome);
        }
    }

    public SendingLinkEndpoint getEndpoint() {
        return this._endpoint;
    }

    public Map<Binary, DeliveryState> getRemoteUnsettled() {
        return this._endpoint.getInitialUnsettledMap();
    }

    public Session getSession() {
        return this._session;
    }

    private void remoteError() {
        if (this._remoteErrorTask != null) {
            this._remoteErrorTask.run();
        }
    }

    public void setRemoteErrorListener(Runnable listener) {
        this._remoteErrorTask = listener;
    }

    public Error getError() {
        return this._error;
    }

    public static interface OutcomeAction {
        public void onOutcome(Binary var1, Outcome var2);
    }

    public class SenderClosingException
    extends Exception {
        public SenderClosingException(Throwable e) {
            super(e);
        }
    }

    public class SenderCreationException
    extends Exception {
        public SenderCreationException(Throwable e) {
            super(e);
        }

        public SenderCreationException(String e) {
            super(e);
        }
    }
}

