/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import org.apache.qpid.amqp_1_0.jms.ObjectMessage;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage {
    static final Symbol CONTENT_TYPE = Symbol.valueOf((String)"application/x-java-serialized-object");
    static final Data NULL_OBJECT_DATA;
    private Data _objectData = NULL_OBJECT_DATA;

    protected ObjectMessageImpl(Header header, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties appProperties, Data dataSection, Footer footer, SessionImpl session) {
        super(header, messageAnnotations, properties, appProperties, footer, session);
        this.getProperties().setContentType(CONTENT_TYPE);
        Object serializable = null;
        this._objectData = dataSection;
    }

    protected ObjectMessageImpl(SessionImpl session) {
        super(new Header(), new MessageAnnotations(new HashMap()), new Properties(), new ApplicationProperties(new HashMap()), new Footer(Collections.EMPTY_MAP), session);
        this.getProperties().setContentType(CONTENT_TYPE);
    }

    public void setObject(Serializable serializable) throws MessageNotWriteableException {
        this.checkWritable();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            oos.flush();
            oos.close();
            this._objectData = new Data(new Binary(baos.toByteArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Serializable getObject() throws JMSException {
        if (this._objectData == null) {
            return null;
        }
        Binary data = this._objectData.getValue();
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data.getArray(), data.getArrayOffset(), data.getLength()));
            return (Serializable)ois.readObject();
        }
        catch (IOException e) {
            JMSException jmsException = new JMSException(e.getMessage());
            jmsException.setLinkedException((Exception)e);
            throw jmsException;
        }
        catch (ClassNotFoundException e) {
            JMSException jmsException = new JMSException(e.getMessage());
            jmsException.setLinkedException((Exception)e);
            throw jmsException;
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._objectData = null;
    }

    @Override
    Collection<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        sections.add((Section)this.getHeader());
        if (this.getMessageAnnotations() != null && this.getMessageAnnotations().getValue() != null && !this.getMessageAnnotations().getValue().isEmpty()) {
            sections.add((Section)this.getMessageAnnotations());
        }
        sections.add((Section)this.getProperties());
        sections.add((Section)this.getApplicationProperties());
        sections.add((Section)this._objectData);
        sections.add((Section)this.getFooter());
        return sections;
    }

    static {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(null);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        NULL_OBJECT_DATA = new Data(new Binary(baos.toByteArray()));
    }
}

