/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.amqp_1_0.client.AcknowledgeMode;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.client.Transaction;
import org.apache.qpid.amqp_1_0.messaging.SectionDecoder;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.LinkEventListener;
import org.apache.qpid.amqp_1_0.transport.Predicate;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkListener;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.ErrorCondition;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.Source;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Accepted;
import org.apache.qpid.amqp_1_0.type.messaging.Modified;
import org.apache.qpid.amqp_1_0.type.messaging.Released;
import org.apache.qpid.amqp_1_0.type.messaging.Target;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusDurability;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.amqp_1_0.type.transaction.TransactionalState;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.amqp_1_0.type.transport.SenderSettleMode;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class Receiver
implements DeliveryStateHandler {
    private ReceivingLinkEndpoint _endpoint;
    private int _id;
    private static final UnsignedInteger DEFAULT_INITIAL_CREDIT = UnsignedInteger.valueOf((int)100);
    private Session _session;
    private Queue<Transfer> _prefetchQueue = new ConcurrentLinkedQueue<Transfer>();
    private Map<Binary, SettledAction> _unsettledMap = new HashMap<Binary, SettledAction>();
    private MessageArrivalListener _messageArrivalListener;
    private Error _error;
    private Runnable _remoteErrorTask;

    public Receiver(Session session, String linkName, Target target, org.apache.qpid.amqp_1_0.type.messaging.Source source, AcknowledgeMode ackMode) throws ConnectionErrorException {
        this(session, linkName, target, source, ackMode, false);
    }

    public Receiver(Session session, String linkName, Target target, org.apache.qpid.amqp_1_0.type.messaging.Source source, AcknowledgeMode ackMode, boolean isDurable) throws ConnectionErrorException {
        this(session, linkName, target, source, ackMode, isDurable, null);
    }

    public Receiver(Session session, String linkName, Target target, org.apache.qpid.amqp_1_0.type.messaging.Source source, AcknowledgeMode ackMode, boolean isDurable, Map<Binary, Outcome> unsettled) throws ConnectionErrorException {
        session.getConnection().checkNotClosed();
        this._session = session;
        if (isDurable) {
            source.setDurable(TerminusDurability.UNSETTLED_STATE);
            source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
        } else if (source != null) {
            source.setDurable(TerminusDurability.NONE);
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }
        this._endpoint = session.getEndpoint().createReceivingLinkEndpoint(linkName, target, source, UnsignedInteger.ZERO);
        this._endpoint.setDeliveryStateHandler((DeliveryStateHandler)this);
        switch (ackMode) {
            case ALO: {
                this._endpoint.setSendingSettlementMode(SenderSettleMode.UNSETTLED);
                this._endpoint.setReceivingSettlementMode(ReceiverSettleMode.FIRST);
                break;
            }
            case AMO: {
                this._endpoint.setSendingSettlementMode(SenderSettleMode.SETTLED);
                this._endpoint.setReceivingSettlementMode(ReceiverSettleMode.FIRST);
                break;
            }
            case EO: {
                this._endpoint.setSendingSettlementMode(SenderSettleMode.UNSETTLED);
                this._endpoint.setReceivingSettlementMode(ReceiverSettleMode.SECOND);
            }
        }
        this._endpoint.setLinkEventListener((LinkEventListener)new ReceivingLinkListener.DefaultLinkEventListener(){

            public void messageTransfer(Transfer xfr) {
                Receiver.this._prefetchQueue.add(xfr);
                Receiver.this.postPrefetchAction();
            }

            public void remoteDetached(LinkEndpoint endpoint, Detach detach) {
                Receiver.this._error = detach.getError();
                if (detach.getError() != null) {
                    Receiver.this.remoteError();
                }
                super.remoteDetached(endpoint, detach);
            }
        });
        this._endpoint.setLocalUnsettled(unsettled);
        this._endpoint.attach();
        try {
            this._endpoint.waitUntil(new Predicate(){

                public boolean isSatisfied() {
                    return Receiver.this._endpoint.isAttached() || Receiver.this._endpoint.isDetached();
                }
            });
        }
        catch (TimeoutException e) {
            throw new ConnectionErrorException((ErrorCondition)AmqpError.INTERNAL_ERROR, "Timeout waiting for attach");
        }
        catch (InterruptedException e) {
            throw new ConnectionErrorException((ErrorCondition)AmqpError.INTERNAL_ERROR, "Interrupted while waiting for attach");
        }
        if (this._endpoint.getSource() == null) {
            try {
                this._endpoint.waitUntil(new Predicate(){

                    public boolean isSatisfied() {
                        return Receiver.this._endpoint.isDetached();
                    }
                });
            }
            catch (TimeoutException e) {
                throw new ConnectionErrorException((ErrorCondition)AmqpError.INTERNAL_ERROR, "Timeout waiting for detach following failed attach");
            }
            catch (InterruptedException e) {
                throw new ConnectionErrorException((ErrorCondition)AmqpError.INTERNAL_ERROR, "Interrupted whil waiting for detach following failed attach");
            }
            throw new ConnectionErrorException(this.getError());
        }
    }

    private void remoteError() {
        if (this._remoteErrorTask != null) {
            this._remoteErrorTask.run();
        }
    }

    private void postPrefetchAction() {
        if (this._messageArrivalListener != null) {
            this._messageArrivalListener.messageArrived(this);
        }
    }

    public void setCredit(UnsignedInteger credit, boolean window) {
        this._endpoint.setLinkCredit(credit);
        this._endpoint.setCreditWindow(window);
    }

    public String getAddress() {
        return ((org.apache.qpid.amqp_1_0.type.messaging.Source)this._endpoint.getSource()).getAddress();
    }

    public Map getFilter() {
        return ((org.apache.qpid.amqp_1_0.type.messaging.Source)this._endpoint.getSource()).getFilter();
    }

    public Message receive() {
        return this.receive(-1L);
    }

    public Message receive(boolean wait) {
        return this.receive(wait ? -1L : 0L);
    }

    public Message receive(long wait) {
        Transfer xfr;
        long endTime;
        Message m = null;
        long l = endTime = wait > 0L ? System.currentTimeMillis() + wait : 0L;
        while ((xfr = this.receiveFromPrefetch(wait)) != null) {
            if (!Boolean.TRUE.equals(xfr.getAborted())) {
                boolean hasMore;
                Binary deliveryTag = xfr.getDeliveryTag();
                Boolean resume = xfr.getResume();
                ArrayList<Section> sections = new ArrayList();
                ArrayList<ByteBuffer> payloads = new ArrayList<ByteBuffer>();
                int totalSize = 0;
                do {
                    hasMore = Boolean.TRUE.equals(xfr.getMore());
                    ByteBuffer buf = xfr.getPayload();
                    if (buf != null) {
                        totalSize += buf.remaining();
                        payloads.add(buf);
                    }
                    if (!hasMore || (xfr = this.receiveFromPrefetch(-1L)) != null) continue;
                    System.out.println("eeek");
                } while (hasMore && !Boolean.TRUE.equals(xfr.getAborted()));
                if (!Boolean.TRUE.equals(xfr.getAborted())) {
                    ByteBuffer allPayload = ByteBuffer.allocate(totalSize);
                    for (ByteBuffer payload : payloads) {
                        allPayload.put(payload);
                    }
                    allPayload.flip();
                    SectionDecoder decoder = this._session.getSectionDecoder();
                    try {
                        sections = decoder.parseAll(allPayload);
                    }
                    catch (AmqpErrorException e) {
                        e.printStackTrace();
                    }
                    m = new Message(sections);
                    m.setDeliveryTag(deliveryTag);
                    m.setResume(resume);
                    m.setReceiver(this);
                    break;
                }
            }
            if (wait <= 0L || (wait = endTime - System.currentTimeMillis()) > 0L) continue;
            break;
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transfer receiveFromPrefetch(long wait) {
        Object lock;
        long endTime = wait > 0L ? System.currentTimeMillis() + wait : 0L;
        Object object = lock = this._endpoint.getLock();
        synchronized (object) {
            Transfer xfr;
            while ((xfr = this._prefetchQueue.peek()) == null && !this._endpoint.isDrained() && !this._endpoint.isDetached() && wait != 0L) {
                try {
                    if (wait > 0L) {
                        lock.wait(wait);
                    } else if (wait < 0L) {
                        lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    return null;
                }
                if (wait <= 0L || (wait = endTime - System.currentTimeMillis()) > 0L) continue;
            }
            if (xfr != null) {
                this._prefetchQueue.poll();
            }
            return xfr;
        }
    }

    public void release(Message m) {
        this.release(m.getDeliveryTag());
    }

    public void release(Binary deliveryTag) {
        this.update((Outcome)new Released(), deliveryTag, null, null);
    }

    public void modified(Binary tag) {
        Modified outcome = new Modified();
        outcome.setDeliveryFailed(Boolean.valueOf(true));
        this.update((Outcome)outcome, tag, null, null);
    }

    public void acknowledge(Message m) {
        this.acknowledge(m.getDeliveryTag());
    }

    public void acknowledge(Message m, SettledAction a) {
        this.acknowledge(m.getDeliveryTag(), a);
    }

    public void acknowledge(Message m, Transaction txn) {
        this.acknowledge(m.getDeliveryTag(), txn);
    }

    public void acknowledge(Binary deliveryTag) {
        this.acknowledge(deliveryTag, null, null);
    }

    public void acknowledge(Binary deliveryTag, SettledAction a) {
        this.acknowledge(deliveryTag, null, a);
    }

    public void acknowledge(Binary deliveryTag, Transaction txn) {
        this.acknowledge(deliveryTag, txn, null);
    }

    public void acknowledge(Binary deliveryTag, Transaction txn, SettledAction action) {
        this.update((Outcome)new Accepted(), deliveryTag, txn, action);
    }

    public void update(Outcome outcome, Binary deliveryTag, Transaction txn, SettledAction action) {
        boolean settled;
        DeliveryState state;
        if (txn != null) {
            TransactionalState txnState = new TransactionalState();
            txnState.setOutcome(outcome);
            txnState.setTxnId(txn.getTxnId());
            state = txnState;
        } else {
            state = (DeliveryState)outcome;
        }
        boolean bl = settled = txn == null && !ReceiverSettleMode.SECOND.equals(this._endpoint.getReceivingSettlementMode());
        if (!settled && action != null) {
            this._unsettledMap.put(deliveryTag, action);
        }
        this._endpoint.updateDisposition(deliveryTag, state, settled);
    }

    public Error getError() {
        return this._error;
    }

    public void acknowledgeAll(Message m) {
        this.acknowledgeAll(m.getDeliveryTag());
    }

    public void acknowledgeAll(Binary deliveryTag) {
        this.acknowledgeAll(deliveryTag, null, null);
    }

    public void acknowledgeAll(Binary deliveryTag, Transaction txn, SettledAction action) {
        this.updateAll((Outcome)new Accepted(), deliveryTag, txn, action);
    }

    public void updateAll(Outcome outcome, Binary deliveryTag) {
        this.updateAll(outcome, deliveryTag, null, null);
    }

    public void updateAll(Outcome outcome, Binary deliveryTag, Transaction txn, SettledAction action) {
        boolean settled;
        DeliveryState state;
        if (txn != null) {
            TransactionalState txnState = new TransactionalState();
            txnState.setOutcome(outcome);
            txnState.setTxnId(txn.getTxnId());
            state = txnState;
        } else {
            state = (DeliveryState)outcome;
        }
        boolean bl = settled = txn == null && !ReceiverSettleMode.SECOND.equals(this._endpoint.getReceivingSettlementMode());
        if (!settled && action != null) {
            this._unsettledMap.put(deliveryTag, action);
        }
        this._endpoint.updateAllDisposition(deliveryTag, state, settled);
    }

    public void close() {
        Message msg;
        this._endpoint.setTarget(null);
        this._endpoint.close();
        while ((msg = this.receive(0L)) != null) {
            this.release(msg);
        }
    }

    public void detach() {
        Message msg;
        this._endpoint.setTarget(null);
        this._endpoint.detach();
        while ((msg = this.receive(0L)) != null) {
            this.release(msg);
        }
    }

    public void drain() {
        this._endpoint.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainWait() {
        Object lock;
        Object object = lock = this._endpoint.getLock();
        synchronized (object) {
            try {
                while (this._prefetchQueue.peek() == null && !this._endpoint.isDrained() && !this._endpoint.isDetached()) {
                    lock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this._prefetchQueue.peek() == null && this._endpoint.isDrained();
    }

    public void clearDrain() {
        this._endpoint.clearDrain();
    }

    public void setCreditWithTransaction(UnsignedInteger credit, Transaction txn) {
        this._endpoint.setLinkCredit(credit);
        this._endpoint.setTransactionId((Object)(txn == null ? null : txn.getTxnId()));
        this._endpoint.setCreditWindow(false);
    }

    public void handle(Binary deliveryTag, DeliveryState state, Boolean settled) {
        SettledAction action;
        if (Boolean.TRUE.equals(settled) && (action = this._unsettledMap.remove(deliveryTag)) != null) {
            action.onSettled(deliveryTag);
        }
    }

    public Map<Binary, Outcome> getRemoteUnsettled() {
        return this._endpoint.getInitialUnsettledMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageArrivalListener(MessageArrivalListener messageArrivalListener) {
        Object object = this._endpoint.getLock();
        synchronized (object) {
            this._messageArrivalListener = messageArrivalListener;
            int prefetchSize = this._prefetchQueue.size();
            for (int i = 0; i < prefetchSize; ++i) {
                this.postPrefetchAction();
            }
        }
    }

    public Session getSession() {
        return this._session;
    }

    public Source getSource() {
        return this._endpoint.getSource();
    }

    public void setRemoteErrorListener(Runnable listener) {
        this._remoteErrorTask = listener;
    }

    public static interface MessageArrivalListener {
        public void messageArrived(Receiver var1);
    }

    public static interface SettledAction {
        public void onSettled(Binary var1);
    }
}

