/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.qpid.amqp_1_0.jms.Destination;
import org.apache.qpid.amqp_1_0.jms.Message;
import org.apache.qpid.amqp_1_0.jms.impl.DecodedDestination;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;
import org.apache.qpid.amqp_1_0.jms.impl.QueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TemporaryQueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TemporaryTopicImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TopicImpl;
import org.apache.qpid.amqp_1_0.messaging.MessageAttributes;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedByte;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.UnsignedShort;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

public abstract class MessageImpl
implements Message {
    static final Set<Class> _supportedClasses = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, byte[].class));
    static final Symbol JMS_TYPE = Symbol.valueOf((String)"x-opt-jms-type");
    static final Symbol TO_TYPE = Symbol.valueOf((String)"x-opt-to-type");
    static final Symbol REPLY_TO_TYPE = Symbol.valueOf((String)"x-opt-reply-type");
    static final String QUEUE_ATTRIBUTE = "queue";
    static final String TOPIC_ATTRIBUTE = "topic";
    static final String TEMPORARY_ATTRIBUTE = "temporary";
    static final Set<String> JMS_QUEUE_ATTRIBUTES = MessageImpl.set("queue");
    static final Set<String> JMS_TOPIC_ATTRIBUTES = MessageImpl.set("topic");
    static final Set<String> JMS_TEMP_QUEUE_ATTRIBUTES = MessageImpl.set("queue", "temporary");
    static final Set<String> JMS_TEMP_TOPIC_ATTRIBUTES = MessageImpl.set("topic", "temporary");
    private static final String JMSXGROUP_ID = "JMSXGroupID";
    private Header _header;
    private Properties _properties;
    private ApplicationProperties _applicationProperties;
    private Footer _footer;
    private final SessionImpl _sessionImpl;
    private boolean _readOnly;
    private MessageAnnotations _messageAnnotations;
    private boolean _isFromQueue;
    private boolean _isFromTopic;
    private long _expiration;
    private DestinationImpl _replyTo;

    protected MessageImpl(Header header, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties appProperties, Footer footer, SessionImpl session) {
        this._header = header == null ? new Header() : header;
        this._properties = properties == null ? new Properties() : properties;
        this._messageAnnotations = messageAnnotations == null ? new MessageAnnotations(new HashMap()) : messageAnnotations;
        this._footer = footer == null ? new Footer(Collections.EMPTY_MAP) : footer;
        this._applicationProperties = appProperties == null ? new ApplicationProperties(new HashMap()) : appProperties;
        this._sessionImpl = session;
    }

    public String getJMSMessageID() throws JMSException {
        Object messageId = this.getMessageId();
        return messageId == null ? null : "ID:" + messageId.toString();
    }

    public void setJMSMessageID(String messageId) throws InvalidJMSMEssageIdException {
        if (messageId == null) {
            this.setMessageId(null);
        } else if (messageId.startsWith("ID:")) {
            this.setMessageId(messageId.substring(3));
        } else {
            throw new InvalidJMSMEssageIdException(messageId);
        }
    }

    public long getJMSTimestamp() throws JMSException {
        Date transmitTime = this.getTransmitTime();
        return transmitTime == null ? 0L : transmitTime.getTime();
    }

    public void setJMSTimestamp(long l) throws JMSException {
        this.setTransmitTime(new Date(l));
        if (this._expiration != 0L) {
            this.setTtl(UnsignedInteger.valueOf((long)(this._expiration - this.getTransmitTime().getTime())));
        }
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        Object o = this.getCorrelationId();
        if (o instanceof Binary) {
            Binary correlationIdBinary = (Binary)o;
            byte[] correlationId = new byte[correlationIdBinary.getLength()];
            correlationIdBinary.asByteBuffer().get(correlationId);
            return correlationId;
        }
        return o == null ? null : o.toString().getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        if (correlationId == null) {
            this.setCorrelationId(null);
        } else {
            byte[] dup = new byte[correlationId.length];
            System.arraycopy(correlationId, 0, dup, 0, correlationId.length);
            this.setCorrelationId(new Binary(dup));
        }
    }

    public void setJMSCorrelationID(String s) throws JMSException {
        this.getProperties().setCorrelationId((Object)s);
    }

    public String getJMSCorrelationID() throws JMSException {
        Object o = this.getProperties().getCorrelationId();
        if (o instanceof Binary) {
            Binary id = (Binary)o;
            return new String(id.getArray(), id.getArrayOffset(), id.getLength());
        }
        return o == null ? null : o.toString();
    }

    @Override
    public DestinationImpl getJMSReplyTo() throws JMSException {
        return this._replyTo != null ? this._replyTo : this.toDestination(this.getReplyTo(), this.splitCommaSeparateSet((String)this.getMessageAnnotation(REPLY_TO_TYPE)));
    }

    public void setJMSReplyTo(javax.jms.Destination destination) throws NonAMQPDestinationException {
        this._replyTo = (DestinationImpl)destination;
        if (destination == null) {
            this.setReplyTo(null);
            this.messageAnnotationMap().remove(REPLY_TO_TYPE);
        } else if (this._replyTo.getLocalTerminus() != null) {
            this.setReplyTo(this._replyTo.getLocalTerminus());
        } else {
            DecodedDestination dd = this.toDecodedDestination(destination);
            this.setReplyTo(dd.getAddress());
            this.messageAnnotationMap().put(REPLY_TO_TYPE, MessageImpl.join(",", dd.getAttributes()));
        }
    }

    @Override
    public DestinationImpl getJMSDestination() throws JMSException {
        Set<String> type = this.splitCommaSeparateSet((String)this.getMessageAnnotation(TO_TYPE));
        if (type == null) {
            if (this._isFromQueue) {
                type = JMS_QUEUE_ATTRIBUTES;
            } else if (this._isFromTopic) {
                type = JMS_TOPIC_ATTRIBUTES;
            }
        }
        return this.toDestination(this.getTo(), type);
    }

    public void setJMSDestination(javax.jms.Destination destination) throws NonAMQPDestinationException {
        if (destination == null) {
            this.setTo(null);
            this.messageAnnotationMap().remove(TO_TYPE);
        } else {
            DecodedDestination dd = this.toDecodedDestination(destination);
            this.setTo(dd.getAddress());
            this.messageAnnotationMap().put(TO_TYPE, MessageImpl.join(",", dd.getAttributes()));
        }
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (Boolean.FALSE.equals(this.getDurable())) {
            return 1;
        }
        return 2;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        switch (deliveryMode) {
            case 1: {
                this.setDurable(false);
                break;
            }
            case 2: {
                this.setDurable(true);
                break;
            }
        }
    }

    public boolean getJMSRedelivered() {
        UnsignedInteger failures = this.getDeliveryFailures();
        return failures != null && failures.intValue() != 0;
    }

    public void setJMSRedelivered(boolean redelivered) {
        UnsignedInteger failures = this.getDeliveryFailures();
        if (redelivered) {
            if (failures == null || UnsignedInteger.ZERO.equals((Object)failures)) {
                this.setDeliveryFailures(UnsignedInteger.ONE);
            }
        } else {
            this.setDeliveryFailures(null);
        }
    }

    public String getJMSType() throws JMSException {
        Object attrValue = this.getMessageAnnotation(JMS_TYPE);
        return attrValue instanceof String ? attrValue.toString() : null;
    }

    public void setJMSType(String s) throws JMSException {
        this.messageAnnotationMap().put(JMS_TYPE, s);
    }

    public long getJMSExpiration() throws JMSException {
        UnsignedInteger ttl = this.getTtl();
        return ttl == null || ttl.longValue() == 0L ? 0L : this.getJMSTimestamp() + ttl.longValue();
    }

    public void setJMSExpiration(long l) throws JMSException {
        this._expiration = l;
        if (l == 0L) {
            this.setTtl(UnsignedInteger.ZERO);
        } else {
            if (this.getTransmitTime() == null) {
                this.setTransmitTime(new Date());
            }
            this.setTtl(UnsignedInteger.valueOf((long)(l - this.getTransmitTime().getTime())));
        }
    }

    public int getJMSPriority() throws JMSException {
        UnsignedByte priority = this.getPriority();
        return priority == null ? 4 : priority.intValue();
    }

    public void setJMSPriority(int i) throws InvalidJMSPriorityException {
        if (i < 0 || i > 255) {
            throw new InvalidJMSPriorityException(i);
        }
        this.setPriority(UnsignedByte.valueOf((byte)((byte)i)));
    }

    public void clearProperties() throws JMSException {
        this._applicationProperties.getValue().clear();
    }

    public boolean propertyExists(String s) throws JMSException {
        return this.propertyExists((Object)s);
    }

    public boolean getBooleanProperty(String s) throws JMSException {
        return this.getBooleanProperty((Object)s);
    }

    public byte getByteProperty(String s) throws JMSException {
        return this.getByteProperty((Object)s);
    }

    public short getShortProperty(String s) throws JMSException {
        return this.getShortProperty((Object)s);
    }

    public int getIntProperty(String s) throws JMSException {
        return this.getIntProperty((Object)s);
    }

    public long getLongProperty(String s) throws JMSException {
        return this.getLongProperty((Object)s);
    }

    public float getFloatProperty(String s) throws JMSException {
        return this.getFloatProperty((Object)s);
    }

    public double getDoubleProperty(String s) throws JMSException {
        return this.getDoubleProperty((Object)s);
    }

    public String getStringProperty(String s) throws JMSException {
        return this.getStringProperty((Object)s);
    }

    public Object getObjectProperty(String s) throws JMSException {
        return this.getObjectProperty((Object)s);
    }

    @Override
    public boolean propertyExists(Object name) throws JMSException {
        return this._applicationProperties.getValue().containsKey(name);
    }

    @Override
    public boolean getBooleanProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String || value == null) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to boolean.");
    }

    @Override
    public byte getByteProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String || value == null) {
            return Byte.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to byte.");
    }

    @Override
    public short getShortProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof String || value == null) {
            return Short.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to short.");
    }

    private Object getProperty(Object name) {
        if (JMSXGROUP_ID.equals(name)) {
            return this._properties.getGroupId();
        }
        return this._applicationProperties.getValue().get(name);
    }

    @Override
    public int getIntProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String || value == null) {
            return Integer.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to int.");
    }

    @Override
    public long getLongProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String || value == null) {
            return Long.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to long.");
    }

    @Override
    public float getFloatProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String || value == null) {
            return Float.valueOf((String)value).floatValue();
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to float.");
    }

    @Override
    public double getDoubleProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof String || value == null) {
            return Double.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to double.");
    }

    @Override
    public String getStringProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof String || value == null) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            throw new MessageFormatException("Property " + name + " of type byte[] " + "cannot be converted to String.");
        }
        return value.toString();
    }

    @Override
    public Object getObjectProperty(Object name) throws JMSException {
        return this.getProperty(name);
    }

    @Override
    public List<Object> getListProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof List || value == null) {
            return (List)value;
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to List.");
    }

    @Override
    public Map<Object, Object> getMapProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof Map || value == null) {
            return (Map)value;
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to Map.");
    }

    @Override
    public UnsignedByte getUnsignedByteProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof UnsignedByte) {
            return (UnsignedByte)value;
        }
        if (value instanceof String || value == null) {
            return UnsignedByte.valueOf((String)((String)value));
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to UnsignedByte.");
    }

    @Override
    public UnsignedShort getUnsignedShortProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof UnsignedShort) {
            return (UnsignedShort)value;
        }
        if (value instanceof UnsignedByte) {
            return UnsignedShort.valueOf((short)((UnsignedByte)value).shortValue());
        }
        if (value instanceof String || value == null) {
            return UnsignedShort.valueOf((String)((String)value));
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to UnsignedShort.");
    }

    @Override
    public UnsignedInteger getUnsignedIntProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof UnsignedInteger) {
            return (UnsignedInteger)value;
        }
        if (value instanceof UnsignedByte) {
            return UnsignedInteger.valueOf((int)((UnsignedByte)value).intValue());
        }
        if (value instanceof UnsignedShort) {
            return UnsignedInteger.valueOf((int)((UnsignedShort)value).intValue());
        }
        if (value instanceof String || value == null) {
            return UnsignedInteger.valueOf((String)((String)value));
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to UnsignedShort.");
    }

    @Override
    public UnsignedLong getUnsignedLongProperty(Object name) throws JMSException {
        Object value = this.getProperty(name);
        if (value instanceof UnsignedLong) {
            return (UnsignedLong)value;
        }
        if (value instanceof UnsignedByte) {
            return UnsignedLong.valueOf((long)((UnsignedByte)value).longValue());
        }
        if (value instanceof UnsignedShort) {
            return UnsignedLong.valueOf((long)((UnsignedShort)value).longValue());
        }
        if (value instanceof UnsignedInteger) {
            return UnsignedLong.valueOf((long)((UnsignedInteger)value).longValue());
        }
        if (value instanceof String || value == null) {
            return UnsignedLong.valueOf((String)((String)value));
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to UnsignedShort.");
    }

    public Enumeration getPropertyNames() throws JMSException {
        ArrayList<String> names = new ArrayList<String>();
        for (Object key : this._applicationProperties.getValue().keySet()) {
            if (!(key instanceof String)) continue;
            names.add((String)key);
        }
        if (this._properties.getGroupId() != null) {
            names.add(JMSXGROUP_ID);
        }
        return Collections.enumeration(names);
    }

    public void setBooleanProperty(String s, boolean b) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        this.setBooleanProperty((Object)s, b);
    }

    protected void checkPropertyName(CharSequence propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        this.checkIdentiferFormat(propertyName);
    }

    protected void checkIdentiferFormat(CharSequence propertyName) {
        if (!Character.isJavaIdentifierStart(propertyName.charAt(0))) {
            throw new IllegalArgumentException("Identifier '" + propertyName + "' does not start with a valid JMS identifier start character");
        }
        int length = propertyName.length();
        for (int c = 1; c < length; ++c) {
            if (Character.isJavaIdentifierPart(propertyName.charAt(c))) continue;
            throw new IllegalArgumentException("Identifier '" + propertyName + "' contains an invalid JMS identifier character");
        }
        if (propertyName.equals("NULL") || propertyName.equals("TRUE") || propertyName.equals("FALSE") || propertyName.equals("NOT") || propertyName.equals("AND") || propertyName.equals("OR") || propertyName.equals("BETWEEN") || propertyName.equals("LIKE") || propertyName.equals("IN") || propertyName.equals("IS") || propertyName.equals("ESCAPE")) {
            throw new IllegalArgumentException("Identifier '" + propertyName + "' is not allowed in JMS");
        }
    }

    public void setByteProperty(String s, byte b) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        this.setByteProperty((Object)s, b);
    }

    public void setShortProperty(String s, short i) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        this.setShortProperty((Object)s, i);
    }

    public void setIntProperty(String s, int i) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        this.setIntProperty((Object)s, i);
    }

    public void setLongProperty(String s, long l) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        this.setLongProperty((Object)s, l);
    }

    public void setFloatProperty(String s, float v) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        this.setFloatProperty((Object)s, v);
    }

    public void setDoubleProperty(String s, double v) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        this.setDoubleProperty((Object)s, v);
    }

    public void setStringProperty(String s, String s1) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        this.setStringProperty((Object)s, s1);
    }

    public void setObjectProperty(String s, Object o) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(s);
        if (o == null || !_supportedClasses.contains(o.getClass())) {
            throw new MessageFormatException("Cannot call setObjectProperty with a value of " + (o == null ? "null" : " class " + o.getClass().getName()) + ".");
        }
        this.setObjectProperty((Object)s, o);
    }

    @Override
    public void setBooleanProperty(Object name, boolean b) {
        this.setProperty(name, b);
    }

    @Override
    public void setByteProperty(Object name, byte b) {
        this.setProperty(name, b);
    }

    @Override
    public void setShortProperty(Object name, short i) {
        this.setProperty(name, i);
    }

    @Override
    public void setIntProperty(Object name, int i) {
        this.setProperty(name, i);
    }

    @Override
    public void setLongProperty(Object name, long l) {
        this.setProperty(name, l);
    }

    @Override
    public void setFloatProperty(Object name, float v) {
        this.setProperty(name, Float.valueOf(v));
    }

    @Override
    public void setDoubleProperty(Object name, double v) {
        this.setProperty(name, v);
    }

    @Override
    public void setStringProperty(Object name, String value) {
        this.setProperty(name, value);
    }

    @Override
    public void setObjectProperty(Object name, Object value) {
        this.setProperty(name, value);
    }

    private void setProperty(Object name, Object value) {
        if (JMSXGROUP_ID.equals(name)) {
            this._properties.setGroupId(value == null ? null : value.toString());
        } else {
            this._applicationProperties.getValue().put(name, value);
        }
    }

    @Override
    public void setListProperty(Object name, List<Object> list) {
        this.setProperty(name, list);
    }

    @Override
    public void setMapProperty(Object name, Map<Object, Object> map) {
        this.setProperty(name, map);
    }

    @Override
    public void setUnsignedByteProperty(Object name, UnsignedByte b) {
        this.setProperty(name, b);
    }

    @Override
    public void setUnsignedShortProperty(Object name, UnsignedShort s) {
        this.setProperty(name, s);
    }

    @Override
    public void setUnsignedIntProperty(Object name, UnsignedInteger i) {
        this.setProperty(name, i);
    }

    @Override
    public void setUnsignedLongProperty(Object name, UnsignedLong l) {
        this.setProperty(name, l);
    }

    @Override
    public UnsignedInteger getDeliveryFailures() {
        return this._header.getDeliveryCount();
    }

    @Override
    public void setDeliveryFailures(UnsignedInteger failures) {
        this._header.setDeliveryCount(failures);
    }

    @Override
    public MessageAttributes getHeaderMessageAttrs() {
        return null;
    }

    @Override
    public void setHeaderMessageAttrs(MessageAttributes messageAttrs) {
    }

    @Override
    public MessageAttributes getHeaderDeliveryAttrs() {
        return null;
    }

    @Override
    public void setHeaderDeliveryAttrs(MessageAttributes deliveryAttrs) {
    }

    @Override
    public Boolean getDurable() {
        return this._header.getDurable();
    }

    @Override
    public void setDurable(Boolean durable) {
        this._header.setDurable(durable);
    }

    @Override
    public UnsignedByte getPriority() {
        return this._header.getPriority();
    }

    @Override
    public void setPriority(UnsignedByte priority) {
        this._header.setPriority(priority);
    }

    @Override
    public Date getTransmitTime() {
        return this._properties.getCreationTime();
    }

    @Override
    public void setTransmitTime(Date transmitTime) {
        this._properties.setCreationTime(transmitTime);
    }

    @Override
    public UnsignedInteger getTtl() {
        return this._header.getTtl();
    }

    @Override
    public void setTtl(UnsignedInteger ttl) {
        this._header.setTtl(ttl);
    }

    @Override
    public UnsignedInteger getFormerAcquirers() {
        return this._header.getDeliveryCount();
    }

    @Override
    public void setFormerAcquirers(UnsignedInteger formerAcquirers) {
        this._header.setDeliveryCount(formerAcquirers);
    }

    @Override
    public Object getMessageId() {
        return this._properties.getMessageId();
    }

    @Override
    public void setMessageId(Object messageId) {
        this._properties.setMessageId(messageId);
    }

    @Override
    public Binary getUserId() {
        return this._properties.getUserId();
    }

    @Override
    public void setUserId(Binary userId) {
        this._properties.setUserId(userId);
    }

    @Override
    public String getTo() {
        return this._properties.getTo();
    }

    @Override
    public void setTo(String to) {
        this._properties.setTo(to);
    }

    @Override
    public String getSubject() {
        return this._properties.getSubject();
    }

    @Override
    public void setSubject(String subject) {
        this._properties.setSubject(subject);
    }

    @Override
    public String getReplyTo() {
        return this._properties.getReplyTo();
    }

    @Override
    public void setReplyTo(String replyTo) {
        this._properties.setReplyTo(replyTo);
    }

    @Override
    public Object getCorrelationId() {
        return this._properties.getCorrelationId();
    }

    @Override
    public void setCorrelationId(Binary correlationId) {
        this._properties.setCorrelationId((Object)correlationId);
    }

    @Override
    public Symbol getContentType() {
        return this._properties.getContentType();
    }

    @Override
    public void setContentType(Symbol contentType) {
        this._properties.setContentType(contentType);
    }

    public void acknowledge() throws JMSException {
        this._sessionImpl.acknowledgeAll();
    }

    public void clearBody() throws JMSException {
        this._readOnly = false;
    }

    protected boolean isReadOnly() {
        return this._readOnly;
    }

    protected void checkReadable() throws MessageNotReadableException {
        if (!this.isReadOnly()) {
            throw new MessageNotReadableException("You need to call reset() to make the message readable");
        }
    }

    protected void checkWritable() throws MessageNotWriteableException {
        if (this.isReadOnly()) {
            throw new MessageNotWriteableException("You need to call clearBody() to make the message writable");
        }
    }

    public void setReadOnly() {
        this._readOnly = true;
    }

    Header getHeader() {
        return this._header;
    }

    Properties getProperties() {
        return this._properties;
    }

    Footer getFooter() {
        return this._footer;
    }

    MessageAnnotations getMessageAnnotations() {
        return this._messageAnnotations;
    }

    public ApplicationProperties getApplicationProperties() {
        return this._applicationProperties;
    }

    public void reset() throws JMSException {
        this._readOnly = true;
    }

    void setFromQueue(boolean fromQueue) {
        this._isFromQueue = fromQueue;
    }

    void setFromTopic(boolean fromTopic) {
        this._isFromTopic = fromTopic;
    }

    abstract Collection<Section> getSections();

    DecodedDestination toDecodedDestination(javax.jms.Destination destination) throws NonAMQPDestinationException {
        if (destination == null) {
            return null;
        }
        if (destination instanceof DestinationImpl) {
            return this._sessionImpl.getConnection().toDecodedDestination((DestinationImpl)destination);
        }
        throw new NonAMQPDestinationException(destination);
    }

    DestinationImpl toDestination(String address, Set<String> kind) {
        if (address == null) {
            return null;
        }
        DecodedDestination decoded = this._sessionImpl.getConnection().toDecodedDestination(address, kind);
        address = decoded.getAddress();
        kind = decoded.getAttributes();
        if (kind == null) {
            return DestinationImpl.valueOf(address);
        }
        if (kind.contains(QUEUE_ATTRIBUTE)) {
            if (kind.contains(TEMPORARY_ATTRIBUTE)) {
                return new TemporaryQueueImpl(address, null, this._sessionImpl);
            }
            return QueueImpl.valueOf(address);
        }
        if (kind.contains(TOPIC_ATTRIBUTE)) {
            if (kind.contains(TEMPORARY_ATTRIBUTE)) {
                return new TemporaryTopicImpl(address, null, this._sessionImpl);
            }
            return TopicImpl.valueOf(address);
        }
        return DestinationImpl.valueOf(address);
    }

    private Object getMessageAnnotation(Symbol key) {
        Map messageAttrs = this._messageAnnotations == null ? null : this._messageAnnotations.getValue();
        return messageAttrs == null ? null : messageAttrs.get(key);
    }

    private Map messageAnnotationMap() {
        HashMap messageAttrs;
        HashMap hashMap = messageAttrs = this._messageAnnotations == null ? null : this._messageAnnotations.getValue();
        if (messageAttrs == null) {
            messageAttrs = new HashMap();
            this._messageAnnotations = new MessageAnnotations(messageAttrs);
        }
        return messageAttrs;
    }

    Set<String> splitCommaSeparateSet(String value) {
        if (value == null) {
            return null;
        }
        HashSet<String> rc = new HashSet<String>();
        for (String x : value.split("\\s*,\\s*")) {
            rc.add(x);
        }
        return rc;
    }

    private static Set<String> set(String ... args) {
        HashSet<String> s = new HashSet<String>();
        for (String arg : args) {
            s.add(arg);
        }
        return Collections.unmodifiableSet(s);
    }

    static final String join(String sep, Iterable items) {
        StringBuilder result = new StringBuilder();
        for (Object o : items) {
            if (result.length() > 0) {
                result.append(sep);
            }
            result.append(o.toString());
        }
        return result.toString();
    }

    private class InvalidJMSPriorityException
    extends JMSException {
        public InvalidJMSPriorityException(int priority) {
            super("The provided priority: " + priority + " is not valid in AMQP, valid values are from 0 to 255");
        }
    }

    private class NonAMQPDestinationException
    extends JMSException {
        public NonAMQPDestinationException(javax.jms.Destination destination) {
            super("Destinations not a valid AMQP Destination, class of type: '" + destination.getClass().getName() + "', require '" + Destination.class.getName() + "'.");
        }
    }

    private static class InvalidJMSMEssageIdException
    extends JMSException {
        public InvalidJMSMEssageIdException(String messageId) {
            super("Invalid JMSMessageID: '" + messageId + "', JMSMessageID MUST start with 'ID:'");
        }
    }
}

