/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import org.fusesource.mq.JMSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerThread.class);
    int messageCount = 1000;
    String dest;
    protected JMSService service;
    int sleep = 0;
    int sentCount = 0;
    int transactions = 0;
    boolean persistent = true;
    int messageSize = 0;
    byte[] payload = null;
    int transactionBatchSize;
    boolean running = false;

    public ProducerThread(JMSService service, String dest) {
        this.dest = dest;
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MessageProducer producer = null;
        try {
            producer = this.service.createProducer(this.dest);
            producer.setDeliveryMode(this.persistent ? 2 : 1);
            this.initPayLoad();
            this.running = true;
            this.sentCount = 0;
            while (this.sentCount < this.messageCount) {
                if (!this.running) {
                    break;
                }
                Message message = this.createMessage(this.sentCount);
                producer.send(message);
                LOG.info("Sent: " + (message instanceof TextMessage ? ((TextMessage)message).getText() : message.getJMSMessageID()));
                if (this.transactionBatchSize > 0 && this.sentCount > 0 && this.sentCount % this.transactionBatchSize == 0) {
                    LOG.info("Committing transaction: " + this.transactions++);
                    this.service.getDefaultSession().commit();
                }
                if (this.sleep > 0) {
                    Thread.sleep(this.sleep);
                }
                ++this.sentCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
        LOG.info("Producer thread finished");
    }

    private void initPayLoad() {
        if (this.messageSize > 0) {
            this.payload = new byte[this.messageSize];
            for (int i = 0; i < this.payload.length; ++i) {
                this.payload[i] = 46;
            }
        }
    }

    protected Message createMessage(int i) throws Exception {
        if (this.payload != null) {
            return this.service.createBytesMessage(this.payload);
        }
        return this.service.createTextMessage("test message: " + i);
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public int getSentCount() {
        return this.sentCount;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setMessageSize(int size) {
        this.messageSize = size;
    }

    public void setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

