/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.fabric;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiDiscoveryAgent
implements DiscoveryAgent {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiDiscoveryAgent.class);
    private AtomicBoolean running = new AtomicBoolean();
    private final AtomicReference<DiscoveryListener> discoveryListener = new AtomicReference();
    private final HashMap<String, SimpleDiscoveryEvent> discoveredServices = new HashMap();
    private final AtomicInteger startCounter = new AtomicInteger(0);
    private Thread thread;
    private long updateInterval = 10000L;
    private long initialReconnectDelay = 1000L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private int maxReconnectAttempts = 0;
    private final Object sleepMutex = new Object();
    private long minConnectTime = 5000L;
    private String propertyName;

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void registerService(String service) throws IOException {
        throw new UnsupportedOperationException();
    }

    private synchronized Set<String> doLookup(long freshness) {
        ServiceReference reference;
        HashSet<String> rc = new HashSet<String>();
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        if (context != null && (reference = context.getServiceReference(ConfigurationAdmin.class.getName())) != null) {
            ConfigurationAdmin ca = (ConfigurationAdmin)context.getService(reference);
            try {
                Configuration config = ca.getConfiguration(this.propertyName);
                Dictionary properties = config.getProperties();
                if (properties != null) {
                    Enumeration keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (!key.startsWith("broker.url.")) continue;
                        rc.add(((String)properties.get(key)).trim());
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return rc;
    }

    public void serviceFailed(DiscoveryEvent devent) throws IOException {
        final SimpleDiscoveryEvent event = (SimpleDiscoveryEvent)devent;
        if (event.failed.compareAndSet(false, true)) {
            this.discoveryListener.get().onServiceRemove((DiscoveryEvent)event);
            if (!event.removed.get()) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (event.connectTime + OsgiDiscoveryAgent.this.minConnectTime > System.currentTimeMillis()) {
                            LOG.debug("Failure occured soon after the discovery event was generated.  It will be clasified as a connection failure: " + (Object)((Object)event));
                            event.connectFailures++;
                            if (OsgiDiscoveryAgent.this.maxReconnectAttempts > 0 && event.connectFailures >= OsgiDiscoveryAgent.this.maxReconnectAttempts) {
                                LOG.debug("Reconnect attempts exceeded " + OsgiDiscoveryAgent.this.maxReconnectAttempts + " tries.  Reconnecting has been disabled.");
                                return;
                            }
                            Object object = OsgiDiscoveryAgent.this.sleepMutex;
                            synchronized (object) {
                                try {
                                    if (!OsgiDiscoveryAgent.this.running.get() || event.removed.get()) {
                                        return;
                                    }
                                    LOG.debug("Waiting " + event.reconnectDelay + " ms before attepting to reconnect.");
                                    OsgiDiscoveryAgent.this.sleepMutex.wait(event.reconnectDelay);
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                            }
                            if (!OsgiDiscoveryAgent.this.useExponentialBackOff) {
                                event.reconnectDelay = OsgiDiscoveryAgent.this.initialReconnectDelay;
                            } else {
                                event.reconnectDelay *= OsgiDiscoveryAgent.this.backOffMultiplier;
                                if (event.reconnectDelay > OsgiDiscoveryAgent.this.maxReconnectDelay) {
                                    event.reconnectDelay = OsgiDiscoveryAgent.this.maxReconnectDelay;
                                }
                            }
                        } else {
                            event.connectFailures = 0;
                            event.reconnectDelay = OsgiDiscoveryAgent.this.initialReconnectDelay;
                        }
                        if (!OsgiDiscoveryAgent.this.running.get() || event.removed.get()) {
                            return;
                        }
                        event.connectTime = System.currentTimeMillis();
                        event.failed.set(false);
                        ((DiscoveryListener)OsgiDiscoveryAgent.this.discoveryListener.get()).onServiceAdd((DiscoveryEvent)event);
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public void setDiscoveryListener(DiscoveryListener discoveryListener) {
        this.discoveryListener.set(discoveryListener);
    }

    public void start() throws Exception {
        if (this.startCounter.addAndGet(1) == 1) {
            this.running.set(true);
            this.thread = new Thread("HTTPDiscovery Agent"){

                @Override
                public void run() {
                    while (OsgiDiscoveryAgent.this.running.get()) {
                        try {
                            OsgiDiscoveryAgent.this.update();
                            Thread.sleep(OsgiDiscoveryAgent.this.updateInterval);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Set<String> activeServices;
        DiscoveryListener discoveryListener = this.discoveryListener.get();
        if (discoveryListener != null && (activeServices = this.doLookup(this.updateInterval * 3L)) != null) {
            HashMap<String, SimpleDiscoveryEvent> hashMap = this.discoveredServices;
            synchronized (hashMap) {
                SimpleDiscoveryEvent e;
                HashSet<String> removedServices = new HashSet<String>(this.discoveredServices.keySet());
                removedServices.removeAll(activeServices);
                HashSet<String> addedServices = new HashSet<String>(activeServices);
                addedServices.removeAll(this.discoveredServices.keySet());
                addedServices.removeAll(removedServices);
                for (String service : addedServices) {
                    e = new SimpleDiscoveryEvent(service);
                    this.discoveredServices.put(service, e);
                    discoveryListener.onServiceAdd((DiscoveryEvent)e);
                }
                for (String service : removedServices) {
                    e = this.discoveredServices.remove(service);
                    if (e != null) {
                        e.removed.set(true);
                    }
                    discoveryListener.onServiceRemove((DiscoveryEvent)e);
                }
            }
        }
    }

    public void stop() throws Exception {
        if (this.startCounter.decrementAndGet() == 0) {
            this.running.set(false);
            if (this.thread != null) {
                this.thread.join(this.updateInterval * 3L);
                this.thread = null;
            }
        }
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    class SimpleDiscoveryEvent
    extends DiscoveryEvent {
        private int connectFailures;
        private long reconnectDelay;
        private long connectTime;
        private AtomicBoolean failed;
        private AtomicBoolean removed;

        public SimpleDiscoveryEvent(String service) {
            super(service);
            this.reconnectDelay = OsgiDiscoveryAgent.this.initialReconnectDelay;
            this.connectTime = System.currentTimeMillis();
            this.failed = new AtomicBoolean(false);
            this.removed = new AtomicBoolean(false);
        }
    }
}

