/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.fabric;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.URISupport;
import org.fusesource.mq.fabric.FabricDiscoveryAgent;
import org.fusesource.mq.fabric.OsgiFabricDiscoveryAgent;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricDiscoveryAgentFactory
extends DiscoveryAgentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FabricDiscoveryAgentFactory.class);

    protected DiscoveryAgent doCreateDiscoveryAgent(URI uri) throws IOException {
        try {
            FabricDiscoveryAgent rc = null;
            boolean osgi = false;
            try {
                if (OsgiUtil.isOsgi()) {
                    LOG.info("OSGi environment detected!");
                    osgi = true;
                }
            }
            catch (NoClassDefFoundError ignore) {
                // empty catch block
            }
            rc = osgi ? OsgiUtil.createOsgiDiscoveryAgent() : new FabricDiscoveryAgent();
            if (uri.getSchemeSpecificPart() != null && uri.getSchemeSpecificPart().length() > 0) {
                String ssp = URISupport.stripPrefix((String)uri.getSchemeSpecificPart(), (String)"//");
                Map query = URISupport.parseQuery((String)ssp);
                String groupName = ssp.split("\\?")[0];
                if (query.get("id") != null) {
                    rc.setId((String)query.get("id"));
                }
                rc.setGroupName(groupName);
            }
            return rc;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create((String)("Could not create discovery agent: " + uri), (Throwable)e);
        }
    }

    static class OsgiUtil {
        OsgiUtil() {
        }

        static boolean isOsgi() {
            return FrameworkUtil.getBundle(FabricDiscoveryAgentFactory.class) != null;
        }

        static FabricDiscoveryAgent createOsgiDiscoveryAgent() {
            return new OsgiFabricDiscoveryAgent();
        }
    }
}

