/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.itests;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.ContainerProxy;
import io.fabric8.itests.paxexam.support.Provision;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.apache.karaf.tooling.exam.options.LogLevelOption;
import org.fusesource.mq.fabric.FabricDiscoveryAgent;
import org.fusesource.mq.itests.MQTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class GracefullFailOverTest
extends MQTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQCreateWithFailover() throws Exception {
        String brokerName = "testBroker";
        String groupName = "testGroup";
        final Semaphore semaphore = new Semaphore(0);
        System.out.println(GracefullFailOverTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
            FabricDiscoveryAgent discoveryAgent = new FabricDiscoveryAgent();
            discoveryAgent.setCurator(curator);
            discoveryAgent.setGroupName("testGroup");
            discoveryAgent.setDiscoveryListener(new DiscoveryListener(){

                public void onServiceAdd(DiscoveryEvent discoveryEvent) {
                    System.out.println("Service added:" + discoveryEvent.getServiceName());
                    semaphore.release(1);
                }

                public void onServiceRemove(DiscoveryEvent discoveryEvent) {
                }
            });
            discoveryAgent.start();
            Set<ContainerProxy> containers = this.setupCluster((ServiceProxy<FabricService>)fabricProxy, "testGroup", "testBroker");
            try {
                System.out.println(GracefullFailOverTest.executeCommand((String)"fabric:container-list"));
                for (int i = 0; i < 2; ++i) {
                    System.out.println("Waiting for master.");
                    semaphore.tryAcquire(30L, TimeUnit.SECONDS);
                    semaphore.drainPermits();
                    System.out.println(GracefullFailOverTest.executeCommand((String)"fabric:cluster-list | grep -A 1 testGroup"));
                    FabricDiscoveryAgent.ActiveMQNode master = (FabricDiscoveryAgent.ActiveMQNode)discoveryAgent.getGroup().master();
                    Assert.assertNotNull((Object)master);
                    String masterName = master.getContainer();
                    Assert.assertNotNull((Object)master.getContainer());
                    System.out.println("Causing the master: " + masterName + " to failover.");
                    this.failOver(fabricService, masterName);
                    System.out.println("Waiting for failover.");
                    semaphore.tryAcquire(30L, TimeUnit.SECONDS);
                    semaphore.drainPermits();
                    System.out.println(GracefullFailOverTest.executeCommand((String)"fabric:cluster-list | grep -A 1 testGroup"));
                    master = (FabricDiscoveryAgent.ActiveMQNode)discoveryAgent.getGroup().master();
                    masterName = master.getContainer();
                    Assert.assertNotNull((Object)master.getContainer());
                    System.out.println("Causing the master: " + masterName + " to failover.");
                    this.failOver(fabricService, masterName);
                }
            }
            finally {
                ContainerBuilder.destroy(containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    Set<ContainerProxy> setupCluster(ServiceProxy<FabricService> fabricProxy, String groupName, String brokerName) throws Exception {
        System.out.println(GracefullFailOverTest.executeCommand((String)("fabric:mq-create --group " + groupName + " " + brokerName)));
        String profileName = "mq-broker-" + groupName + "." + brokerName;
        return ContainerBuilder.child(fabricProxy, (int)2).withName("child").withProfiles(profileName).assertProvisioningResult().build();
    }

    void failOver(FabricService fabricService, String container) throws Exception {
        Container masterContainer = fabricService.getContainer(container);
        masterContainer.stop();
        masterContainer.start();
        Provision.provisioningSuccess(Arrays.asList(masterContainer), (Long)PROVISION_TIMEOUT);
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.mqDistributionConfiguration()), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO)};
    }
}

