/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.web.BrokerFacade;
import org.apache.activemq.web.DestinationFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class MoveMessage
extends DestinationFacade
implements Controller {
    private String messageId;
    private String destination;
    private static final Logger log = LoggerFactory.getLogger(MoveMessage.class);

    public MoveMessage(BrokerFacade brokerFacade) {
        super(brokerFacade);
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.messageId != null) {
            QueueViewMBean queueView = this.getQueueView();
            if (queueView != null) {
                log.info("Moving message " + this.getJMSDestination() + "(" + this.messageId + ")" + " to " + this.destination);
                queueView.moveMessageTo(this.messageId, this.destination);
            } else {
                log.warn("No queue named: " + this.getPhysicalDestinationName());
            }
        }
        return this.redirectToBrowseView();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

