/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.impl;

import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.FeatureUpdate;
import io.fabric8.patch.management.Utils;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class Presentation {
    private Presentation() {
    }

    public static void displayBundleUpdates(Collection<BundleUpdate> updatesForBundleKeys, boolean install) {
        BundleUpdate be;
        int l1 = "[symbolic name]".length();
        int l2 = "[version]".length();
        int l3 = install ? "[new location]".length() : "[previous location]".length();
        int tu = 0;
        int tuf = 0;
        int tk = 0;
        int tkf = 0;
        TreeMap<String, BundleUpdate> map = new TreeMap<String, BundleUpdate>();
        for (BundleUpdate bundleUpdate : updatesForBundleKeys) {
            String version;
            String sn = Utils.stripSymbolicName((String)bundleUpdate.getSymbolicName());
            if (sn.length() > l1) {
                l1 = sn.length();
            }
            if (install) {
                String string = version = bundleUpdate.getPreviousVersion() == null ? "<update>" : bundleUpdate.getPreviousVersion();
                if (version.length() > l2) {
                    l2 = version.length();
                }
            } else {
                String string = version = bundleUpdate.getNewVersion() == null ? bundleUpdate.getPreviousVersion() : bundleUpdate.getNewVersion();
                if (version.length() > l2) {
                    l2 = version.length();
                }
            }
            if (install) {
                String newLocation;
                String string = newLocation = bundleUpdate.getNewLocation() == null ? "<reinstall>" : bundleUpdate.getNewLocation();
                if (newLocation.length() > l3) {
                    l3 = newLocation.length();
                }
            } else {
                String previousLocation = bundleUpdate.getPreviousLocation();
                if (previousLocation.length() > l3) {
                    l3 = previousLocation.length();
                }
            }
            if (bundleUpdate.getNewLocation() != null) {
                if (bundleUpdate.isIndependent()) {
                    ++tu;
                } else {
                    ++tuf;
                }
            } else if (bundleUpdate.isIndependent()) {
                ++tk;
            } else {
                ++tkf;
            }
            map.put(bundleUpdate.getSymbolicName(), bundleUpdate);
        }
        if (tu > 0) {
            System.out.printf("========== Bundles to %s (%d):%n", install ? "update" : "downgrade", tu);
            System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", "[symbolic name]", "[version]", install ? "[new location]" : "[previous location]");
            for (Map.Entry entry : map.entrySet()) {
                be = (BundleUpdate)entry.getValue();
                if (!be.isIndependent() || be.getNewLocation() == null) continue;
                Object[] objectArray = new Object[3];
                objectArray[0] = Utils.stripSymbolicName((String)be.getSymbolicName());
                objectArray[1] = install ? (be.getPreviousVersion() == null ? "<update>" : be.getPreviousVersion()) : be.getNewVersion();
                objectArray[2] = install ? be.getNewLocation() : be.getPreviousLocation();
                System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", objectArray);
            }
        }
        if (tuf > 0) {
            System.out.printf("========== Bundles to %s as part of features or core bundles (%d):%n", install ? "update" : "downgrade", tuf);
            System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", "[symbolic name]", "[version]", install ? "[new location]" : "[previous location]");
            for (Map.Entry entry : map.entrySet()) {
                be = (BundleUpdate)entry.getValue();
                if (be.isIndependent() || be.getNewLocation() == null) continue;
                System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", Utils.stripSymbolicName((String)be.getSymbolicName()), install ? be.getPreviousVersion() : be.getNewVersion(), install ? be.getNewLocation() : be.getPreviousLocation());
            }
        }
        if (tk > 0) {
            System.out.printf("========== Bundles to reinstall (%d):%n", tk);
            System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", "[symbolic name]", "[version]", "[location]");
            for (Map.Entry entry : map.entrySet()) {
                be = (BundleUpdate)entry.getValue();
                if (!be.isIndependent() || be.getNewLocation() != null) continue;
                System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", Utils.stripSymbolicName((String)be.getSymbolicName()), be.getPreviousVersion(), be.getPreviousLocation());
            }
        }
        if (tkf > 0) {
            System.out.printf("========== Bundles to reinstall as part of features or core bundles (%d):%n", tkf);
            System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", "[symbolic name]", "[version]", "[location]");
            for (Map.Entry entry : map.entrySet()) {
                be = (BundleUpdate)entry.getValue();
                if (be.isIndependent() || be.getNewLocation() != null) continue;
                System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", Utils.stripSymbolicName((String)be.getSymbolicName()), be.getPreviousVersion(), be.getPreviousLocation());
            }
        }
        System.out.flush();
    }

    public static void displayFeatureUpdates(Collection<FeatureUpdate> featureUpdates, boolean install) {
        TreeSet<String> toKeep = new TreeSet<String>();
        TreeSet<String> toRemove = new TreeSet<String>();
        TreeSet<String> toAdd = new TreeSet<String>();
        for (FeatureUpdate fu : featureUpdates) {
            if (install) {
                toRemove.add(fu.getPreviousRepository());
            } else if (fu.getNewRepository() != null) {
                toRemove.add(fu.getNewRepository());
            }
            if (fu.getNewRepository() != null) {
                toAdd.add(install ? fu.getNewRepository() : fu.getPreviousRepository());
                continue;
            }
            if (!install) continue;
            toKeep.add(fu.getPreviousRepository());
        }
        toRemove.removeAll(toKeep);
        System.out.printf("========== Repositories to remove (%d):%n", toRemove.size());
        for (String repo : toRemove) {
            System.out.println(" - " + repo);
        }
        System.out.printf("========== Repositories to add (%d):%n", toAdd.size());
        for (String repo : toAdd) {
            System.out.println(" - " + repo);
        }
        System.out.printf("========== Repositories to keep (%d):%n", toKeep.size());
        for (String repo : toKeep) {
            System.out.println(" - " + repo);
        }
        System.out.printf("========== Features to (%s):%n", install ? "update" : "downgrade");
        int l1 = "[name]".length();
        int l2 = "[version]".length();
        int l3 = install ? "[new version]".length() : "[previous version]".length();
        TreeMap<String, FeatureUpdate> map = new TreeMap<String, FeatureUpdate>();
        for (FeatureUpdate fu : featureUpdates) {
            if (fu.getName() == null) continue;
            if (fu.getName().length() > l1) {
                l1 = fu.getName().length();
            }
            if (install) {
                if (fu.getPreviousVersion().length() > l2) {
                    l2 = fu.getPreviousVersion().length();
                }
                if (fu.getNewVersion() != null && fu.getNewVersion().length() > l3) {
                    l3 = fu.getNewVersion().length();
                }
            } else {
                if (fu.getNewVersion() != null && fu.getNewVersion().length() > l2) {
                    l2 = fu.getNewVersion().length();
                }
                if (fu.getPreviousVersion().length() > l3) {
                    l3 = fu.getPreviousVersion().length();
                }
            }
            map.put(fu.getName(), fu);
        }
        System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", "[name]", "[version]", install ? "[new version]" : "[previous version]");
        for (FeatureUpdate fu : map.values()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = fu.getName();
            Object object = install ? fu.getPreviousVersion() : (objectArray[1] = fu.getNewVersion() == null ? "<reinstall>" : fu.getNewVersion());
            objectArray[2] = install ? (fu.getNewVersion() == null ? "<reinstall>" : fu.getNewVersion()) : fu.getPreviousVersion();
            System.out.printf("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s%n", objectArray);
        }
        System.out.flush();
    }
}

