/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.impl;

import io.fabric8.api.FabricService;
import io.fabric8.api.GitContext;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.common.util.Base64Encoder;
import io.fabric8.git.GitDataStore;
import io.fabric8.git.internal.GitHelpers;
import io.fabric8.git.internal.GitOperation;
import io.fabric8.patch.FabricPatchService;
import io.fabric8.patch.impl.OSGiPatchHelper;
import io.fabric8.patch.impl.Presentation;
import io.fabric8.patch.management.BackupService;
import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.Patch;
import io.fabric8.patch.management.PatchKind;
import io.fabric8.patch.management.PatchManagement;
import io.fabric8.patch.management.PatchResult;
import io.fabric8.patch.management.ProfileUpdateStrategy;
import io.fabric8.patch.management.Utils;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.utils.version.VersionTable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true, metatype=false)
@Service(value={FabricPatchService.class})
public class FabricPatchServiceImpl
implements FabricPatchService {
    @Reference(referenceInterface=PatchManagement.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private PatchManagement patchManagement;
    @Reference(referenceInterface=CuratorFramework.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private CuratorFramework curator;
    @Reference(referenceInterface=FabricService.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private FabricService fabricService;
    @Reference(referenceInterface=GitDataStore.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private GitDataStore gitDataStore;
    @Reference(referenceInterface=BackupService.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private BackupService backupService;
    @Reference(referenceInterface=RuntimeProperties.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private RuntimeProperties runtimeProperties;
    private BundleContext bundleContext;
    private File karafHome;
    private OSGiPatchHelper helper;

    @Activate
    void activate(ComponentContext componentContext) throws IOException, BundleException {
        this.bundleContext = componentContext.getBundleContext().getBundle(0L).getBundleContext();
        this.karafHome = new File(this.bundleContext.getProperty("karaf.home"));
        this.helper = new OSGiPatchHelper(this.karafHome, this.bundleContext);
        if (this.fabricService != null) {
            Profile profile = this.fabricService.getCurrentContainer().getOverlayProfile();
            Map map = profile.getConfiguration("io.fabric8.version");
        }
    }

    @Override
    public PatchResult install(final Patch patch, boolean simulation, final String versionId, boolean upload, final String username, final String password, final ProfileUpdateStrategy strategy) throws IOException {
        PatchKind kind;
        PatchKind patchKind = kind = patch.getPatchData().isRollupPatch() ? PatchKind.ROLLUP : PatchKind.NON_ROLLUP;
        if (kind == PatchKind.NON_ROLLUP) {
            throw new UnsupportedOperationException("patch:fabric-install should be used for Rollup patches only");
        }
        String currentContainersVersionId = this.fabricService.getCurrentContainer().getVersionId();
        if (!simulation && versionId.equals(currentContainersVersionId)) {
            throw new UnsupportedOperationException("Can't install Rollup patch in current version. Please install this patch in new version and then upgrade existing container(s)");
        }
        ((ProfileService)this.fabricService.adapt(ProfileService.class)).getRequiredVersion(versionId);
        List<BundleUpdate> bundleUpdatesInThisPatch = this.bundleUpdatesInPatch(patch);
        Presentation.displayBundleUpdates(bundleUpdatesInThisPatch, true);
        PatchResult result = new PatchResult(patch.getPatchData(), simulation, System.currentTimeMillis(), bundleUpdatesInThisPatch, null);
        if (!simulation) {
            GitOperation operation = new GitOperation(){

                public Object call(Git git, GitContext context) throws Exception {
                    GitHelpers.checkoutBranch((Git)git, (String)versionId);
                    FabricPatchServiceImpl.this.patchManagement.installProfiles(git.getRepository().getDirectory(), versionId, patch, strategy);
                    context.commitMessage("Installing rollup patch \"" + patch.getPatchData().getId() + "\"");
                    return null;
                }
            };
            this.gitDataStore.gitOperation(new GitContext().requireCommit().setRequirePush(true), operation, null);
            if (upload) {
                PatchManagement.UploadCallback callback = new PatchManagement.UploadCallback(){

                    public void doWithUrlConnection(URLConnection connection) throws ProtocolException {
                        if (connection instanceof HttpURLConnection) {
                            ((HttpURLConnection)connection).setRequestMethod("PUT");
                        }
                        if (username != null && password != null) {
                            connection.setRequestProperty("Authorization", "Basic " + Base64Encoder.encode((String)(username + ":" + password)));
                        }
                    }
                };
                this.patchManagement.uploadPatchArtifacts(patch.getPatchData(), this.fabricService.getMavenRepoUploadURI(), callback);
            }
        }
        return result;
    }

    private List<BundleUpdate> bundleUpdatesInPatch(Patch patch) throws IOException {
        LinkedList<BundleUpdate> updatesInThisPatch = new LinkedList<BundleUpdate>();
        for (String newLocation : patch.getPatchData().getBundles()) {
            String[] symbolicNameVersion = this.helper.getBundleIdentity(newLocation);
            if (symbolicNameVersion == null) continue;
            String sn = Utils.stripSymbolicName((String)symbolicNameVersion[0]);
            String vr = symbolicNameVersion[1];
            Version newVersion = VersionTable.getVersion(vr);
            if (symbolicNameVersion == null) continue;
            BundleUpdate update = new BundleUpdate(sn, newVersion.toString(), newLocation, null, null);
            update.setIndependent(true);
            updatesInThisPatch.add(update);
        }
        return updatesInThisPatch;
    }

    @Override
    public String synchronize() throws Exception {
        final String[] remoteUrl = new String[]{null};
        GitOperation operation = new GitOperation(){

            public Object call(Git git, GitContext context) throws Exception {
                String password;
                String username;
                ProfileRegistry registry = (ProfileRegistry)FabricPatchServiceImpl.this.fabricService.adapt(ProfileRegistry.class);
                Map properties = registry.getDataStoreProperties();
                if (properties != null && properties.containsKey("gitRemoteUser") && properties.containsKey("gitRemotePassword")) {
                    username = (String)properties.get("gitRemoteUser");
                    password = (String)properties.get("gitRemotePassword");
                } else {
                    username = ZooKeeperUtils.getContainerLogin((RuntimeProperties)FabricPatchServiceImpl.this.runtimeProperties);
                    password = ZooKeeperUtils.generateContainerToken((RuntimeProperties)FabricPatchServiceImpl.this.runtimeProperties, (CuratorFramework)FabricPatchServiceImpl.this.curator);
                }
                ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password))).setPushTags().setPushAll().call();
                remoteUrl[0] = git.getRepository().getConfig().getString("remote", "origin", "url");
                return null;
            }
        };
        this.gitDataStore.gitOperation(new GitContext(), operation, null);
        return remoteUrl[0];
    }

    protected void bindPatchManagement(PatchManagement patchManagement) {
        this.patchManagement = patchManagement;
    }

    protected void unbindPatchManagement(PatchManagement patchManagement) {
        if (this.patchManagement == patchManagement) {
            this.patchManagement = null;
        }
    }

    protected void bindCurator(CuratorFramework curatorFramework) {
        this.curator = curatorFramework;
    }

    protected void unbindCurator(CuratorFramework curatorFramework) {
        if (this.curator == curatorFramework) {
            this.curator = null;
        }
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }

    protected void bindGitDataStore(GitDataStore gitDataStore) {
        this.gitDataStore = gitDataStore;
    }

    protected void unbindGitDataStore(GitDataStore gitDataStore) {
        if (this.gitDataStore == gitDataStore) {
            this.gitDataStore = null;
        }
    }

    protected void bindBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    protected void unbindBackupService(BackupService backupService) {
        if (this.backupService == backupService) {
            this.backupService = null;
        }
    }

    protected void bindRuntimeProperties(RuntimeProperties runtimeProperties) {
        this.runtimeProperties = runtimeProperties;
    }

    protected void unbindRuntimeProperties(RuntimeProperties runtimeProperties) {
        if (this.runtimeProperties == runtimeProperties) {
            this.runtimeProperties = null;
        }
    }
}

