/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.impl;

import io.fabric8.patch.management.Artifact;
import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.EnvService;
import io.fabric8.patch.management.EnvType;
import io.fabric8.patch.management.ManagedPatch;
import io.fabric8.patch.management.Patch;
import io.fabric8.patch.management.PatchData;
import io.fabric8.patch.management.PatchDetailsRequest;
import io.fabric8.patch.management.PatchException;
import io.fabric8.patch.management.PatchKind;
import io.fabric8.patch.management.PatchManagement;
import io.fabric8.patch.management.PatchResult;
import io.fabric8.patch.management.Pending;
import io.fabric8.patch.management.ProfileUpdateStrategy;
import io.fabric8.patch.management.Utils;
import io.fabric8.patch.management.conflicts.ConflictResolver;
import io.fabric8.patch.management.conflicts.Resolver;
import io.fabric8.patch.management.impl.Activator;
import io.fabric8.patch.management.impl.DefaultEnvService;
import io.fabric8.patch.management.impl.GitPatchManagementService;
import io.fabric8.patch.management.impl.GitPatchRepository;
import io.fabric8.patch.management.impl.GitPatchRepositoryImpl;
import io.fabric8.patch.management.io.EOLFixingFileOutputStream;
import io.fabric8.patch.management.io.EOLFixingFileUtils;
import io.fabric8.patch.management.io.ProfileFileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RevertCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.startlevel.BundleStartLevel;

public class GitPatchManagementServiceImpl
implements PatchManagement,
GitPatchManagementService {
    private static final String[] MANAGED_DIRECTORIES = new String[]{"bin", "etc", "lib", "fabric", "licenses", "metatype"};
    private static final Pattern VERSION_PATTERN = Pattern.compile("patch-management-(\\d+\\.\\d+\\.\\d+(?:\\.[^\\.]+)?)\\.jar");
    private static final String MARKER_BASELINE_COMMIT_PATTERN = "[PATCH/baseline] Installing baseline-%s";
    private static final String MARKER_BASELINE_ROOT_COMMIT_PATTERN = "[PATCH/baseline] Installing baseline-%s";
    private static final String MARKER_BASELINE_CHILD_COMMIT_PATTERN = "[PATCH/baseline] Installing baseline-child-%s";
    private static final String MARKER_BASELINE_SSH_COMMIT_PATTERN = "[PATCH/baseline] Installing baseline-%s-%s";
    private static final String MARKER_BASELINE_RESET_OVERRIDES_PATTERN = "[PATCH/baseline] baseline-%s - resetting etc/overrides.properties";
    private static final String MARKER_BASELINE_REPLACE_PATCH_FEATURE_PATTERN = "[PATCH/baseline] baseline-%s - switching to patch feature repository %s";
    private static final String MARKER_R_PATCH_INSTALLATION_PATTERN = "[PATCH] Installing rollup patch %s";
    private static final String MARKER_R_PATCH_RESET_OVERRIDES_PATTERN = "[PATCH] Rollup patch %s - resetting etc/overrides.properties";
    private static final String MARKER_P_PATCH_INSTALLATION_PATTERN = "[PATCH] Installing patch %s";
    private static final String MARKER_PATCH_MANAGEMENT_INSTALLATION_COMMIT_PATTERN = "[PATCH/management] patch-management-%s.jar installed in etc/startup.properties";
    private static final String MARKER_USER_CHANGES_COMMIT = "[PATCH] Apply user changes";
    private final BundleContext bundleContext;
    private final BundleContext systemContext;
    private EnvType env = EnvType.UNKNOWN;
    private boolean master = false;
    private GitPatchRepository gitPatchRepository;
    private ConflictResolver conflictResolver = new ConflictResolver();
    private EnvService envService;
    private AtomicBoolean aligning = new AtomicBoolean(false);
    private File karafHome;
    private File karafBase;
    private File karafData;
    private File patchesDir;
    private CountDownLatch initialized = new CountDownLatch(1);
    protected Map<String, Git> pendingTransactions = new HashMap<String, Git>();
    protected Map<String, PatchKind> pendingTransactionsTypes = new HashMap<String, PatchKind>();
    protected Map<String, BundleListener> pendingPatchesListeners = new HashMap<String, BundleListener>();

    public GitPatchManagementServiceImpl(BundleContext context) throws IOException {
        this.bundleContext = context;
        this.systemContext = context.getBundle(0L).getBundleContext();
        this.karafHome = new File(this.systemContext.getProperty("karaf.home"));
        this.karafBase = new File(this.systemContext.getProperty("karaf.base"));
        this.karafData = new File(this.systemContext.getProperty("karaf.data"));
        this.envService = new DefaultEnvService(this.systemContext, this.karafHome, this.karafBase);
        this.env = this.envService.determineEnvironmentType();
        if (this.env == EnvType.UNKNOWN) {
            return;
        }
        String patchLocation = this.systemContext.getProperty("fuse.patch.location");
        if (patchLocation == null) {
            patchLocation = this.env == EnvType.STANDALONE_CHILD ? new File(this.karafHome, "patches").getCanonicalPath() : new File(this.karafBase, "patches").getCanonicalPath();
        }
        this.patchesDir = new File(patchLocation);
        if (!this.patchesDir.isDirectory()) {
            this.patchesDir.mkdirs();
        }
        File patchRepositoryLocation = new File(this.patchesDir, ".management/history");
        GitPatchRepositoryImpl repository = new GitPatchRepositoryImpl(this.env, patchRepositoryLocation, this.karafHome, this.karafBase, this.karafData, this.patchesDir);
        this.setGitPatchRepository(repository);
    }

    public GitPatchRepository getGitPatchRepository() {
        return this.gitPatchRepository;
    }

    public void setGitPatchRepository(GitPatchRepository repository) {
        this.gitPatchRepository = repository;
    }

    @Override
    public List<Patch> listPatches(boolean details) throws PatchException {
        LinkedList<Patch> patches = new LinkedList<Patch>();
        File[] patchDescriptors = this.patchesDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".patch") && new File(dir, name).isFile();
            }
        });
        try {
            for (File pd : patchDescriptors) {
                Patch p = this.loadPatch(pd, details);
                patches.add(p);
            }
        }
        catch (IOException e) {
            throw new PatchException(e.getMessage(), e);
        }
        return patches;
    }

    private Patch loadPatch(File patchDescriptor, boolean details) throws IOException {
        Patch p = new Patch();
        if (!patchDescriptor.exists() || !patchDescriptor.isFile()) {
            return null;
        }
        PatchData data = PatchData.load(new FileInputStream(patchDescriptor));
        p.setPatchData(data);
        File patchDirectory = new File(this.patchesDir, FilenameUtils.getBaseName(patchDescriptor.getName()));
        if (patchDirectory.exists() && patchDirectory.isDirectory()) {
            data.setPatchDirectory(patchDirectory);
        }
        data.setPatchLocation(this.patchesDir);
        File resultFile = new File(this.patchesDir, FilenameUtils.getBaseName(patchDescriptor.getName()) + ".patch.result");
        if (resultFile.exists() && resultFile.isFile()) {
            PatchResult result = PatchResult.load(data, new FileInputStream(resultFile));
            p.setResult(result);
        }
        if (details) {
            ManagedPatch mp = this.gitPatchRepository.getManagedPatch(data.getId());
            p.setManagedPatch(mp);
        }
        return p;
    }

    @Override
    public Patch loadPatch(PatchDetailsRequest request) throws PatchException {
        File descriptor = new File(this.patchesDir, request.getPatchId() + ".patch");
        try {
            Patch patch = this.loadPatch(descriptor, true);
            if (patch == null) {
                return null;
            }
            Git repo = this.gitPatchRepository.findOrCreateMainGitRepository();
            List<DiffEntry> diff = null;
            if (request.isFiles() || request.isDiff()) {
                ObjectId commitId = repo.getRepository().resolve(patch.getManagedPatch().getCommitId());
                RevCommit commit = new RevWalk(repo.getRepository()).parseCommit(commitId);
                diff = this.gitPatchRepository.diff(repo, commit.getParent(0), commit);
            }
            if (request.isBundles()) {
                // empty if block
            }
            if (request.isFiles() && diff != null) {
                for (DiffEntry de : diff) {
                    DiffEntry.ChangeType ct = de.getChangeType();
                    String newPath = de.getNewPath();
                    String oldPath = de.getOldPath();
                    switch (ct) {
                        case ADD: {
                            patch.getManagedPatch().getFilesAdded().add(newPath);
                            break;
                        }
                        case MODIFY: {
                            patch.getManagedPatch().getFilesModified().add(newPath);
                            break;
                        }
                        case DELETE: {
                            patch.getManagedPatch().getFilesRemoved().add(oldPath);
                        }
                    }
                }
            }
            if (request.isDiff() && diff != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DiffFormatter formatter = new DiffFormatter(baos);
                formatter.setContext(4);
                formatter.setRepository(repo.getRepository());
                for (DiffEntry de : diff) {
                    formatter.format(de);
                }
                formatter.flush();
                patch.getManagedPatch().setUnifiedDiff(new String(baos.toByteArray(), "UTF-8"));
            }
            return patch;
        }
        catch (IOException | GitAPIException e) {
            throw new PatchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PatchData> fetchPatches(URL url) throws PatchException {
        try {
            ArrayList<PatchData> patches = new ArrayList<PatchData>(1);
            File patchFile = new File(this.patchesDir, Long.toString(System.currentTimeMillis()) + ".patch.tmp");
            InputStream input = url.openStream();
            FileOutputStream output = new FileOutputStream(patchFile);
            ZipFile zf = null;
            try {
                IOUtils.copy(input, (OutputStream)output);
            }
            finally {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
            }
            try {
                zf = new ZipFile(patchFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            PatchData patchData = null;
            PatchData fallbackPatchData = new PatchData(FilenameUtils.getBaseName(url.getPath()));
            fallbackPatchData.setGenerated(true);
            fallbackPatchData.setRollupPatch(true);
            fallbackPatchData.setPatchDirectory(new File(this.patchesDir, fallbackPatchData.getId()));
            fallbackPatchData.setPatchLocation(this.patchesDir);
            if (zf != null) {
                File systemRepo = Utils.getSystemRepository(this.karafHome, this.systemContext);
                try {
                    LinkedList<ZipArchiveEntry> otherResources = new LinkedList<ZipArchiveEntry>();
                    boolean skipRootDir = false;
                    Enumeration<ZipArchiveEntry> e = zf.getEntries();
                    while (e.hasMoreElements()) {
                        File target;
                        ZipArchiveEntry entry = e.nextElement();
                        if (!skipRootDir && entry.isDirectory() && (entry.getName().startsWith("jboss-fuse-") || entry.getName().startsWith("jboss-a-mq-"))) {
                            skipRootDir = true;
                        }
                        if (entry.isDirectory() || entry.isUnixSymlink()) continue;
                        String name = entry.getName();
                        if (skipRootDir) {
                            name = name.substring(name.indexOf(47) + 1);
                        }
                        if (!name.contains("/") && name.endsWith(".patch")) {
                            if (patchData == null) {
                                target = new File(this.patchesDir, name);
                                Utils.extractZipEntry(zf, entry, target);
                                patchData = this.loadPatchData(target);
                                patchData.setGenerated(false);
                                File targetDirForPatchResources = new File(this.patchesDir, patchData.getId());
                                patchData.setPatchDirectory(targetDirForPatchResources);
                                patchData.setPatchLocation(this.patchesDir);
                                target.renameTo(new File(this.patchesDir, patchData.getId() + ".patch"));
                                patches.add(patchData);
                                continue;
                            }
                            throw new PatchException(String.format("Multiple patch descriptors: already have patch %s and now encountered entry %s", patchData.getId(), name));
                        }
                        target = null;
                        String relativeName = null;
                        if (name.startsWith("system/")) {
                            relativeName = name.substring("system/".length());
                            target = new File(systemRepo, relativeName);
                        } else if (name.startsWith("repository/")) {
                            relativeName = name.substring("repository/".length());
                            target = new File(systemRepo, relativeName);
                        } else {
                            otherResources.add(entry);
                        }
                        if (target == null) continue;
                        Utils.extractAndTrackZipEntry(fallbackPatchData, zf, entry, target, skipRootDir);
                    }
                    File targetDirForPatchResources = new File(this.patchesDir, patchData == null ? fallbackPatchData.getId() : patchData.getId());
                    for (ZipArchiveEntry entry : otherResources) {
                        String name = entry.getName();
                        if (skipRootDir) {
                            name = name.substring(name.indexOf(47));
                        }
                        File target = new File(targetDirForPatchResources, name);
                        Utils.extractAndTrackZipEntry(fallbackPatchData, zf, entry, target, skipRootDir);
                    }
                }
                finally {
                    if (zf != null) {
                        zf.close();
                    }
                    if (patchFile != null) {
                        patchFile.delete();
                    }
                }
            } else {
                patchData = this.loadPatchData(patchFile);
                patchData.setPatchDirectory(null);
                patchFile.renameTo(new File(this.patchesDir, patchData.getId() + ".patch"));
                patches.add(patchData);
            }
            if (patches.size() == 0) {
                File generatedPatchDescriptor = new File(this.patchesDir, fallbackPatchData.getId() + ".patch");
                FileOutputStream out = new FileOutputStream(generatedPatchDescriptor);
                try {
                    fallbackPatchData.storeTo(out);
                }
                finally {
                    IOUtils.closeQuietly(out);
                }
                patches.add(fallbackPatchData);
            }
            return patches;
        }
        catch (IOException e) {
            throw new PatchException("Unable to download patch from url " + url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadPatchArtifacts(PatchData patchData, URI uploadAddress, PatchManagement.UploadCallback callback) throws PatchException {
        try {
            File repoLocation;
            String newUrl;
            Activator.log2(3, "Uploading artifacts to " + uploadAddress);
            LinkedList<File> artifacts = new LinkedList<File>();
            for (String bundle : patchData.getBundles()) {
                newUrl = Utils.mvnurlToPath(bundle);
                if (newUrl == null || !(repoLocation = new File(Utils.getSystemRepository(this.karafHome, this.bundleContext), newUrl)).isFile()) continue;
                artifacts.add(repoLocation);
            }
            for (String featureRepository : patchData.getFeatureFiles()) {
                newUrl = Utils.mvnurlToPath(featureRepository);
                if (newUrl == null || !(repoLocation = new File(Utils.getSystemRepository(this.karafHome, this.bundleContext), newUrl)).isFile()) continue;
                artifacts.add(repoLocation);
            }
            for (String artifact : patchData.getOtherArtifacts()) {
                newUrl = Utils.mvnurlToPath(artifact);
                if (newUrl == null || !(repoLocation = new File(Utils.getSystemRepository(this.karafHome, this.bundleContext), newUrl)).isFile()) continue;
                artifacts.add(repoLocation);
            }
            int delta = artifacts.size() / 10;
            int count = 0;
            for (File f : artifacts) {
                if (++count % delta == 0) {
                    Activator.log2(4, String.format("Uploaded %d/%d", count, artifacts.size()));
                }
                String relativeName = Utils.relative(Utils.getSystemRepository(this.karafHome, this.bundleContext), f.getCanonicalFile());
                relativeName = relativeName.replace('\\', '/');
                URL uploadUrl = uploadAddress.resolve(relativeName).toURL();
                URLConnection con = uploadUrl.openConnection();
                callback.doWithUrlConnection(con);
                con.setDoInput(true);
                con.setDoOutput(true);
                con.connect();
                OutputStream os = con.getOutputStream();
                FileInputStream is = new FileInputStream(f);
                try {
                    int code;
                    IOUtils.copy((InputStream)is, os);
                    if (!(con instanceof HttpURLConnection) || (code = ((HttpURLConnection)con).getResponseCode()) >= 200 && code < 300) continue;
                    throw new IOException("Error uploading patched artifacts: " + ((HttpURLConnection)con).getResponseMessage());
                }
                finally {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(os);
                }
            }
            Activator.log2(4, String.format("Uploaded %d/%d", count, artifacts.size()));
        }
        catch (Exception e) {
            throw new PatchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PatchData loadPatchData(File patchDescriptor) throws IOException {
        PatchData patchData;
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(patchDescriptor);
            properties.load(inputStream);
            patchData = PatchData.load(properties);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
        return patchData;
    }

    @Override
    public Patch trackPatch(PatchData patchData) throws PatchException {
        try {
            this.awaitInitialization();
        }
        catch (InterruptedException e) {
            throw new PatchException("Patch management system is not ready yet");
        }
        Git fork = null;
        try {
            Git mainRepository = this.gitPatchRepository.findOrCreateMainGitRepository();
            fork = this.gitPatchRepository.cloneRepository(mainRepository, true);
            RevTag latestBaseline = this.gitPatchRepository.findCurrentBaseline(fork);
            if (latestBaseline == null) {
                throw new PatchException("Can't find baseline distribution tracked in patch management. Is patch management initialized?");
            }
            RevCommit commit = new RevWalk(fork.getRepository()).parseCommit(latestBaseline.getObject());
            this.gitPatchRepository.checkout(fork).setCreateBranch(true).setName("patch-" + patchData.getId()).setStartPoint(commit).call();
            if (patchData.getPatchDirectory() != null) {
                boolean removeTargetDir = patchData.isRollupPatch();
                this.copyManagedDirectories(patchData.getPatchDirectory(), fork.getRepository().getWorkTree(), removeTargetDir, false, false);
            }
            fork.add().addFilepattern(".").call();
            for (String missing : fork.status().call().getMissing()) {
                if ("etc/overrides.properties".equals(missing)) continue;
                fork.rm().addFilepattern(missing).call();
            }
            StringWriter sw = new StringWriter();
            sw.append("# tags for patches included in \"").append(patchData.getId()).append("\"\n");
            for (String bundle : patchData.getBundles()) {
                if (!bundle.contains("mvn:org.apache.karaf.admin/org.apache.karaf.admin.core/")) continue;
                Artifact a = Utils.mvnurlToArtifact(bundle, true);
                if (a == null) break;
                sw.append(String.format(EnvType.STANDALONE_CHILD.getBaselineTagFormat(), a.getVersion())).append("\n");
                break;
            }
            FileUtils.write(new File(fork.getRepository().getWorkTree(), "patch-info.txt"), sw.toString());
            fork.add().addFilepattern(".").call();
            this.gitPatchRepository.prepareCommit(fork, String.format("[PATCH] Tracking patch %s", patchData.getId())).call();
            this.gitPatchRepository.push(fork, "patch-" + patchData.getId());
            if (this.env.isFabric()) {
                this.trackBaselinesForRootContainer(fork);
                this.trackBaselinesForChildContainers(fork);
                this.trackBaselinesForSSHContainers(fork);
            } else {
                this.trackBaselinesForChildContainers(fork);
            }
            Patch patch = new Patch(patchData, this.gitPatchRepository.getManagedPatch(patchData.getId()));
            if (fork != null) {
                this.gitPatchRepository.closeRepository(fork, true);
            }
            return patch;
        }
        catch (IOException | GitAPIException e) {
            try {
                throw new PatchException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (fork != null) {
                    this.gitPatchRepository.closeRepository(fork, true);
                }
                throw throwable;
            }
        }
    }

    private void awaitInitialization() throws InterruptedException {
        this.initialized.await(30L, TimeUnit.SECONDS);
    }

    @Override
    public String beginInstallation(PatchKind kind) {
        Object tx = null;
        try {
            Git fork = this.gitPatchRepository.cloneRepository(this.gitPatchRepository.findOrCreateMainGitRepository(), true);
            Ref installationBranch = null;
            this.applyUserChanges(fork);
            switch (kind) {
                case ROLLUP: {
                    RevTag currentBaseline = this.gitPatchRepository.findCurrentBaseline(fork);
                    installationBranch = this.gitPatchRepository.checkout(fork).setName(String.format("patch-install-%s", GitPatchRepository.TS.format(new Date()))).setCreateBranch(true).setStartPoint(currentBaseline.getTagName() + "^{commit}").call();
                    break;
                }
                case NON_ROLLUP: {
                    installationBranch = this.gitPatchRepository.checkout(fork).setName(String.format("patch-install-%s", GitPatchRepository.TS.format(new Date()))).setCreateBranch(true).setStartPoint(this.gitPatchRepository.getMainBranchName()).call();
                }
            }
            this.pendingTransactionsTypes.put(installationBranch.getName(), kind);
            this.pendingTransactions.put(installationBranch.getName(), fork);
            return installationBranch.getName();
        }
        catch (IOException | GitAPIException e) {
            if (tx != null) {
                this.pendingTransactions.remove(tx);
                this.pendingTransactionsTypes.remove(tx);
            }
            throw new PatchException(e.getMessage(), e);
        }
    }

    @Override
    public void install(String transaction, Patch patch, List<BundleUpdate> bundleUpdatesInThisPatch) {
        this.transactionIsValid(transaction, patch);
        Git fork = this.pendingTransactions.get(transaction);
        try {
            switch (this.pendingTransactionsTypes.get(transaction)) {
                case ROLLUP: {
                    Activator.log2(3, String.format("Installing rollup patch \"%s\"", patch.getPatchData().getId()));
                    ObjectId since = fork.getRepository().resolve("HEAD^{commit}");
                    ObjectId to = fork.getRepository().resolve(this.gitPatchRepository.getMainBranchName() + "^{commit}");
                    Object mainChanges = fork.log().addRange(since, to).call();
                    LinkedList<RevCommit> userChanges = new LinkedList<RevCommit>();
                    Iterator i$ = mainChanges.iterator();
                    while (i$.hasNext()) {
                        RevCommit rc = (RevCommit)i$.next();
                        if (!this.isUserChangeCommit(rc)) continue;
                        userChanges.add(rc);
                    }
                    String patchRef = patch.getManagedPatch().getCommitId();
                    if (this.env == EnvType.STANDALONE_CHILD) {
                        String patchInfo = this.gitPatchRepository.getFileContent(fork, patchRef, "patch-info.txt");
                        if (patchInfo != null) {
                            BufferedReader reader = new BufferedReader(new StringReader(patchInfo));
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                Pattern p;
                                if (line.startsWith("#") || !(p = Pattern.compile(this.env.getBaselineTagFormat().replace("%s", "(.*)"))).matcher(line).matches()) continue;
                                patchRef = line.trim();
                            }
                        } else {
                            Activator.log2(2, String.format("Can't install rollup patch \"%s\" in admin container - no information about admin container patch", patch.getPatchData().getId()));
                            return;
                        }
                    }
                    if (this.env == EnvType.STANDALONE) {
                        fork.cherryPick().include(fork.getRepository().resolve(patchRef)).setNoCommit(true).call();
                        this.gitPatchRepository.prepareCommit(fork, String.format(MARKER_R_PATCH_INSTALLATION_PATTERN, patch.getPatchData().getId())).call();
                    } else if (this.env == EnvType.STANDALONE_CHILD) {
                        fork.reset().setMode(ResetCommand.ResetType.HARD).setRef("refs/tags/" + patchRef + "^{commit}").call();
                    }
                    this.resetOverrides(fork.getRepository().getWorkTree());
                    fork.add().addFilepattern("etc/overrides.properties").call();
                    RevCommit c = this.gitPatchRepository.prepareCommit(fork, String.format(MARKER_R_PATCH_RESET_OVERRIDES_PATTERN, patch.getPatchData().getId())).call();
                    if (this.env == EnvType.STANDALONE) {
                        String newFuseVersion = this.determineVersion(fork.getRepository().getWorkTree(), "fuse");
                        fork.tag().setName(String.format(EnvType.STANDALONE.getBaselineTagFormat(), newFuseVersion)).setObjectId(c).call();
                    }
                    ListIterator it = userChanges.listIterator(userChanges.size());
                    int prefixSize = Integer.toString(userChanges.size()).length();
                    int count = 1;
                    while (it.hasPrevious()) {
                        RevCommit userChange = (RevCommit)it.previous();
                        String prefix = String.format("%0" + prefixSize + "d-%s", count++, userChange.getName());
                        CherryPickResult result = fork.cherryPick().include(userChange).setNoCommit(true).call();
                        File overrides = new File(fork.getRepository().getWorkTree(), "etc/overrides.properties");
                        if (overrides.isFile()) {
                            overrides.delete();
                            fork.rm().addFilepattern("etc/overrides.properties").call();
                        }
                        this.handleCherryPickConflict(patch.getPatchData().getPatchDirectory(), fork, result, userChange, false, PatchKind.ROLLUP, prefix, true);
                        String newMessage = userChange.getFullMessage() + "\n\n";
                        newMessage = newMessage + prefix;
                        this.gitPatchRepository.prepareCommit(fork, newMessage).call();
                        fork.reset().setMode(ResetCommand.ResetType.HARD).call();
                    }
                    RevWalk walk = new RevWalk(fork.getRepository());
                    RevCommit c1 = walk.parseCommit(since);
                    RevCommit c2 = walk.parseCommit(to);
                    Map<String, RevTag> tags = this.gitPatchRepository.findTagsBetween(fork, c1, c2);
                    for (Map.Entry<String, RevTag> entry : tags.entrySet()) {
                        if (!entry.getKey().startsWith("patch-")) continue;
                        fork.tagDelete().setTags(entry.getKey()).call();
                        fork.push().setRefSpecs(new RefSpec().setSource(null).setDestination("refs/tags/" + entry.getKey())).call();
                    }
                    break;
                }
                case NON_ROLLUP: {
                    Activator.log2(3, String.format("Installing non-rollup patch \"%s\"", patch.getPatchData().getId()));
                    RevCommit commit = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve(patch.getManagedPatch().getCommitId()));
                    CherryPickResult result = fork.cherryPick().include(commit).setNoCommit(true).call();
                    this.handleCherryPickConflict(patch.getPatchData().getPatchDirectory(), fork, result, commit, true, PatchKind.NON_ROLLUP, null, true);
                    this.updateFileReferences(fork, patch.getPatchData(), bundleUpdatesInThisPatch);
                    this.updateOverrides(fork.getRepository().getWorkTree(), patch.getPatchData());
                    fork.add().addFilepattern(".").call();
                    RevCommit c = this.gitPatchRepository.prepareCommit(fork, String.format(MARKER_P_PATCH_INSTALLATION_PATTERN, patch.getPatchData().getId())).call();
                    fork.reset().setMode(ResetCommand.ResetType.HARD).call();
                    String tagName = String.format("patch-%s", patch.getPatchData().getId().replace(' ', '-'));
                    if (this.env == EnvType.STANDALONE_CHILD) {
                        tagName = tagName + "-" + this.gitPatchRepository.getStandaloneChildkarafName();
                    }
                    fork.tag().setName(tagName).setObjectId(c).call();
                    break;
                }
            }
        }
        catch (IOException | GitAPIException e) {
            throw new PatchException(e.getMessage(), e);
        }
    }

    private void updateOverrides(File workTree, PatchData patchData) throws IOException {
        File overrides = new File(workTree, "etc/overrides.properties");
        LinkedList<String> currentOverrides = overrides.isFile() ? FileUtils.readLines(overrides) : new LinkedList<String>();
        for (String bundle : patchData.getBundles()) {
            VersionRange range;
            String override;
            Artifact artifact = Utils.mvnurlToArtifact(bundle, true);
            if (artifact == null) continue;
            Version oVer = new Version(artifact.getVersion());
            String vr = patchData.getVersionRange(bundle);
            if (vr != null && !vr.isEmpty()) {
                override = bundle + ";range=" + vr;
                range = new VersionRange(vr);
            } else {
                override = bundle;
                Version v1 = new Version(oVer.getMajor(), oVer.getMinor(), 0);
                Version v2 = new Version(oVer.getMajor(), oVer.getMinor() + 1, 0);
                range = new VersionRange('[', v1, v2, ')');
            }
            boolean matching = false;
            boolean added = false;
            for (int i = 0; i < currentOverrides.size(); ++i) {
                Artifact overrideArtifact;
                String line = ((String)currentOverrides.get(i)).trim();
                if (line.isEmpty() || line.startsWith("#") || (overrideArtifact = Utils.mvnurlToArtifact(line, true)) == null) continue;
                Version ver = new Version(overrideArtifact.getVersion());
                if (!Artifact.isSameButVersion(artifact, overrideArtifact) || !range.includes(ver)) continue;
                matching = true;
                if (ver.compareTo(oVer) >= 0) continue;
                currentOverrides.set(i, override);
                added = true;
            }
            if (matching) continue;
            currentOverrides.add(override);
        }
        FileUtils.writeLines(overrides, currentOverrides, "\n");
    }

    private void resetOverrides(File karafHome) throws IOException {
        File overrides = new File(karafHome, "etc/overrides.properties");
        if (overrides.isFile()) {
            overrides.delete();
        }
        overrides.createNewFile();
    }

    @Override
    public void commitInstallation(String transaction) {
        this.transactionIsValid(transaction, null);
        Git fork = this.pendingTransactions.get(transaction);
        try {
            switch (this.pendingTransactionsTypes.get(transaction)) {
                case ROLLUP: {
                    this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getMainBranchName()).call();
                    RevTag baseline = this.gitPatchRepository.findCurrentBaseline(fork);
                    RevCommit c1 = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve(baseline.getTagName() + "^{commit}"));
                    fork.reset().setMode(ResetCommand.ResetType.HARD).setRef(transaction).call();
                    this.gitPatchRepository.push(fork);
                    RevCommit c2 = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve("HEAD"));
                    this.applyChanges(fork, false);
                    break;
                }
                case NON_ROLLUP: {
                    this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getMainBranchName()).call();
                    RevCommit c1 = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve("HEAD"));
                    fork.merge().setFastForward(MergeCommand.FastForwardMode.FF_ONLY).include(fork.getRepository().resolve(transaction)).call();
                    this.gitPatchRepository.push(fork);
                    RevCommit c2 = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve("HEAD"));
                    this.applyChanges(fork, c1, c2);
                    break;
                }
            }
            this.gitPatchRepository.push(fork);
        }
        catch (IOException | GitAPIException e) {
            throw new PatchException(e.getMessage(), e);
        }
        finally {
            this.gitPatchRepository.closeRepository(fork, true);
        }
        this.pendingTransactions.remove(transaction);
        this.pendingTransactionsTypes.remove(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void rollbackInstallation(String transaction) {
        this.transactionIsValid(transaction, null);
        fork = this.pendingTransactions.get(transaction);
        try {
            switch (5.$SwitchMap$io$fabric8$patch$management$PatchKind[this.pendingTransactionsTypes.get(transaction).ordinal()]) {
                ** default:
lbl6:
                // 1 sources

                break;
            }
        }
        finally {
            this.gitPatchRepository.closeRepository(fork, true);
        }
        this.pendingTransactions.remove(transaction);
        this.pendingTransactionsTypes.remove(transaction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback(PatchData patchData) {
        Git fork = null;
        try {
            fork = this.gitPatchRepository.cloneRepository(this.gitPatchRepository.findOrCreateMainGitRepository(), true);
            Object installationBranch = null;
            PatchKind kind = patchData.isRollupPatch() ? PatchKind.ROLLUP : PatchKind.NON_ROLLUP;
            switch (kind) {
                case ROLLUP: {
                    RevCommit c2;
                    RevCommit c1;
                    Activator.log2(3, String.format("Rolling back rollup patch \"%s\"", patchData.getId()));
                    RevTag currentBaseline = this.gitPatchRepository.findCurrentBaseline(fork);
                    RevCommit since = c1 = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve(currentBaseline.getTagName() + "^{commit}"));
                    RevCommit to = c2 = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve("HEAD"));
                    Object mainChangesSinceRollupPatch = fork.log().addRange(c1, c2).call();
                    LinkedList<RevCommit> userChanges = new LinkedList<RevCommit>();
                    Iterator i$ = mainChangesSinceRollupPatch.iterator();
                    while (i$.hasNext()) {
                        RevCommit rc = (RevCommit)i$.next();
                        if (!this.isUserChangeCommit(rc)) continue;
                        userChanges.add(rc);
                    }
                    if (this.env == EnvType.STANDALONE) {
                        fork.tagDelete().setTags(currentBaseline.getTagName()).call();
                    }
                    RevTag previousBaseline = this.gitPatchRepository.findNthPreviousBaseline(fork, this.env == EnvType.STANDALONE ? 0 : 1);
                    c1 = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve(previousBaseline.getTagName() + "^{commit}"));
                    fork.reset().setMode(ResetCommand.ResetType.HARD).setRef(previousBaseline.getTagName() + "^{commit}").call();
                    ListIterator it = userChanges.listIterator(userChanges.size());
                    Status status = fork.status().call();
                    if (!status.isClean()) {
                        fork.reset().setMode(ResetCommand.ResetType.MIXED).call();
                        for (String p : status.getModified()) {
                            this.gitPatchRepository.checkout(fork).addPath(p).call();
                        }
                    }
                    while (it.hasPrevious()) {
                        RevCommit userChange = (RevCommit)it.previous();
                        CherryPickResult cpr = fork.cherryPick().include(userChange.getId()).setNoCommit(true).call();
                        this.handleCherryPickConflict(patchData.getPatchDirectory(), fork, cpr, userChange, true, PatchKind.ROLLUP, null, false);
                        String[] commitMessage = userChange.getFullMessage().split("\n\n");
                        if (commitMessage.length > 1) {
                            String ref = commitMessage[commitMessage.length - 1];
                            File backupDir = new File(this.patchesDir, patchData.getId() + ".backup");
                            if ((backupDir = new File(backupDir, ref)).exists() && backupDir.isDirectory()) {
                                Activator.log2(4, String.format("Restoring content of %s", backupDir.getCanonicalPath()));
                                this.copyManagedDirectories(backupDir, this.karafBase, false, false, false);
                            }
                        }
                        this.gitPatchRepository.prepareCommit(fork, userChange.getFullMessage()).call();
                    }
                    this.gitPatchRepository.push(fork);
                    if (this.env == EnvType.STANDALONE) {
                        fork.push().setRefSpecs(new RefSpec().setSource(null).setDestination("refs/tags/" + currentBaseline.getTagName())).call();
                    }
                    RevWalk walk = new RevWalk(fork.getRepository());
                    Map<String, RevTag> tags = this.gitPatchRepository.findTagsBetween(fork, since, to);
                    Iterator<Map.Entry<String, RevTag>> i$2 = tags.entrySet().iterator();
                    while (true) {
                        if (!i$2.hasNext()) {
                            c2 = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve("HEAD"));
                            this.applyChanges(fork, false);
                            return;
                        }
                        Map.Entry<String, RevTag> entry = i$2.next();
                        if (!entry.getKey().startsWith("patch-")) continue;
                        fork.tagDelete().setTags(entry.getKey()).call();
                        fork.push().setRefSpecs(new RefSpec().setSource(null).setDestination("refs/tags/" + entry.getKey())).call();
                    }
                }
                case NON_ROLLUP: {
                    Activator.log2(3, String.format("Rolling back non-rollup patch \"%s\"", patchData.getId()));
                    String patchTagName = String.format("patch-%s", this.env == EnvType.STANDALONE ? patchData.getId() : patchData.getId() + "-" + this.gitPatchRepository.getStandaloneChildkarafName());
                    ObjectId oid = fork.getRepository().resolve(patchTagName);
                    if (oid == null) {
                        throw new PatchException(String.format("Can't find installed patch (tag %s is missing)", patchTagName));
                    }
                    RevCommit commit = new RevWalk(fork.getRepository()).parseCommit(oid);
                    RevertCommand revertCommand = fork.revert().include(commit);
                    RevCommit reverted = revertCommand.call();
                    if (reverted != null) {
                        fork.tagDelete().setTags(patchTagName).call();
                        this.gitPatchRepository.push(fork);
                        fork.push().setRefSpecs(new RefSpec().setSource(null).setDestination(String.format("refs/tags/%s", patchTagName))).call();
                        RevCommit c = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve("HEAD"));
                        this.applyChanges(fork, c.getParent(0), c);
                        return;
                    }
                    List<String> unmerged = revertCommand.getUnmergedPaths();
                    Activator.log2(2, "Problem rolling back patch \"" + patchData.getId() + "\". The following files where updated later:");
                    for (String path : unmerged) {
                        Activator.log2(2, " - " + path);
                    }
                    RevWalk walk = new RevWalk(fork.getRepository());
                    RevCommit head = walk.parseCommit(fork.getRepository().resolve("HEAD"));
                    Map<String, RevTag> tags = this.gitPatchRepository.findTagsBetween(fork, commit, head);
                    LinkedList<RevTag> laterPatches = new LinkedList<RevTag>();
                    if (tags.size() <= 0) return;
                    for (Map.Entry<String, RevTag> tag : tags.entrySet()) {
                        if (!tag.getKey().startsWith("patch-")) continue;
                        laterPatches.add(tag.getValue());
                    }
                    Activator.log2(3, "The following patches were installed after \"" + patchData.getId() + "\":");
                    Iterator<Map.Entry<String, RevTag>> i$ = laterPatches.iterator();
                    while (i$.hasNext()) {
                        RevTag t = (RevTag)((Object)i$.next());
                        String message = " - " + t.getTagName().substring("patch-".length());
                        RevObject object = walk.peel(t);
                        if (object != null) {
                            RevCommit c = walk.parseCommit(object.getId());
                            String date = GitPatchRepository.FULL_DATE.format(new Date((long)c.getCommitTime() * 1000L));
                            message = message + " (" + date + ")";
                        }
                        Activator.log2(3, message);
                    }
                    return;
                }
            }
            return;
        }
        catch (IOException | GitAPIException e) {
            throw new PatchException(e.getMessage(), e);
        }
        finally {
            if (fork != null) {
                this.gitPatchRepository.closeRepository(fork, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCherryPickConflict(File patchDirectory, Git fork, CherryPickResult result, RevCommit commit, boolean preferNew, PatchKind kind, String cpPrefix, boolean performBackup) throws GitAPIException, IOException {
        if (result.getStatus() == CherryPickResult.CherryPickStatus.CONFLICTING) {
            Activator.log2(2, "Problem with applying the change " + commit.getName() + ":");
            Map<String, IndexDiff.StageState> conflicts = fork.status().call().getConflictingStageState();
            String choose = null;
            String backup = null;
            switch (kind) {
                case ROLLUP: {
                    choose = !preferNew ? "change from patch" : "custom change";
                    backup = !preferNew ? "custom change" : "change from patch";
                    break;
                }
                case NON_ROLLUP: {
                    choose = preferNew ? "change from patch" : "custom change";
                    backup = preferNew ? "custom change" : "change from patch";
                }
            }
            DirCache cache = fork.getRepository().readDirCache();
            HashMap<String, ObjectId[]> threeWayMerge = new HashMap<String, ObjectId[]>();
            for (int i = 0; i < cache.getEntryCount(); ++i) {
                DirCacheEntry entry = cache.getEntry(i);
                if (entry.getStage() == 0) continue;
                if (!threeWayMerge.containsKey(entry.getPathString())) {
                    threeWayMerge.put(entry.getPathString(), new ObjectId[]{null, null, null});
                }
                if (entry.getStage() == 1) {
                    ((ObjectId[])threeWayMerge.get((Object)entry.getPathString()))[1] = entry.getObjectId();
                }
                if (entry.getStage() == 2) {
                    ((ObjectId[])threeWayMerge.get((Object)entry.getPathString()))[0] = entry.getObjectId();
                }
                if (entry.getStage() != 3) continue;
                ((ObjectId[])threeWayMerge.get((Object)entry.getPathString()))[2] = entry.getObjectId();
            }
            ObjectReader objectReader = fork.getRepository().newObjectReader();
            for (Map.Entry entry : threeWayMerge.entrySet()) {
                Throwable throwable;
                FileOutputStream fos;
                Object loader;
                String message;
                if (((String)entry.getKey()).equals("patch-info.txt")) {
                    fork.rm().addFilepattern((String)entry.getKey()).call();
                    continue;
                }
                Resolver resolver = this.conflictResolver.getResolver((String)entry.getKey());
                String resolved = null;
                if (resolver != null) {
                    message = String.format(" - %s (%s): %s", new Object[]{entry.getKey(), conflicts.get(entry.getKey()), "Using " + resolver.toString() + " to resolve the conflict"});
                    Activator.log2(3, message);
                    File base = null;
                    File first = null;
                    File second = null;
                    try {
                        loader = null;
                        if (((ObjectId[])entry.getValue())[1] != null) {
                            base = new File(fork.getRepository().getWorkTree(), (String)entry.getKey() + ".1");
                            loader = objectReader.open(((ObjectId[])entry.getValue())[1]);
                            fos = new FileOutputStream(base);
                            throwable = null;
                            try {
                                ((ObjectLoader)loader).copyTo(fos);
                            }
                            catch (Throwable x2) {
                                throwable = x2;
                                throw x2;
                            }
                            finally {
                                if (fos != null) {
                                    if (throwable != null) {
                                        try {
                                            fos.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable.addSuppressed(x2);
                                        }
                                    } else {
                                        fos.close();
                                    }
                                }
                            }
                        }
                        first = new File(fork.getRepository().getWorkTree(), (String)entry.getKey() + ".2");
                        loader = objectReader.open(((ObjectId[])entry.getValue())[preferNew ? 2 : 0]);
                        fos = new FileOutputStream(first);
                        throwable = null;
                        try {
                            ((ObjectLoader)loader).copyTo(fos);
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (fos != null) {
                                if (throwable != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    fos.close();
                                }
                            }
                        }
                        second = new File(fork.getRepository().getWorkTree(), (String)entry.getKey() + ".3");
                        loader = objectReader.open(((ObjectId[])entry.getValue())[preferNew ? 0 : 2]);
                        fos = new FileOutputStream(second);
                        throwable = null;
                        try {
                            ((ObjectLoader)loader).copyTo(fos);
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (fos != null) {
                                if (throwable != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    fos.close();
                                }
                            }
                        }
                        resolved = resolver.resolve(first, base, second);
                        if (resolved != null) {
                            FileUtils.write(new File(fork.getRepository().getWorkTree(), (String)entry.getKey()), resolved);
                            fork.add().addFilepattern((String)entry.getKey()).call();
                        }
                    }
                    finally {
                        if (base != null) {
                            base.delete();
                        }
                        if (first != null) {
                            first.delete();
                        }
                        if (second != null) {
                            second.delete();
                        }
                    }
                }
                if (resolved != null) continue;
                message = String.format(" - %s (%s): Choosing %s", new Object[]{entry.getKey(), conflicts.get(entry.getKey()), choose});
                Activator.log2(3, message);
                ObjectLoader loader2 = null;
                ObjectLoader loaderForBackup = null;
                if (preferNew) {
                    switch (conflicts.get(entry.getKey())) {
                        case BOTH_ADDED: 
                        case BOTH_MODIFIED: {
                            loader2 = objectReader.open(((ObjectId[])entry.getValue())[2]);
                            loaderForBackup = objectReader.open(((ObjectId[])entry.getValue())[0]);
                            break;
                        }
                        case BOTH_DELETED: 
                        case DELETED_BY_THEM: {
                            break;
                        }
                        case DELETED_BY_US: {
                            loader2 = objectReader.open(((ObjectId[])entry.getValue())[2]);
                        }
                    }
                } else {
                    switch (conflicts.get(entry.getKey())) {
                        case BOTH_ADDED: 
                        case BOTH_MODIFIED: {
                            loader2 = objectReader.open(((ObjectId[])entry.getValue())[0]);
                            loaderForBackup = objectReader.open(((ObjectId[])entry.getValue())[2]);
                            break;
                        }
                        case DELETED_BY_THEM: {
                            loader2 = objectReader.open(((ObjectId[])entry.getValue())[0]);
                            break;
                        }
                    }
                }
                if (loader2 != null) {
                    FileOutputStream fos2 = new FileOutputStream(new File(fork.getRepository().getWorkTree(), (String)entry.getKey()));
                    loader = null;
                    try {
                        loader2.copyTo(fos2);
                    }
                    catch (Throwable x2) {
                        loader = x2;
                        throw x2;
                    }
                    finally {
                        if (fos2 != null) {
                            if (loader != null) {
                                try {
                                    fos2.close();
                                }
                                catch (Throwable x2) {
                                    ((Throwable)loader).addSuppressed(x2);
                                }
                            } else {
                                fos2.close();
                            }
                        }
                    }
                    fork.add().addFilepattern((String)entry.getKey()).call();
                } else {
                    fork.rm().addFilepattern((String)entry.getKey()).call();
                }
                if (!performBackup || loaderForBackup == null) continue;
                File target = new File(patchDirectory.getParent(), patchDirectory.getName() + ".backup");
                if (cpPrefix != null) {
                    target = new File(target, cpPrefix);
                }
                File file = new File(target, (String)entry.getKey());
                message = String.format("Backing up %s to \"%s\"", backup, file.getCanonicalPath());
                Activator.log2(4, message);
                file.getParentFile().mkdirs();
                fos = new FileOutputStream(file);
                throwable = null;
                try {
                    loaderForBackup.copyTo(fos);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
        }
    }

    private void updateFileReferences(Git fork, PatchData patchData, List<BundleUpdate> bundleUpdatesInThisPatch) {
        if (patchData.isRollupPatch()) {
            return;
        }
        Map<String, String> locationUpdates = Utils.collectLocationUpdates(bundleUpdatesInThisPatch);
        this.updateReferences(fork, "bin/admin", "system/", locationUpdates);
        this.updateReferences(fork, "bin/client", "system/", locationUpdates);
        this.updateReferences(fork, "etc/startup.properties", "", locationUpdates);
        this.updateReferences(fork, "bin/admin.bat", "system/", locationUpdates, true);
        this.updateReferences(fork, "bin/client.bat", "system/", locationUpdates, true);
        this.updateReferences(fork, "etc/config.properties", "${karaf.default.repository}/", locationUpdates);
        File configProperties = new File(fork.getRepository().getWorkTree(), "etc/config.properties");
        for (String file : patchData.getFiles()) {
            String newVersion;
            if ("lib/karaf.jar".equals(file)) {
                newVersion = this.getBundleVersion(new File(fork.getRepository().getWorkTree(), file));
                Utils.updateKarafPackageVersion(configProperties, newVersion, "org.apache.karaf.version");
                continue;
            }
            if ("lib/karaf-jaas-boot.jar".equals(file)) {
                newVersion = this.getBundleVersion(new File(fork.getRepository().getWorkTree(), file));
                Utils.updateKarafPackageVersion(configProperties, newVersion, "org.apache.karaf.jaas.boot", "org.apache.karaf.jaas.boot.principal");
                continue;
            }
            if ("lib/karaf-jmx-boot.jar".equals(file)) {
                newVersion = this.getBundleVersion(new File(fork.getRepository().getWorkTree(), file));
                Utils.updateKarafPackageVersion(configProperties, newVersion, "org.apache.karaf.management.boot");
                continue;
            }
            if (!file.startsWith("lib/org.apache.karaf.diagnostic.core-") || !file.endsWith(".jar")) continue;
            newVersion = this.getBundleVersion(new File(fork.getRepository().getWorkTree(), file));
            Utils.updateKarafPackageVersion(configProperties, newVersion, "org.apache.karaf.diagnostic.core");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateReferences(Git fork, String file, String prefix, Map<String, String> locationUpdates, boolean useBackSlash) {
        File updatedFile = new File(fork.getRepository().getWorkTree(), file);
        if (!updatedFile.isFile()) {
            return;
        }
        BufferedReader reader = null;
        StringWriter sw = new StringWriter();
        try {
            Activator.log2(3, "Updating \"" + file + "\"");
            reader = new BufferedReader(new FileReader(updatedFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                for (Map.Entry<String, String> entry : locationUpdates.entrySet()) {
                    String pattern = prefix + entry.getKey();
                    String replacement = prefix + entry.getValue();
                    if (useBackSlash) {
                        pattern = pattern.replaceAll("/", "\\\\");
                        replacement = replacement.replaceAll("/", "\\\\");
                    }
                    if (!line.contains(pattern)) continue;
                    line = line.replace(pattern, replacement);
                }
                sw.append(line);
                if (useBackSlash) {
                    sw.append("\r");
                }
                sw.append("\n");
            }
            IOUtils.closeQuietly(reader);
            FileUtils.write(updatedFile, sw.toString());
            IOUtils.closeQuietly(reader);
        }
        catch (Exception e) {
            Activator.log(1, null, e.getMessage(), e, true);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private void updateReferences(Git fork, String file, String prefix, Map<String, String> locationUpdates) {
        this.updateReferences(fork, file, prefix, locationUpdates, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBundleVersion(File file) {
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(new FileInputStream(file));
            Manifest mf = jis.getManifest();
            String string = mf.getMainAttributes().getValue("Bundle-Version");
            IOUtils.closeQuietly(jis);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly(jis);
        }
    }

    protected boolean isUserChangeCommit(RevCommit rc) {
        return MARKER_USER_CHANGES_COMMIT.equals(rc.getShortMessage());
    }

    private void transactionIsValid(String transaction, Patch patch) {
        if (!this.pendingTransactions.containsKey(transaction)) {
            if (patch != null) {
                throw new PatchException(String.format("Can't proceed with \"%s\" patch - illegal transaction \"%s\".", patch.getPatchData().getId(), transaction));
            }
            throw new PatchException(String.format("Can't proceed - illegal transaction \"%s\".", transaction));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.patchesDir != null && this.patchesDir.isDirectory() && this.patchesDir.exists();
    }

    @Override
    public void start() throws IOException, GitAPIException {
        if (this.patchesDir != null) {
            this.gitPatchRepository.open();
        }
    }

    @Override
    public void stop() {
        if (this.patchesDir != null) {
            this.gitPatchRepository.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensurePatchManagementInitialized() {
        Activator.log(3, "Configuring patch management system");
        Git fork = null;
        try {
            Git mainRepository = this.gitPatchRepository.findOrCreateMainGitRepository();
            if (this.env.isFabric()) {
                mainRepository.fetch().setRemote("origin").setRefSpecs(new RefSpec("+refs/heads/*:refs/remotes/origin/*")).setTagOpt(TagOpt.FETCH_TAGS).call();
                if (this.env == EnvType.FABRIC_FUSE || this.env == EnvType.FABRIC_AMQ) {
                    ObjectId ours = mainRepository.getRepository().resolve("refs/heads/" + this.gitPatchRepository.getFuseRootContainerPatchBranchName());
                    ObjectId theirs = mainRepository.getRepository().resolve("refs/remotes/origin/" + this.gitPatchRepository.getFuseRootContainerPatchBranchName());
                    if (theirs == null || theirs.equals(ours)) {
                        this.master = true;
                        this.gitPatchRepository.setMaster(true);
                    }
                }
            }
            fork = this.gitPatchRepository.cloneRepository(mainRepository, true);
            if (this.env.isFabric() && this.master) {
                this.trackBaselinesForRootContainer(fork);
                this.trackBaselinesForChildContainers(fork);
                this.trackBaselinesForSSHContainers(fork);
            }
            if (this.env == EnvType.STANDALONE) {
                String currentFuseVersion = this.determineVersion("fuse");
                RevCommit baselineCommit = null;
                if (!this.gitPatchRepository.containsTag(fork, String.format(this.env.getBaselineTagFormat(), currentFuseVersion))) {
                    baselineCommit = this.trackBaselineRepository(fork);
                    RevCommit c2 = this.installPatchManagementBundle(fork);
                    if (c2 != null) {
                        baselineCommit = c2;
                    }
                }
                this.applyUserChanges(fork);
                if (baselineCommit != null) {
                    fork.tag().setName(String.format(this.env.getBaselineTagFormat(), currentFuseVersion)).setObjectId(baselineCommit).call();
                    this.gitPatchRepository.push(fork);
                }
                this.trackBaselinesForChildContainers(fork);
                this.migrateOldPatchData();
            } else if (this.env == EnvType.STANDALONE_CHILD) {
                String currentKarafVersion = this.determineVersion(this.karafBase, "karaf");
                String tagName = String.format(this.env.getBaselineTagFormat(), currentKarafVersion);
                RevTag tag = this.gitPatchRepository.findCurrentBaseline(fork);
                if (tag == null) {
                    this.ensureCorrectContainerHistory(fork, currentKarafVersion);
                    this.applyUserChanges(fork);
                    this.applyChanges(fork, true);
                } else if (!tagName.equals(tag.getTagName())) {
                    this.applyUserChanges(fork);
                    this.ensureCorrectContainerHistory(fork, currentKarafVersion);
                    this.applyChanges(fork, true);
                }
            } else {
                String tagName = String.format(this.env.getBaselineTagFormat(), this.determineVersion(this.karafBase, this.env.getProductId()));
                RevTag tag = this.gitPatchRepository.findCurrentBaseline(fork);
                if (tag == null || !tagName.equals(tag.getTagName())) {
                    this.ensureCorrectContainerHistory(fork, null);
                    this.applyUserChanges(fork);
                }
            }
            for (BundleListener bl : this.pendingPatchesListeners.values()) {
                this.systemContext.removeBundleListener(bl);
            }
            this.initialized.countDown();
            if (fork != null) {
                this.gitPatchRepository.closeRepository(fork, true);
            }
        }
        catch (IOException | GitAPIException e) {
            try {
                Activator.log(1, null, e.getMessage(), e, true);
                this.initialized.countDown();
                if (fork != null) {
                    this.gitPatchRepository.closeRepository(fork, true);
                }
            }
            catch (Throwable throwable) {
                this.initialized.countDown();
                if (fork != null) {
                    this.gitPatchRepository.closeRepository(fork, true);
                }
                throw throwable;
            }
        }
    }

    private String determineVersion(String product) {
        return this.determineVersion(this.karafHome, product);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String determineVersion(File home, String product) {
        block12: {
            block10: {
                block11: {
                    if (this.env == EnvType.FABRIC_CHILD || this.env == EnvType.STANDALONE_CHILD) break block10;
                    versions = new File(home, "fabric/import/fabric/profiles/default.profile/io.fabric8.version.properties");
                    if (!versions.exists() || !versions.isFile()) break block11;
                    props = new Properties();
                    fis = null;
                    try {
                        fis = new FileInputStream(versions);
                        props.load(fis);
                        var6_9 = props.getProperty(product);
                        ** GOTO lbl19
                    }
                    catch (IOException e) {
                        try {
                            Activator.log(1, null, e.getMessage(), e, true);
                            var7_13 = null;
                        }
                        catch (Throwable var8_15) {
                            IOUtils.closeQuietly(fis);
                            throw var8_15;
                        }
lbl19:
                        // 1 sources

                        IOUtils.closeQuietly(fis);
                        return var6_9;
                        IOUtils.closeQuietly(fis);
                        return var7_13;
                    }
                }
                Activator.log2(1, "Can't find io.fabric8.version.properties file in default profile");
                return null;
            }
            startup = new File(home, "etc/startup.properties");
            if (!startup.exists() || !startup.isFile()) break block12;
            props = new Properties();
            fis = null;
            try {
                fis = new FileInputStream(startup);
                props.load(fis);
                for (String key : props.stringPropertyNames()) {
                    if (!key.startsWith("org/apache/karaf/features/org.apache.karaf.features.core") || (artifact = Utils.mvnurlToArtifact(url = Utils.pathToMvnurl(key), true)) == null) continue;
                    var10_18 = artifact.getVersion();
                    ** GOTO lbl47
                }
                ** GOTO lbl49
            }
            catch (IOException e) {
                try {
                    Activator.log(1, null, e.getMessage(), e, true);
                    var7_14 = null;
                }
                catch (Throwable var11_19) {
                    IOUtils.closeQuietly(fis);
                    throw var11_19;
                }
lbl47:
                // 1 sources

                IOUtils.closeQuietly(fis);
                return var10_18;
lbl49:
                // 1 sources

                IOUtils.closeQuietly(fis);
                return null;
                IOUtils.closeQuietly(fis);
                return var7_14;
            }
        }
        Activator.log2(1, "Can't find etc/startup.properties file in child container");
        return null;
    }

    private RevCommit trackBaselineRepository(Git git) throws IOException, GitAPIException {
        String currentFuseVersion = this.determineVersion("fuse");
        String currentFabricVersion = this.determineVersion("fabric");
        File systemRepo = Utils.getSystemRepository(this.karafHome, this.systemContext);
        File baselineDistribution = null;
        String baselineLocation = Utils.getBaselineLocationForProduct(this.karafHome, this.systemContext, currentFuseVersion);
        if (baselineLocation != null) {
            baselineDistribution = new File(this.patchesDir, baselineLocation);
        } else {
            String[] locations;
            for (String location : locations = new String[]{systemRepo.getCanonicalPath() + "/org/jboss/fuse/jboss-fuse-full/%1$s/jboss-fuse-full-%1$s-baseline.zip", this.patchesDir.getCanonicalPath() + "/jboss-fuse-full-%1$s-baseline.zip", systemRepo.getCanonicalPath() + "/org/jboss/amq/jboss-a-mq/%s/jboss-a-mq-%1$s-baseline.zip", this.patchesDir.getCanonicalPath() + "/jboss-a-mq-%1$s-baseline.zip"}) {
                if (!new File(location = String.format(location, currentFuseVersion)).isFile()) continue;
                baselineDistribution = new File(location);
                Activator.log(3, "Found baseline distribution: " + baselineDistribution.getCanonicalPath());
                break;
            }
        }
        if (baselineDistribution != null) {
            return this.trackBaselineRepository(git, baselineDistribution, currentFuseVersion);
        }
        String message = "Can't find baseline distribution in patches dir or inside system repository.";
        Activator.log2(2, message);
        throw new PatchException(message);
    }

    private void trackBaselinesForChildContainers(Git fork) throws IOException, GitAPIException {
        if (fork.getRepository().getRef("refs/heads/" + this.gitPatchRepository.getChildBranchName()) == null) {
            String startPoint = "patch-management^{commit}";
            if (fork.getRepository().getRef("refs/remotes/origin/" + this.gitPatchRepository.getChildBranchName()) != null) {
                startPoint = "refs/remotes/origin/" + this.gitPatchRepository.getChildBranchName();
            }
            this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getChildBranchName()).setStartPoint(startPoint).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
        } else {
            this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getChildBranchName()).call();
        }
        File systemRepo = Utils.getSystemRepository(this.karafHome, this.systemContext);
        File[] versionDirs = new File(systemRepo, "org/apache/karaf/admin/org.apache.karaf.admin.core").listFiles();
        TreeSet<Version> versions = new TreeSet<Version>();
        if (versionDirs != null) {
            for (File version : versionDirs) {
                if (!version.isDirectory()) continue;
                versions.add(new Version(version.getName()));
            }
        }
        for (Version v : versions) {
            String karafVersion = v.toString();
            String tagName = String.format(EnvType.FABRIC_CHILD.getBaselineTagFormat(), karafVersion);
            if (this.gitPatchRepository.containsTag(fork, tagName)) continue;
            File baselineDistribution = null;
            String location = String.format(systemRepo.getCanonicalPath() + "/org/apache/karaf/admin/org.apache.karaf.admin.core/%1$s/org.apache.karaf.admin.core-%1$s.jar", karafVersion);
            if (new File(location).isFile()) {
                baselineDistribution = new File(location);
                Activator.log(3, "Found child baseline distribution: " + baselineDistribution.getCanonicalPath());
            }
            if (baselineDistribution == null) continue;
            try {
                this.unzipKarafAdminJar(baselineDistribution, fork.getRepository().getWorkTree());
                fork.add().addFilepattern(".").call();
                RevCommit commit = this.gitPatchRepository.prepareCommit(fork, String.format(MARKER_BASELINE_CHILD_COMMIT_PATTERN, karafVersion)).call();
                fork.tag().setName(tagName).setObjectId(commit).call();
            }
            catch (Exception e) {
                Activator.log(1, null, e.getMessage(), e, true);
            }
        }
        this.gitPatchRepository.push(fork, this.gitPatchRepository.getChildBranchName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipKarafAdminJar(File artifact, File targetDirectory) throws IOException {
        String prefix = "org/apache/karaf/admin/";
        try (ZipFile zf = new ZipFile(artifact);){
            Enumeration<ZipArchiveEntry> e = zf.getEntries();
            while (e.hasMoreElements()) {
                boolean cygwin;
                ZipArchiveEntry entry = e.nextElement();
                String name = entry.getName();
                if (!name.startsWith(prefix) || !(name = name.substring(prefix.length())).startsWith("bin") && !name.startsWith("etc")) continue;
                boolean windows = System.getProperty("os.name").startsWith("Win");
                boolean bl = cygwin = windows && new File(System.getProperty("karaf.home"), "bin/admin").exists();
                if (entry.isDirectory() || entry.isUnixSymlink() || (windows && !cygwin ? name.startsWith("bin/") && !name.endsWith(".bat") : name.startsWith("bin/") && name.endsWith(".bat"))) continue;
                File file = new File(targetDirectory, name);
                file.getParentFile().mkdirs();
                EOLFixingFileOutputStream output = new EOLFixingFileOutputStream(targetDirectory, file);
                IOUtils.copyLarge(zf.getInputStream(entry), output);
                IOUtils.closeQuietly(output);
                if (Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]) == null || !name.startsWith("bin/") || name.endsWith(".bat")) continue;
                Files.setPosixFilePermissions(file.toPath(), Utils.getPermissionsFromUnixMode(file, 509));
            }
        }
    }

    public void trackBaselinesForSSHContainers(Git fork) throws IOException, GitAPIException {
        String startPoint;
        if (fork.getRepository().getRef("refs/heads/" + this.gitPatchRepository.getFuseSSHContainerPatchBranchName()) == null) {
            startPoint = "patch-management^{commit}";
            if (fork.getRepository().getRef("refs/remotes/origin/" + this.gitPatchRepository.getFuseSSHContainerPatchBranchName()) != null) {
                startPoint = "refs/remotes/origin/" + this.gitPatchRepository.getFuseSSHContainerPatchBranchName();
            }
            this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getFuseSSHContainerPatchBranchName()).setStartPoint(startPoint).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
        }
        if (fork.getRepository().getRef("refs/heads/" + this.gitPatchRepository.getFabric8SSHContainerPatchBranchName()) == null) {
            startPoint = "patch-management^{commit}";
            if (fork.getRepository().getRef("refs/remotes/origin/" + this.gitPatchRepository.getFabric8SSHContainerPatchBranchName()) != null) {
                startPoint = "refs/remotes/origin/" + this.gitPatchRepository.getFabric8SSHContainerPatchBranchName();
            }
            this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getFabric8SSHContainerPatchBranchName()).setStartPoint(startPoint).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
        }
        File systemRepo = Utils.getSystemRepository(this.karafHome, this.systemContext);
        File[] versionDirs = new File(systemRepo, "io/fabric8/fabric8-karaf").listFiles();
        TreeSet<Version> versions = new TreeSet<Version>();
        if (versionDirs != null) {
            for (File version : versionDirs) {
                if (!version.isDirectory()) continue;
                versions.add(new Version(version.getName()));
            }
        }
        for (Version v : versions) {
            String[] artifactPatterns;
            String fabric8Version = v.toString();
            for (String artifactPattern : artifactPatterns = new String[]{"fabric8-karaf-%1$s.zip", "fabric8-karaf-%1$s-custom.zip"}) {
                File baselineDistribution = null;
                String location = String.format(systemRepo.getCanonicalPath() + "/io/fabric8/fabric8-karaf/%1$s/" + artifactPattern, fabric8Version);
                if (new File(location).isFile()) {
                    baselineDistribution = new File(location);
                    Activator.log(3, "Found SSH baseline distribution: " + baselineDistribution.getCanonicalPath());
                }
                if (baselineDistribution == null) continue;
                try {
                    String rootDir = String.format("fabric8-karaf-%s", fabric8Version);
                    String branchName = this.unzipFabric8Distro(rootDir, baselineDistribution, fabric8Version, fork);
                    if (branchName == null) continue;
                    for (String missing : fork.status().call().getMissing()) {
                        fork.rm().addFilepattern(missing).call();
                    }
                    String tagName = branchName.replace("patches-", "");
                    fork.add().addFilepattern(".").call();
                    RevCommit commit = this.gitPatchRepository.prepareCommit(fork, String.format(MARKER_BASELINE_SSH_COMMIT_PATTERN, tagName, fabric8Version)).call();
                    fork.tag().setName(String.format("baseline-%s-%s", tagName, fabric8Version)).setObjectId(commit).call();
                }
                catch (Exception e) {
                    Activator.log(1, null, e.getMessage(), e, true);
                }
            }
        }
        this.gitPatchRepository.push(fork, this.gitPatchRepository.getFuseSSHContainerPatchBranchName());
        this.gitPatchRepository.push(fork, this.gitPatchRepository.getFabric8SSHContainerPatchBranchName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String unzipFabric8Distro(String rootDir, File artifact, String version, Git fork) throws IOException, GitAPIException {
        try (ZipFile zf = new ZipFile(artifact);){
            boolean officialFabric8 = true;
            Enumeration<ZipArchiveEntry> e = zf.getEntries();
            block5: while (e.hasMoreElements()) {
                ZipArchiveEntry entry = e.nextElement();
                String name = entry.getName();
                if (name.startsWith(rootDir + "/")) {
                    name = name.substring(rootDir.length() + 1);
                }
                if (!"etc/startup.properties".equals(name)) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copyLarge(zf.getInputStream(entry), baos);
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(baos.toByteArray()));
                for (String p : props.stringPropertyNames()) {
                    if (!p.startsWith("org/jboss/fuse/shared-commands/")) continue;
                    officialFabric8 = false;
                    continue block5;
                }
            }
            if (officialFabric8) {
                if (this.gitPatchRepository.containsTag(fork, String.format("baseline-ssh-fabric8-%s", version))) {
                    e = null;
                    return e;
                }
                this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getFabric8SSHContainerPatchBranchName()).call();
            } else {
                if (this.gitPatchRepository.containsTag(fork, String.format("baseline-ssh-fuse-%s", version))) {
                    e = null;
                    return e;
                }
                this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getFuseSSHContainerPatchBranchName()).call();
            }
            for (String managedDirectory : MANAGED_DIRECTORIES) {
                FileUtils.deleteDirectory(new File(fork.getRepository().getWorkTree(), managedDirectory));
            }
            e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry = e.nextElement();
                String name = entry.getName();
                if (name.startsWith(rootDir + "/")) {
                    name = name.substring(rootDir.length() + 1);
                }
                if (!name.startsWith("bin") && !name.startsWith("etc") && !name.startsWith("fabric") && !name.startsWith("lib") && !name.startsWith("licenses") && !name.startsWith("metatype") || entry.isDirectory() || entry.isUnixSymlink()) continue;
                File file = new File(fork.getRepository().getWorkTree(), name);
                file.getParentFile().mkdirs();
                EOLFixingFileOutputStream output = new EOLFixingFileOutputStream(fork.getRepository().getWorkTree(), file);
                IOUtils.copyLarge(zf.getInputStream(entry), output);
                IOUtils.closeQuietly(output);
                if (Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]) == null || !name.startsWith("bin/") || name.endsWith(".bat")) continue;
                Files.setPosixFilePermissions(file.toPath(), Utils.getPermissionsFromUnixMode(file, 509));
            }
            String string = officialFabric8 ? this.gitPatchRepository.getFabric8SSHContainerPatchBranchName() : this.gitPatchRepository.getFuseSSHContainerPatchBranchName();
            return string;
        }
    }

    private void trackBaselinesForRootContainer(Git fork) throws IOException, GitAPIException {
        RevCommit commit;
        File location;
        File baselineDistribution;
        String startPoint;
        if (fork.getRepository().getRef("refs/heads/" + this.gitPatchRepository.getFuseRootContainerPatchBranchName()) == null) {
            startPoint = "patch-management^{commit}";
            if (fork.getRepository().getRef("refs/remotes/origin/" + this.gitPatchRepository.getFuseRootContainerPatchBranchName()) != null) {
                startPoint = "refs/remotes/origin/" + this.gitPatchRepository.getFuseRootContainerPatchBranchName();
            }
            this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getFuseRootContainerPatchBranchName()).setStartPoint(startPoint).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
        }
        if (fork.getRepository().getRef("refs/heads/" + this.gitPatchRepository.getAmqRootContainerPatchBranchName()) == null) {
            startPoint = "patch-management^{commit}";
            if (fork.getRepository().getRef("refs/remotes/origin/" + this.gitPatchRepository.getAmqRootContainerPatchBranchName()) != null) {
                startPoint = "refs/remotes/origin/" + this.gitPatchRepository.getAmqRootContainerPatchBranchName();
            }
            this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getAmqRootContainerPatchBranchName()).setStartPoint(startPoint).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
        }
        File systemRepo = Utils.getSystemRepository(this.karafHome, this.systemContext);
        String currentFuseVersion = this.determineVersion("fuse");
        String currentFabricVersion = this.determineVersion("fabric");
        File[] versionDirs = new File(systemRepo, "org/jboss/fuse/jboss-fuse-full").listFiles();
        TreeMap<Version, File> versions = new TreeMap<Version, File>();
        this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getFuseRootContainerPatchBranchName()).call();
        versions.put(new Version(currentFuseVersion), this.patchesDir);
        if (versionDirs != null) {
            for (File version : versionDirs) {
                if (!version.isDirectory()) continue;
                versions.put(new Version(version.getName()), version);
            }
        }
        for (Map.Entry entry : versions.entrySet()) {
            String version = ((Version)entry.getKey()).toString();
            if (this.gitPatchRepository.containsTag(fork, String.format(EnvType.FABRIC_FUSE.getBaselineTagFormat(), version))) continue;
            baselineDistribution = null;
            location = new File((File)entry.getValue(), String.format("jboss-fuse-full-%1$s-baseline.zip", version));
            if (location.isFile()) {
                baselineDistribution = location;
                Activator.log(3, "Found Fuse baseline distribution: " + baselineDistribution.getCanonicalPath());
            }
            if (baselineDistribution == null) continue;
            commit = this.trackBaselineRepository(fork, baselineDistribution, version);
            fork.tag().setName(String.format(EnvType.FABRIC_FUSE.getBaselineTagFormat(), version)).setObjectId(commit).call();
        }
        versionDirs = new File(systemRepo, "org/jboss/amq/jboss-a-mq").listFiles();
        versions.clear();
        this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getAmqRootContainerPatchBranchName()).call();
        versions.put(new Version(currentFuseVersion), this.patchesDir);
        if (versionDirs != null) {
            for (File version : versionDirs) {
                if (!version.isDirectory()) continue;
                versions.put(new Version(version.getName()), version);
            }
        }
        for (Map.Entry entry : versions.entrySet()) {
            String version = ((Version)entry.getKey()).toString();
            if (this.gitPatchRepository.containsTag(fork, String.format(EnvType.FABRIC_AMQ.getBaselineTagFormat(), version))) continue;
            baselineDistribution = null;
            location = new File((File)entry.getValue(), String.format("jboss-a-mq-%1$s-baseline.zip", version));
            if (location.isFile()) {
                baselineDistribution = location;
                Activator.log(3, "Found AMQ baseline distribution: " + baselineDistribution.getCanonicalPath());
            }
            if (baselineDistribution == null) continue;
            commit = this.trackBaselineRepository(fork, baselineDistribution, version);
            fork.tag().setName(String.format(EnvType.FABRIC_AMQ.getBaselineTagFormat(), version)).setObjectId(commit).call();
        }
        this.gitPatchRepository.push(fork, this.gitPatchRepository.getFuseRootContainerPatchBranchName());
        this.gitPatchRepository.push(fork, this.gitPatchRepository.getAmqRootContainerPatchBranchName());
    }

    private RevCommit trackBaselineRepository(Git git, File baselineDistribution, String version) throws IOException, GitAPIException {
        File featuresCfg;
        for (String managedDirectory : MANAGED_DIRECTORIES) {
            FileUtils.deleteDirectory(new File(git.getRepository().getWorkTree(), managedDirectory));
        }
        Utils.unpack(baselineDistribution, git.getRepository().getWorkTree(), 1);
        String fabricVersion = this.determineVersion(git.getRepository().getWorkTree(), "fabric");
        git.add().addFilepattern(".").call();
        for (String missing : git.status().call().getMissing()) {
            git.rm().addFilepattern(missing).call();
        }
        this.gitPatchRepository.prepareCommit(git, String.format("[PATCH/baseline] Installing baseline-%s", version)).call();
        if (!this.env.isFabric() && (featuresCfg = new File(git.getRepository().getWorkTree(), "etc/org.apache.karaf.features.cfg")).isFile()) {
            List<String> lines = FileUtils.readLines(featuresCfg);
            LinkedList<String> newVersion = new LinkedList<String>();
            for (String line : lines) {
                if (!line.contains("mvn:io.fabric8.patch/patch-features/") || fabricVersion == null) {
                    newVersion.add(line);
                    continue;
                }
                String newLine = line.replace(fabricVersion, this.bundleContext.getBundle().getVersion().toString());
                newVersion.add(newLine);
            }
            StringBuilder sb = new StringBuilder();
            for (String newLine : newVersion) {
                sb.append(newLine).append("\n");
            }
            FileUtils.write(featuresCfg, sb.toString());
            git.add().addFilepattern("etc/org.apache.karaf.features.cfg").call();
            this.gitPatchRepository.prepareCommit(git, String.format(MARKER_BASELINE_REPLACE_PATCH_FEATURE_PATTERN, version, this.bundleContext.getBundle().getVersion().toString())).call();
            FileUtils.copyFile(featuresCfg, new File(this.karafBase, "etc/org.apache.karaf.features.cfg"));
        }
        this.resetOverrides(git.getRepository().getWorkTree());
        git.add().addFilepattern("etc/overrides.properties").call();
        return this.gitPatchRepository.prepareCommit(git, String.format(MARKER_BASELINE_RESET_OVERRIDES_PATTERN, version)).call();
    }

    private void ensureCorrectContainerHistory(Git fork, String version) throws IOException, GitAPIException {
        if (fork.getRepository().getRef("refs/heads/" + this.gitPatchRepository.getMainBranchName()) == null) {
            String startPoint = "patch-management^{commit}";
            if (fork.getRepository().getRef("refs/remotes/origin/" + this.gitPatchRepository.getMainBranchName()) != null) {
                startPoint = "refs/remotes/origin/" + this.gitPatchRepository.getMainBranchName();
            }
            this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getMainBranchName()).setStartPoint(startPoint).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
        } else {
            this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getMainBranchName()).call();
        }
        if (version == null) {
            version = this.determineVersion(this.env.getProductId());
        }
        ObjectId since = fork.getRepository().resolve("patch-management^{commit}");
        ObjectId to = fork.getRepository().resolve(this.gitPatchRepository.getMainBranchName() + "^{commit}");
        Object mainChanges = fork.log().addRange(since, to).call();
        LinkedList<RevCommit> userChanges = new LinkedList<RevCommit>();
        Iterator i$ = mainChanges.iterator();
        while (i$.hasNext()) {
            RevCommit rc = (RevCommit)i$.next();
            if (!this.isUserChangeCommit(rc)) continue;
            userChanges.add(rc);
        }
        fork.reset().setMode(ResetCommand.ResetType.HARD).setRef(String.format(this.env.getBaselineTagFormat(), version)).call();
        ListIterator it = userChanges.listIterator(userChanges.size());
        int prefixSize = Integer.toString(userChanges.size()).length();
        int count = 1;
        fork.reset().setMode(ResetCommand.ResetType.HARD).call();
        while (it.hasPrevious()) {
            RevCommit userChange = (RevCommit)it.previous();
            String prefix = String.format("%0" + prefixSize + "d-%s", count++, userChange.getName());
            CherryPickResult result = fork.cherryPick().include(userChange).setNoCommit(true).call();
            this.handleCherryPickConflict(null, fork, result, userChange, false, PatchKind.ROLLUP, null, false);
            this.gitPatchRepository.prepareCommit(fork, userChange.getFullMessage()).call();
            fork.reset().setMode(ResetCommand.ResetType.HARD).call();
        }
        this.gitPatchRepository.push(fork, this.gitPatchRepository.getMainBranchName());
    }

    public void applyUserChanges(Git git) throws GitAPIException, IOException {
        File wcDir = git.getRepository().getDirectory().getParentFile();
        try {
            this.copyManagedDirectories(this.karafBase, wcDir, false, true, false);
            Status status = git.status().call();
            if (!status.isClean()) {
                boolean amend = false;
                if (status.getUntracked().size() == 0 && status.getMissing().size() == 0 && status.getModified().size() == 1 && "etc/io.fabric8.mq.fabric.server-broker.cfg".equals(status.getModified().iterator().next())) {
                    amend = true;
                }
                Activator.log(3, (amend ? "Amending" : "Storing") + " user changes");
                git.add().addFilepattern(".").call();
                this.gitPatchRepository.prepareCommit(git, MARKER_USER_CHANGES_COMMIT).setAmend(amend).call();
                this.gitPatchRepository.push(git);
            } else {
                Activator.log(3, "No user changes detected");
            }
        }
        catch (IOException | GitAPIException e) {
            Activator.log(1, null, e.getMessage(), e, true);
        }
    }

    private void copyManagedDirectories(File sourceDir, File targetDir, boolean removeTarget, boolean onlyModified, boolean useLibNext) throws IOException {
        for (String dir : MANAGED_DIRECTORIES) {
            File[] files;
            File managedSrcDir = new File(sourceDir, dir);
            if (!managedSrcDir.exists()) continue;
            File destDir = new File(targetDir, dir);
            if (useLibNext && "lib".equals(dir)) {
                destDir = new File(targetDir, "lib.next");
                if (removeTarget) {
                    FileUtils.deleteQuietly(destDir);
                }
                FileUtils.copyDirectory(managedSrcDir, destDir);
            } else {
                if (removeTarget) {
                    FileUtils.deleteQuietly(destDir);
                }
                EOLFixingFileUtils.copyDirectory(managedSrcDir, targetDir, destDir, onlyModified);
            }
            if (!"bin".equals(dir) || (files = destDir.listFiles()) == null) continue;
            for (File script : files) {
                if (script.getName().endsWith(".bat") || Files.getFileAttributeView(script.toPath(), PosixFileAttributeView.class, new LinkOption[0]) == null) continue;
                Files.setPosixFilePermissions(script.toPath(), Utils.getPermissionsFromUnixMode(script, 509));
            }
        }
    }

    private RevCommit installPatchManagementBundle(Git git) throws IOException, GitAPIException {
        String bundleVersion;
        String patchManagementArtifact;
        File fileinstallDeployDir = Utils.getDeployDir(this.karafHome);
        File deployedPatchManagement = new File(fileinstallDeployDir, patchManagementArtifact = String.format("patch-management-%s.jar", bundleVersion = this.bundleContext.getBundle().getVersion().toString()));
        if (deployedPatchManagement.exists() && deployedPatchManagement.isFile()) {
            File systemRepo = Utils.getSystemRepository(this.karafHome, this.systemContext);
            String targetFile = String.format("io/fabric8/patch/patch-management/%s/patch-management-%s.jar", bundleVersion, bundleVersion);
            File target = new File(systemRepo, targetFile);
            target.getParentFile().mkdirs();
            FileUtils.copyFile(deployedPatchManagement, target);
        }
        ((BundleStartLevel)this.bundleContext.getBundle().adapt(BundleStartLevel.class)).setStartLevel(2);
        return this.replacePatchManagementBundleInStartupPropertiesIfNecessary(git, bundleVersion);
    }

    private RevCommit replacePatchManagementBundleInStartupPropertiesIfNecessary(Git git, String bundleVersion) throws IOException, GitAPIException {
        boolean modified = false;
        boolean installed = false;
        File etcStartupProperties = new File(git.getRepository().getDirectory().getParent(), "etc/startup.properties");
        List<String> lines = FileUtils.readLines(etcStartupProperties);
        LinkedList<String> newVersion = new LinkedList<String>();
        for (String line : lines) {
            Version v2;
            if (!line.startsWith("io/fabric8/patch/patch-management/")) {
                newVersion.add(line);
                continue;
            }
            Matcher matcher = VERSION_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            String alreadyInstalledVersion = matcher.group(1);
            Version v1 = new Version(alreadyInstalledVersion);
            if (v1.equals((Object)(v2 = new Version(bundleVersion)))) {
                installed = true;
                continue;
            }
            if (v1.compareTo(v2) >= 0) continue;
            modified = true;
        }
        if (modified || !installed) {
            newVersion.add("");
            newVersion.add("# installed by patch-management");
            newVersion.add(String.format("io/fabric8/patch/patch-management/%s/patch-management-%s.jar=%d", bundleVersion, bundleVersion, 2));
            StringBuilder sb = new StringBuilder();
            for (String newLine : newVersion) {
                sb.append(newLine).append("\n");
            }
            FileUtils.write(new File(git.getRepository().getDirectory().getParent(), "etc/startup.properties"), sb.toString());
            git.add().addFilepattern("etc/startup.properties").call();
            RevCommit commit = this.gitPatchRepository.prepareCommit(git, String.format(MARKER_PATCH_MANAGEMENT_INSTALLATION_COMMIT_PATTERN, bundleVersion)).call();
            this.applyChanges(git, commit.getParent(0), commit);
            Activator.log(3, String.format("patch-management-%s.jar installed in etc/startup.properties.", bundleVersion));
            return commit;
        }
        return null;
    }

    private void applyChanges(Git git, boolean restartFileInstall) throws IOException, GitAPIException {
        File overrides;
        Bundle fileInstall = null;
        for (Bundle b : this.systemContext.getBundles()) {
            if (!Utils.stripSymbolicName(b.getSymbolicName()).equals("org.apache.felix.fileinstall")) continue;
            fileInstall = b;
            break;
        }
        if (fileInstall != null) {
            try {
                fileInstall.stop(1);
            }
            catch (Exception e) {
                Activator.log(2, e.getMessage());
            }
        }
        File wcDir = git.getRepository().getWorkTree();
        this.copyManagedDirectories(wcDir, this.karafBase, true, true, true);
        File lib = new File(wcDir, "lib");
        if (lib.exists()) {
            FileUtils.copyDirectory(lib, new File(this.karafBase, "lib.next"));
        }
        if ((overrides = new File(this.karafBase, "etc/overrides.properties")).exists() && overrides.length() == 0L) {
            FileUtils.deleteQuietly(overrides);
        }
        if (restartFileInstall && fileInstall != null) {
            try {
                fileInstall.start(1);
            }
            catch (Exception e) {
                Activator.log(2, e.getMessage());
            }
        }
    }

    private void applyChanges(Git git, RevCommit commit1, RevCommit commit2) throws IOException, GitAPIException {
        File wcDir = git.getRepository().getWorkTree();
        List<DiffEntry> diff = this.gitPatchRepository.diff(git, commit1, commit2);
        File lib = new File(this.karafBase, "lib");
        if (lib.isDirectory()) {
            FileUtils.copyDirectory(lib, new File(this.karafBase, "lib.next"));
        }
        boolean libDirectoryChanged = false;
        for (DiffEntry de : diff) {
            DiffEntry.ChangeType ct = de.getChangeType();
            String newPath = de.getNewPath();
            String oldPath = de.getOldPath();
            switch (ct) {
                case ADD: 
                case MODIFY: {
                    Activator.log(4, "[PATCH-change] Modifying " + newPath);
                    String targetPath = newPath;
                    if (newPath.startsWith("lib/")) {
                        targetPath = "lib.next/" + newPath.substring(4);
                        libDirectoryChanged = true;
                    }
                    File srcFile = new File(wcDir, newPath);
                    File destFile = new File(this.karafBase, targetPath);
                    if ("etc/overrides.properties".equals(newPath) && srcFile.exists() && srcFile.length() == 0L) {
                        FileUtils.deleteQuietly(destFile);
                        break;
                    }
                    FileUtils.copyFile(srcFile, destFile);
                    break;
                }
                case DELETE: {
                    Activator.log(4, "[PATCH-change] Deleting " + newPath);
                    if (oldPath.startsWith("lib/")) {
                        oldPath = "lib.next/" + oldPath.substring(4);
                        libDirectoryChanged = true;
                    }
                    FileUtils.deleteQuietly(new File(this.karafBase, oldPath));
                    break;
                }
            }
        }
        if (!libDirectoryChanged) {
            FileUtils.deleteDirectory(new File(this.karafBase, "lib.next"));
        }
    }

    @Override
    public void cleanupDeployDir() throws IOException {
        Version ourVersion = this.bundleContext.getBundle().getVersion();
        File deploy = Utils.getDeployDir(this.karafHome);
        File[] deployedPatchManagementBundles = deploy.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return VERSION_PATTERN.matcher(name).matches();
            }
        });
        if (deployedPatchManagementBundles != null) {
            for (File anotherPatchManagementBundle : deployedPatchManagementBundles) {
                Matcher matcher = VERSION_PATTERN.matcher(anotherPatchManagementBundle.getName());
                matcher.find();
                String version = matcher.group(1);
                Version deployedVersion = new Version(version);
                if (ourVersion.compareTo(deployedVersion) < 0) continue;
                Activator.log(3, "Deleting " + anotherPatchManagementBundle);
                FileUtils.deleteQuietly(anotherPatchManagementBundle);
            }
        }
    }

    @Override
    public void checkPendingPatches() {
        File[] pendingPatches = this.patchesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.exists() && pathname.getName().endsWith(".pending");
            }
        });
        if (pendingPatches.length == 0) {
            return;
        }
        final String dataCache = this.systemContext.getProperty("org.osgi.framework.storage");
        for (File pending : pendingPatches) {
            try {
                Pending what = Pending.valueOf(FileUtils.readFileToString(pending));
                final String prefix = what == Pending.ROLLUP_INSTALLATION ? "install" : "rollback";
                File patchFile = new File(pending.getParentFile(), pending.getName().replaceFirst("\\.pending$", ""));
                PatchData patchData = PatchData.load(new FileInputStream(patchFile));
                Patch patch = this.loadPatch(new PatchDetailsRequest(patchData.getId()));
                final File dataFilesBackupDir = new File(pending.getParentFile(), patchData.getId() + ".datafiles");
                final Properties backupProperties = new Properties();
                FileInputStream inStream = new FileInputStream(new File(dataFilesBackupDir, "backup-" + prefix + ".properties"));
                backupProperties.load(inStream);
                IOUtils.closeQuietly(inStream);
                for (Bundle b : this.systemContext.getBundles()) {
                    String key = String.format("%s$$%s", Utils.stripSymbolicName(b.getSymbolicName()), b.getVersion().toString());
                    if (!backupProperties.containsKey(key)) continue;
                    String backupDirName = backupProperties.getProperty(key);
                    File backupDir = new File(dataFilesBackupDir, prefix + "/" + backupDirName + "/data");
                    this.restoreDataDirectory(dataCache, b, backupDir);
                    backupProperties.remove(key);
                }
                SynchronousBundleListener bundleListener = new SynchronousBundleListener(){

                    public void bundleChanged(BundleEvent event) {
                        String key;
                        Bundle b = event.getBundle();
                        if (event.getType() == 1 && backupProperties.containsKey(key = String.format("%s$$%s", Utils.stripSymbolicName(b.getSymbolicName()), b.getVersion().toString()))) {
                            String backupDirName = backupProperties.getProperty(key);
                            File backupDir = new File(dataFilesBackupDir, prefix + "/" + backupDirName + "/data");
                            GitPatchManagementServiceImpl.this.restoreDataDirectory(dataCache, b, backupDir);
                        }
                    }
                };
                this.systemContext.addBundleListener((BundleListener)bundleListener);
                this.pendingPatchesListeners.put(patchData.getId(), (BundleListener)bundleListener);
            }
            catch (Exception e) {
                Activator.log(1, null, e.getMessage(), e, true);
            }
        }
    }

    @Override
    public void installProfiles(File gitRepository, String versionId, Patch patch, ProfileUpdateStrategy strategy) {
        Git git = null;
        try {
            git = Git.open(gitRepository);
            File src = new File(patch.getPatchData().getPatchDirectory(), "fabric/import/fabric/profiles");
            File dst = new File(git.getRepository().getWorkTree(), "fabric/profiles");
            ProfileFileUtils.copyDirectory(src, dst, strategy);
            git.add().addFilepattern(".").call();
            PatchResult result = patch.getResult();
            if (result == null) {
                result = new PatchResult(patch.getPatchData(), false, new Date().getTime(), null, null);
                patch.setResult(result);
            }
            result.getVersions().add(versionId);
            result.store();
        }
        catch (Exception e) {
            throw new PatchException(e.getMessage(), e);
        }
        finally {
            if (git != null) {
                this.gitPatchRepository.closeRepository(git, false);
            }
        }
    }

    @Override
    public boolean isStandaloneChild() {
        return this.env == EnvType.STANDALONE_CHILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alignTo(Map<String, String> versions, List<String> urls, File localMavenRepository, Runnable callback) throws PatchException {
        if (this.aligning.getAndSet(true)) {
            return false;
        }
        try {
            if (!this.env.isFabric()) {
                try {
                    this.env = this.envService.determineEnvironmentType();
                    File patchRepositoryLocation = new File(this.patchesDir, ".management/history");
                    this.getGitPatchRepository().close();
                    GitPatchRepositoryImpl repository = new GitPatchRepositoryImpl(this.env, patchRepositoryLocation, this.karafHome, this.karafBase, this.karafData, this.patchesDir);
                    this.setGitPatchRepository(repository);
                    this.start();
                    this.ensurePatchManagementInitialized();
                    if (this.master) {
                        callback.run();
                    }
                }
                catch (Exception e) {
                    throw new PatchException(e.getMessage(), e);
                }
            }
            if (this.env.isFabric()) {
                String version;
                Git fork;
                block36: {
                    fork = null;
                    version = versions.get(this.env.getProductId());
                    String tagName = String.format(this.env.getBaselineTagFormat(), version);
                    Git mainRepository = this.gitPatchRepository.findOrCreateMainGitRepository();
                    fork = this.gitPatchRepository.cloneRepository(mainRepository, true);
                    this.gitPatchRepository.checkout(fork).setName(this.gitPatchRepository.getMainBranchName()).call();
                    RevTag tag = this.gitPatchRepository.findCurrentBaseline(fork);
                    if (tag == null || !tagName.equals(tag.getTagName())) break block36;
                    boolean bl = false;
                    if (fork != null) {
                        this.gitPatchRepository.closeRepository(fork, true);
                    }
                    return bl;
                }
                try {
                    this.applyUserChanges(fork);
                    this.ensureCorrectContainerHistory(fork, version);
                    this.applyChanges(fork, false);
                    if (localMavenRepository != null) {
                        try {
                            File systemRepo = Utils.getSystemRepository(this.karafHome, this.systemContext);
                            File etcStartupProperties = new File(this.karafBase, "etc/startup.properties");
                            try (FileInputStream fis = new FileInputStream(etcStartupProperties);){
                                Properties props = new Properties();
                                props.load(fis);
                                for (String artifact : props.stringPropertyNames()) {
                                    File target = new File(systemRepo, artifact);
                                    File src = new File(localMavenRepository, artifact);
                                    if (target.exists() || !src.isFile()) continue;
                                    FileUtils.copyFile(src, target);
                                }
                            }
                            for (String url : urls) {
                                String path = Utils.mvnurlToPath(url);
                                if (path == null) continue;
                                File target = new File(systemRepo, path);
                                File src = new File(localMavenRepository, path);
                                if (target.exists() || !src.isFile()) continue;
                                FileUtils.copyFile(src, target);
                            }
                        }
                        catch (Exception e) {
                            Activator.log(1, null, e.getMessage(), e, false);
                        }
                    }
                    boolean bl = true;
                    if (fork != null) {
                        this.gitPatchRepository.closeRepository(fork, true);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        throw new PatchException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        if (fork != null) {
                            this.gitPatchRepository.closeRepository(fork, true);
                        }
                        throw throwable;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.aligning.set(false);
        }
    }

    private void restoreDataDirectory(String dataCache, Bundle bundle, File backupDir) {
        if (backupDir.isDirectory()) {
            Activator.log2(3, String.format("Restoring data directory for bundle %s", bundle.toString()));
            File bundleDataDir = new File(dataCache, "bundle" + bundle.getBundleId() + "/data");
            try {
                FileUtils.copyDirectory(backupDir, bundleDataDir);
            }
            catch (IOException e) {
                Activator.log(1, null, e.getMessage(), e, true);
            }
        }
    }

    private void migrateOldPatchData() throws IOException {
        String newPatchLocation;
        String oldPatchLocation;
        File systemBundleData = this.systemContext.getDataFile("patches");
        if (systemBundleData.exists() && systemBundleData.isDirectory()) {
            this.movePatchData(systemBundleData);
        }
        if ((oldPatchLocation = this.systemContext.getProperty("fabric8.patch.location")) == null || !"".equals(oldPatchLocation)) {
            // empty if block
        }
        if ((newPatchLocation = this.systemContext.getProperty("fuse.patch.location")) == null || !"".equals(newPatchLocation)) {
            // empty if block
        }
    }

    private void movePatchData(File systemBundleData) throws IOException {
        FileUtils.copyDirectory(systemBundleData, this.patchesDir);
        FileUtils.deleteDirectory(systemBundleData);
    }
}

