/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.conflicts;

import io.fabric8.patch.management.conflicts.ChooseUserVersionResolver;
import io.fabric8.patch.management.conflicts.Fabric8AgentPropertiesFileResolver;
import io.fabric8.patch.management.conflicts.KarafFeaturesPropertiesFileResolver;
import io.fabric8.patch.management.conflicts.PropertiesFileResolver;
import io.fabric8.patch.management.conflicts.Resolver;
import io.fabric8.patch.management.conflicts.UsersPropertiesResolver;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class ConflictResolver {
    private Map<String, Resolver> builtInResolvers = new HashMap<String, Resolver>();

    public ConflictResolver() {
        this.builtInResolvers.put("etc/users.properties", new UsersPropertiesResolver());
        this.builtInResolvers.put("etc/org.apache.karaf.features.cfg", new KarafFeaturesPropertiesFileResolver());
        this.builtInResolvers.put("bin/setenv", new ChooseUserVersionResolver());
        this.builtInResolvers.put("bin/setenv.bat", new ChooseUserVersionResolver());
        this.builtInResolvers.put("io.fabric8.agent.properties", new Fabric8AgentPropertiesFileResolver());
        PropertiesFileResolver resolver = new PropertiesFileResolver();
        this.builtInResolvers.put("*.properties", resolver);
        this.builtInResolvers.put("*.cfg", resolver);
    }

    public Resolver getResolver(String path) {
        String name;
        Resolver resolver = this.builtInResolvers.get(path);
        if (resolver == null && (resolver = this.builtInResolvers.get(name = FilenameUtils.getName(path))) == null) {
            String ext = FilenameUtils.getExtension(path);
            resolver = this.builtInResolvers.get("*." + ext);
        }
        return resolver;
    }
}

