/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.impl;

import io.fabric8.patch.management.ManagedPatch;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.transport.PushResult;

public interface GitPatchRepository {
    public static final DateFormat TS = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
    public static final DateFormat FULL_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String HISTORY_BRANCH = "container-history";
    public static final String ADMIN_HISTORY_BRANCH = "admin-container-history";

    public void open() throws IOException, GitAPIException;

    public void close();

    public Git findOrCreateMainGitRepository() throws IOException, GitAPIException;

    public Git findOrCreateGitRepository(File var1, boolean var2) throws IOException;

    public Git cloneRepository(Git var1, boolean var2) throws GitAPIException, IOException;

    public void closeRepository(Git var1, boolean var2);

    public CheckoutCommand checkout(Git var1);

    public boolean containsCommit(Git var1, String var2, String var3) throws IOException, GitAPIException;

    public boolean containsTag(Git var1, String var2) throws GitAPIException;

    public CommitCommand prepareCommit(Git var1, String var2);

    public void push(Git var1) throws GitAPIException;

    public void push(Git var1, String var2) throws GitAPIException;

    public List<DiffEntry> diff(Git var1, RevCommit var2, RevCommit var3) throws GitAPIException, IOException;

    public List<DiffEntry> diff(Git var1, RevCommit var2, RevCommit var3, boolean var4) throws GitAPIException, IOException;

    public RevTag findLatestBaseline(Git var1) throws GitAPIException, IOException;

    public RevTag findCurrentBaseline(Git var1) throws GitAPIException, IOException;

    public RevTag findNthPreviousBaseline(Git var1, int var2) throws GitAPIException, IOException;

    public ManagedPatch getManagedPatch(String var1) throws IOException;

    public Map<String, RevTag> findTagsBetween(Git var1, RevCommit var2, RevCommit var3) throws GitAPIException, IOException;

    public String getMainBranchName();

    public String getChildBranchName();

    public String getFuseSSHContainerPatchBranchName();

    public String getFabric8SSHContainerPatchBranchName();

    public String getFuseRootContainerPatchBranchName();

    public String getAmqRootContainerPatchBranchName();

    public void setMaster(boolean var1);

    public String getFileContent(Git var1, String var2, String var3) throws IOException;

    public String getStandaloneChildkarafName();

    public Iterable<PushResult> pushPatchBranches() throws GitAPIException;
}

