/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.impl;

import io.fabric8.patch.management.EnvType;
import io.fabric8.patch.management.ManagedPatch;
import io.fabric8.patch.management.Utils;
import io.fabric8.patch.management.impl.GitPatchRepository;
import io.fabric8.patch.management.io.NtfsAwareCheckoutCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.osgi.framework.Version;

public class GitPatchRepositoryImpl
implements GitPatchRepository {
    public static final String MAIN_GIT_REPO_LOCATION = ".management/history";
    private static final Pattern BASELINE_TAG_PATTERN = Pattern.compile("^baseline-.*(\\d.+)$");
    private final EnvType env;
    private final boolean isFabric;
    private File karafHome;
    private File karafBase;
    private File karafData;
    private File patchesDir;
    private File gitPatchManagement;
    private Git mainRepository;
    private File tmpPatchManagement;
    private String mainPatchBranchName;
    private String childContainerPatchBranchName;
    private String fuseSSHContainerPatchBranchName;
    private String fabric8SSHContainerPatchBranchName;
    private String fuseRootContainerPatchBranchName;
    private String amqRootContainerPatchBranchName;
    private boolean master;
    private String standaloneChildkarafName;

    public GitPatchRepositoryImpl(EnvType env, File patchRepositoryLocation, File karafHome, File karafBase, File karafData, File patchesDir) {
        this.env = env;
        this.isFabric = env.isFabric();
        this.mainPatchBranchName = "container-history";
        if (env == EnvType.STANDALONE_CHILD) {
            String suffix = "";
            try {
                Properties systemProperties = new Properties();
                try (FileInputStream fis = new FileInputStream(new File(karafBase, "etc/system.properties"));){
                    systemProperties.load(fis);
                    this.standaloneChildkarafName = systemProperties.getProperty("karaf.name");
                    if (this.standaloneChildkarafName != null && !"".equals(this.standaloneChildkarafName)) {
                        suffix = "-" + this.standaloneChildkarafName.replace(' ', '_');
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            this.mainPatchBranchName = "admin-container-history" + suffix;
        }
        if (this.isFabric) {
            this.childContainerPatchBranchName = "patches-child";
            this.fuseSSHContainerPatchBranchName = "patches-ssh-fuse";
            this.fabric8SSHContainerPatchBranchName = "patches-ssh-fabric8";
            this.fuseRootContainerPatchBranchName = "patches-root-fuse";
            this.amqRootContainerPatchBranchName = "patches-root-amq";
        } else {
            this.childContainerPatchBranchName = "patches-admin-child";
        }
        this.gitPatchManagement = patchRepositoryLocation;
        this.karafHome = karafHome;
        this.karafBase = karafBase;
        this.karafData = karafData;
        this.patchesDir = patchesDir;
    }

    @Override
    public void open() throws IOException, GitAPIException {
        if (!this.gitPatchManagement.exists()) {
            this.gitPatchManagement.mkdirs();
        }
        this.tmpPatchManagement = new File(this.patchesDir, "tmp");
        if (this.tmpPatchManagement.exists()) {
            GitPatchRepositoryImpl.recursiveDelete(this.tmpPatchManagement);
        }
        this.tmpPatchManagement.mkdirs();
        this.findOrCreateMainGitRepository();
    }

    public static int recursiveDelete(File file) {
        File[] files;
        int answer = 0;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                answer += GitPatchRepositoryImpl.recursiveDelete(child);
            }
        }
        if (file.delete()) {
            ++answer;
        }
        return answer;
    }

    @Override
    public void close() {
        if (this.mainRepository != null) {
            this.mainRepository.close();
        }
        RepositoryCache.clear();
    }

    @Override
    public Git findOrCreateMainGitRepository() throws IOException, GitAPIException {
        StoredConfig config;
        if (this.mainRepository == null) {
            this.mainRepository = this.findOrCreateGitRepository(this.gitPatchManagement, true);
        }
        if (this.isFabric && (config = this.mainRepository.getRepository().getConfig()).getString("remote", "origin", "url") == null) {
            File origin = new File(this.karafData, "git/local/fabric");
            config.setString("remote", "origin", "url", origin.getCanonicalPath());
            config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
            config.save();
        }
        if (this.env == EnvType.STANDALONE_CHILD && this.mainRepository.getRepository().getRef("refs/heads/" + this.getMainBranchName()) == null) {
            String startPoint = "patch-management^{commit}";
            this.mainRepository.branchCreate().setName(this.getMainBranchName()).setStartPoint(startPoint).call();
        }
        return this.mainRepository;
    }

    @Override
    public Git findOrCreateGitRepository(File directory, boolean bare) throws IOException {
        try {
            return Git.open(directory);
        }
        catch (RepositoryNotFoundException fallback) {
            try {
                Git git = Git.init().setBare(bare && !this.isFabric).setDirectory(directory).setGitDir(bare && !this.isFabric ? directory : new File(directory, ".git")).call();
                Git fork = this.cloneRepository(git, false);
                RevCommit commit = this.prepareCommit(fork, "[PATCH] initialization").call();
                fork.tag().setName("patch-management").setObjectId(commit).call();
                if (!"master".equals(this.getMainBranchName())) {
                    fork.checkout().setName(this.getMainBranchName()).setStartPoint("master").setCreateBranch(true).call();
                }
                this.push(fork);
                this.closeRepository(fork, true);
                return git;
            }
            catch (GitAPIException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public Git cloneRepository(Git git, boolean fetchAndCheckout) throws GitAPIException, IOException {
        File tmpLocation = new File(this.tmpPatchManagement, TS.format(new Date()));
        Git fork = Git.init().setBare(false).setGitDir(new File(tmpLocation, ".git")).setDirectory(tmpLocation).call();
        StoredConfig config = fork.getRepository().getConfig();
        config.setString("remote", "origin", "url", git.getRepository().getDirectory().getCanonicalPath());
        config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
        config.save();
        if (fetchAndCheckout) {
            fork.fetch().setRemote("origin").setTagOpt(TagOpt.FETCH_TAGS).call();
            fork.checkout().setCreateBranch(true).setName(this.getMainBranchName()).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + this.getMainBranchName()).call();
        }
        return fork;
    }

    @Override
    public void closeRepository(Git git, boolean deleteWorkingCopy) {
        git.getRepository().close();
        if (deleteWorkingCopy) {
            FileUtils.deleteQuietly(git.getRepository().getDirectory());
            FileUtils.deleteQuietly(git.getRepository().getWorkTree());
        }
    }

    @Override
    public CheckoutCommand checkout(Git git) {
        return new NtfsAwareCheckoutCommand(git.getRepository());
    }

    @Override
    public boolean containsCommit(Git git, String branch, String commitMessage) throws IOException, GitAPIException {
        ObjectId head = git.getRepository().resolve(branch);
        Object log = git.log().add(head).call();
        Iterator i$ = log.iterator();
        while (i$.hasNext()) {
            RevCommit rc = (RevCommit)i$.next();
            if (!rc.getFullMessage().equals(commitMessage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTag(Git git, String tagName) throws GitAPIException {
        Iterator i$ = git.tagList().call().iterator();
        while (i$.hasNext()) {
            Ref tag = (Ref)i$.next();
            if (!tag.getName().startsWith("refs/tags/") || !tag.getName().endsWith("/" + tagName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CommitCommand prepareCommit(Git git, String message) {
        return git.commit().setAuthor(this.karafHome.getName(), "fuse@redhat.com").setMessage(message);
    }

    @Override
    public void push(Git git) throws GitAPIException {
        this.push(git, this.getMainBranchName());
    }

    @Override
    public void push(Git git, String branch) throws GitAPIException {
        git.push().setRemote("origin").setRefSpecs(new RefSpec(branch)).setPushTags().setForce(true).call();
        if (this.master && this.mainRepository != null && !branch.startsWith("patch-") && !branch.equals(this.getMainBranchName())) {
            this.mainRepository.push().setRemote("origin").setRefSpecs(new RefSpec(branch)).setPushTags().setForce(true).call();
        }
    }

    @Override
    public Iterable<PushResult> pushPatchBranches() throws GitAPIException {
        Object localBranches = this.mainRepository.branchList().call();
        LinkedList<RefSpec> toPush = new LinkedList<RefSpec>();
        Iterator i$ = localBranches.iterator();
        while (i$.hasNext()) {
            Ref ref = (Ref)i$.next();
            if (!ref.getName().startsWith("refs/heads/patches-")) continue;
            toPush.add(new RefSpec(ref.getName()));
        }
        return this.mainRepository.push().setRefSpecs(toPush).setPushTags().call();
    }

    @Override
    public List<DiffEntry> diff(Git git, RevCommit commit1, RevCommit commit2) throws GitAPIException, IOException {
        return this.diff(git, commit1, commit2, true);
    }

    @Override
    public List<DiffEntry> diff(Git git, RevCommit commit1, RevCommit commit2, boolean showNameAndStatusOnly) throws GitAPIException, IOException {
        ObjectReader reader = git.getRepository().newObjectReader();
        CanonicalTreeParser ctp1 = new CanonicalTreeParser();
        CanonicalTreeParser ctp2 = new CanonicalTreeParser();
        if (commit1.getTree() == null) {
            commit1 = new RevWalk(git.getRepository()).parseCommit(commit1);
        }
        if (commit2.getTree() == null) {
            commit2 = new RevWalk(git.getRepository()).parseCommit(commit2);
        }
        ctp1.reset(reader, commit1.getTree());
        ctp2.reset(reader, commit2.getTree());
        return git.diff().setShowNameAndStatusOnly(showNameAndStatusOnly).setOldTree(ctp1).setNewTree(ctp2).call();
    }

    @Override
    public RevTag findLatestBaseline(Git git) throws GitAPIException, IOException {
        Object tags = git.tagList().call();
        TreeMap<Version, Ref> versions = new TreeMap<Version, Ref>(new Comparator<Version>(){

            @Override
            public int compare(Version o1, Version o2) {
                return o2.compareTo(o1);
            }
        });
        Iterator i$ = tags.iterator();
        while (i$.hasNext()) {
            Ref tag = (Ref)i$.next();
            String name = tag.getName();
            Matcher matcher = BASELINE_TAG_PATTERN.matcher(name = name.substring(name.lastIndexOf(47) + 1));
            if (!matcher.matches()) continue;
            versions.put(Utils.getOsgiVersion(matcher.group(1)), tag);
        }
        if (versions.size() > 0) {
            Ref latest = (Ref)versions.values().iterator().next();
            return new RevWalk(git.getRepository()).parseTag(latest.getObjectId());
        }
        return null;
    }

    @Override
    public RevTag findCurrentBaseline(Git git) throws GitAPIException, IOException {
        return this.findNthPreviousBaseline(git, 0);
    }

    @Override
    public RevTag findNthPreviousBaseline(Git git, int n) throws GitAPIException, IOException {
        Object tags = git.tagList().call();
        RevWalk walk = new RevWalk(git.getRepository());
        HashMap tagMap = new HashMap();
        Iterator i$ = tags.iterator();
        while (i$.hasNext()) {
            Ref tag = (Ref)i$.next();
            Ref peeled = git.getRepository().peel(tag);
            RevTag revTag = walk.parseTag(tag.getObjectId());
            if (!BASELINE_TAG_PATTERN.matcher(revTag.getTagName()).matches()) continue;
            ObjectId key = null;
            key = peeled.getPeeledObjectId() != null ? peeled.getPeeledObjectId() : peeled.getObjectId();
            if (!tagMap.containsKey(key)) {
                tagMap.put(key, new LinkedList());
            }
            ((List)tagMap.get(key)).add(revTag);
        }
        Object log = git.log().add(git.getRepository().resolve(this.getMainBranchName())).call();
        Iterator i$2 = log.iterator();
        while (i$2.hasNext()) {
            RevCommit rc = (RevCommit)i$2.next();
            if (!tagMap.containsKey(rc.getId()) || n-- != 0) continue;
            if (((List)tagMap.get(rc.getId())).size() == 1) {
                return (RevTag)((List)tagMap.get(rc.getId())).get(0);
            }
            RevTag result = null;
            for (RevTag t : (List)tagMap.get(rc.getId())) {
                if (result != null && result.getTagName().length() >= t.getTagName().length()) continue;
                result = t;
            }
            return result;
        }
        return null;
    }

    @Override
    public ManagedPatch getManagedPatch(String id) throws IOException {
        ObjectId commitId = this.mainRepository.getRepository().resolve("refs/heads/patch-" + id);
        if (commitId == null) {
            return null;
        }
        ManagedPatch mp = new ManagedPatch();
        mp.setPatchId(id);
        mp.setCommitId(commitId.getName());
        return mp;
    }

    @Override
    public Map<String, RevTag> findTagsBetween(Git git, RevCommit c1, RevCommit c2) throws GitAPIException, IOException {
        HashMap reverseReferences = new HashMap();
        RevWalk walk = new RevWalk(git.getRepository());
        Iterator i$ = git.tagList().call().iterator();
        while (i$.hasNext()) {
            Ref t = (Ref)i$.next();
            Ref peeled = git.getRepository().peel(t);
            if (peeled == null || peeled.getPeeledObjectId() == null) continue;
            if (!reverseReferences.containsKey(peeled.getPeeledObjectId())) {
                reverseReferences.put(peeled.getPeeledObjectId(), new LinkedList());
            }
            ((List)reverseReferences.get(peeled.getPeeledObjectId())).add(walk.parseTag(t.getObjectId()));
        }
        HashMap<String, RevTag> result = new HashMap<String, RevTag>();
        Object commits = git.log().addRange(c1, c2).call();
        Iterator i$2 = commits.iterator();
        while (i$2.hasNext()) {
            RevCommit commit = (RevCommit)i$2.next();
            if (!reverseReferences.containsKey(commit.getId())) continue;
            for (RevTag tag : (List)reverseReferences.get(commit.getId())) {
                result.put(tag.getTagName(), tag);
            }
        }
        return result;
    }

    @Override
    public String getFileContent(Git fork, String sha1, String fileName) throws IOException {
        ObjectReader objectReader = fork.getRepository().newObjectReader();
        RevCommit commit = new RevWalk(fork.getRepository()).parseCommit(fork.getRepository().resolve(sha1));
        TreeWalk tw = new TreeWalk(fork.getRepository());
        tw.addTree(commit.getTree());
        tw.setRecursive(false);
        tw.setFilter(PathFilter.create(fileName));
        if (tw.next()) {
            ObjectId objectId = tw.getObjectId(0);
            ObjectLoader loader = fork.getRepository().open(objectId);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            loader.copyTo(out);
            return new String(out.toByteArray(), "UTF-8");
        }
        return null;
    }

    @Override
    public String getMainBranchName() {
        return this.mainPatchBranchName;
    }

    @Override
    public String getChildBranchName() {
        return this.childContainerPatchBranchName;
    }

    @Override
    public String getFuseSSHContainerPatchBranchName() {
        return this.fuseSSHContainerPatchBranchName;
    }

    @Override
    public String getFabric8SSHContainerPatchBranchName() {
        return this.fabric8SSHContainerPatchBranchName;
    }

    @Override
    public String getFuseRootContainerPatchBranchName() {
        return this.fuseRootContainerPatchBranchName;
    }

    @Override
    public String getAmqRootContainerPatchBranchName() {
        return this.amqRootContainerPatchBranchName;
    }

    @Override
    public void setMaster(boolean master) {
        this.master = master;
    }

    @Override
    public String getStandaloneChildkarafName() {
        return this.standaloneChildkarafName;
    }
}

