/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.esb.itests.pax.exam.karaf;

import java.io.File;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.apache.karaf.tooling.exam.options.LogLevelOption;
import org.fusesource.tooling.testing.pax.exam.karaf.FuseTestSupport;
import org.junit.Assert;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.MavenUrlReference;

public class EsbTestSupport
extends FuseTestSupport {
    static final String GROUP_ID = "org.jboss.fuse";
    static final String ARTIFACT_ID = "jboss-fuse-minimal";
    private String version = "6.1.0.redhat-SNAPSHOT";

    protected void installQuickstartBundle(String bundle) throws Exception {
        String featureInstallOutput = EsbTestSupport.executeCommand((String)("osgi:install -s mvn:org.jboss.quickstarts.fuse/" + bundle + "/" + this.version));
        System.out.println(featureInstallOutput);
        Assert.assertFalse((boolean)featureInstallOutput.isEmpty());
        String featureListOutput = EsbTestSupport.executeCommand((String)("osgi:list -l | grep " + bundle));
        System.out.println(featureListOutput);
        Assert.assertFalse((boolean)featureListOutput.isEmpty());
    }

    protected void installUninstallCommand(String feature) throws Exception {
        this.installUninstallCommand(feature, false);
    }

    protected void installUninstallCommand(String feature, boolean refresh) throws Exception {
        String installFeatureCmd = "features:install -v ";
        if (!refresh) {
            installFeatureCmd = installFeatureCmd + "-r ";
        }
        String featureInstallOutput = EsbTestSupport.executeCommand((String)(installFeatureCmd + feature));
        System.out.println(featureInstallOutput);
        Assert.assertFalse((boolean)featureInstallOutput.isEmpty());
        String featureListOutput = EsbTestSupport.executeCommand((String)("features:list -i | grep " + feature));
        System.out.println(featureListOutput);
        Assert.assertFalse((boolean)featureListOutput.isEmpty());
        System.out.println(EsbTestSupport.executeCommand((String)("features:uninstall " + feature)));
        featureListOutput = EsbTestSupport.executeCommand((String)("features:list -i | grep " + feature));
        System.out.println(featureListOutput);
        Assert.assertTrue((boolean)featureListOutput.isEmpty());
    }

    protected Option[] esbDistributionConfiguration() {
        return this.esbDistributionConfiguration(null);
    }

    protected Option[] esbDistributionConfiguration(String distroArtifactId) {
        if (distroArtifactId == null) {
            distroArtifactId = ARTIFACT_ID;
        }
        return new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId(GROUP_ID).artifactId(distroArtifactId).versionAsInProject().type("zip")).karafVersion(MavenUtils.getArtifactVersion((String)GROUP_ID, (String)distroArtifactId)).name("JBoss Fuse").unpackDirectory(new File("target/exam")).useDeployFolder(false), KarafDistributionOption.useOwnExamBundlesStartLevel((int)50), KarafDistributionOption.editConfigurationFilePut((String)"etc/config.properties", (String)"karaf.startlevel.bundle", (String)"50"), KarafDistributionOption.editConfigurationFilePut((String)"etc/config.properties", (String)"karaf.startup.message", (String)"Loading Fuse from: ${karaf.home}"), KarafDistributionOption.editConfigurationFilePut((String)"etc/users.properties", (String)"admin", (String)"admin,admin"), EsbTestSupport.mavenBundle((String)"org.fusesource.tooling.testing", (String)"pax-exam-karaf", (String)MavenUtils.getArtifactVersion((String)"org.fusesource.tooling.testing", (String)"pax-exam-karaf")), EsbTestSupport.mavenBundle((String)"org.jboss.fuse.itests", (String)"esb-itests-common", (String)MavenUtils.getArtifactVersion((String)"org.jboss.fuse.itests", (String)"esb-itests-common")), EsbTestSupport.mavenBundle((String)"io.fabric8.itests", (String)"fabric-itests-common", (String)MavenUtils.getArtifactVersion((String)"io.fabric8.itests", (String)"fabric-itests-common")), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.ERROR)};
    }

    protected String getEsbVersion() {
        return this.version;
    }
}

