/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.esb.itests.pax.exam.karaf;

import io.fabric8.tooling.testing.pax.exam.karaf.FabricKarafTestSupport;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.junit.Assert;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;

public class EsbTestSupport
extends FabricKarafTestSupport {
    static final String GROUP_ID = "org.jboss.fuse";
    static final String ARTIFACT_ID = "jboss-fuse-full";
    static final Set<RolePrincipal> ROLES = new HashSet<RolePrincipal>();
    private String version = System.getProperty("project.version");

    public static String executeCommandAsAdmin(String command) {
        return EsbTestSupport.executeCommand(ROLES, (String)command);
    }

    protected void installQuickstartBundle(String bundle) throws Exception {
        String featureInstallOutput = EsbTestSupport.executeCommandAsAdmin("osgi:install -s mvn:org.jboss.quickstarts.fuse/" + bundle + "/" + this.version);
        System.out.println(featureInstallOutput);
        Assert.assertFalse((boolean)featureInstallOutput.isEmpty());
        String featureListOutput = EsbTestSupport.executeCommandAsAdmin("osgi:list -l | grep " + bundle);
        System.out.println(featureListOutput);
        Assert.assertFalse((boolean)featureListOutput.isEmpty());
    }

    protected void installUninstallCommand(String feature) throws Exception {
        this.installUninstallCommand(feature, false);
    }

    protected void installUninstallCommand(String feature, boolean refresh) throws Exception {
        String installFeatureCmd = "features:install -v ";
        if (!refresh) {
            installFeatureCmd = installFeatureCmd + "-r ";
        }
        String featureInstallOutput = EsbTestSupport.executeCommandAsAdmin(installFeatureCmd + feature);
        System.out.println(featureInstallOutput);
        Assert.assertFalse((boolean)featureInstallOutput.isEmpty());
        String featureListOutput = EsbTestSupport.executeCommandAsAdmin("features:list -i | grep " + feature);
        System.out.println(featureListOutput);
        Assert.assertFalse((boolean)featureListOutput.isEmpty());
        System.out.println(EsbTestSupport.executeCommandAsAdmin("features:uninstall " + feature));
        featureListOutput = EsbTestSupport.executeCommandAsAdmin("features:list -i | grep " + feature);
        System.out.println(featureListOutput);
        Assert.assertTrue((boolean)featureListOutput.isEmpty());
    }

    protected Option[] esbDistributionConfiguration() {
        return this.esbDistributionConfiguration(null);
    }

    protected Option[] esbDistributionConfiguration(String distroArtifactId) {
        if (distroArtifactId == null) {
            distroArtifactId = ARTIFACT_ID;
        }
        return new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId(GROUP_ID).artifactId(distroArtifactId).versionAsInProject().type("zip")).karafVersion(MavenUtils.getArtifactVersion((String)GROUP_ID, (String)distroArtifactId)).name("JBoss Fuse").unpackDirectory(new File("target/exam")).useDeployFolder(false), KarafDistributionOption.useOwnExamBundlesStartLevel((int)50), KarafDistributionOption.editConfigurationFilePut((String)"etc/config.properties", (String)"karaf.startlevel.bundle", (String)"50"), KarafDistributionOption.editConfigurationFilePut((String)"etc/config.properties", (String)"karaf.startup.message", (String)"Loading Fuse from: ${karaf.home}"), KarafDistributionOption.editConfigurationFilePut((String)"etc/users.properties", (String)"admin", (String)"admin,admin,manager,viewer,Operator, Maintainer, Deployer, Auditor, Administrator, SuperUser"), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"project.version", (String)MavenUtils.getArtifactVersion((String)GROUP_ID, (String)ARTIFACT_ID)), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"patching.disabled", (String)"true"), EsbTestSupport.mavenBundle((String)"io.fabric8.tooling.testing", (String)"pax-exam-karaf", (String)MavenUtils.getArtifactVersion((String)"io.fabric8.tooling.testing", (String)"pax-exam-karaf")), EsbTestSupport.mavenBundle((String)"org.jboss.fuse.itests", (String)"esb-itests-common", (String)MavenUtils.getArtifactVersion((String)"org.jboss.fuse.itests", (String)"esb-itests-common")), CoreOptions.wrappedBundle((UrlReference)EsbTestSupport.mavenBundle((String)"io.fabric8.itests", (String)"fabric-itests-common", (String)MavenUtils.getArtifactVersion((String)"io.fabric8.itests", (String)"fabric-itests-common"))), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.ERROR)};
    }

    protected String getEsbVersion() {
        return this.version;
    }

    static {
        ROLES.add(new RolePrincipal("Administrator"));
        ROLES.add(new RolePrincipal("SuperUser"));
    }
}

