/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.security.SecureRandom;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsUtils;

abstract class AbstractTlsContext
implements TlsContext {
    private SecureRandom secureRandom;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private Object userObject = null;

    AbstractTlsContext(SecureRandom secureRandom, SecurityParameters securityParameters) {
        this.secureRandom = secureRandom;
        this.securityParameters = securityParameters;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(ProtocolVersion protocolVersion) {
        this.clientVersion = protocolVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(ProtocolVersion protocolVersion) {
        this.serverVersion = protocolVersion;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public byte[] exportKeyingMaterial(String string, byte[] byArray, int n) {
        SecurityParameters securityParameters = this.getSecurityParameters();
        byte[] byArray2 = securityParameters.getClientRandom();
        byte[] byArray3 = securityParameters.getServerRandom();
        int n2 = byArray2.length + byArray3.length;
        if (byArray != null) {
            n2 += 2 + byArray.length;
        }
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        System.arraycopy(byArray2, 0, byArray4, n3, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n3 += byArray2.length, byArray3.length);
        n3 += byArray3.length;
        if (byArray != null) {
            TlsUtils.writeUint16(byArray.length, byArray4, n3);
            System.arraycopy(byArray, 0, byArray4, n3 += 2, byArray.length);
            n3 += byArray.length;
        }
        if (n3 != n2) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, securityParameters.getMasterSecret(), string, byArray4, n);
    }
}

