/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.impl;

import io.fabric8.patch.management.BackupService;
import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.PatchResult;
import io.fabric8.patch.management.Pending;
import io.fabric8.patch.management.Utils;
import io.fabric8.patch.management.impl.Activator;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FileBackupService
implements BackupService {
    private final BundleContext systemContext;

    public FileBackupService(BundleContext systemContext) {
        this.systemContext = systemContext;
    }

    @Override
    public void backupDataFiles(PatchResult result, Pending pending) throws IOException {
        HashMap<String, Bundle> bundlesWithData = new HashMap<String, Bundle>();
        String storageLocation = this.systemContext.getProperty("org.osgi.framework.storage");
        if (storageLocation == null) {
            Activator.log(3, "Can't determine \"org.osgi.framework.storage\" property value");
            return;
        }
        File cacheDir = new File(storageLocation);
        if (!cacheDir.isDirectory()) {
            return;
        }
        for (Bundle b : this.systemContext.getBundles()) {
            File dataDir;
            String sn = Utils.stripSymbolicName(b.getSymbolicName());
            if ("org.apache.karaf.features.core".equals(sn) || !(dataDir = new File(cacheDir, "bundle" + b.getBundleId() + "/data")).isDirectory()) continue;
            String key = String.format("%s$$%s", sn, b.getVersion().toString());
            bundlesWithData.put(key, b);
        }
        Properties properties = new Properties();
        File dataBackupDir = new File(result.getPatchData().getPatchLocation(), result.getPatchData().getId() + ".datafiles");
        String prefix = pending == Pending.ROLLUP_INSTALLATION ? "install" : "rollback";
        for (BundleUpdate update : result.getBundleUpdates()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = update.getSymbolicName();
            Object object = pending == Pending.ROLLUP_INSTALLATION ? update.getPreviousVersion() : (objectArray[1] = update.getNewVersion() == null ? update.getPreviousVersion() : update.getNewVersion());
            String key = String.format("%s$$%s", objectArray);
            if (!bundlesWithData.containsKey(key)) continue;
            File dataFileBackupDir = new File(dataBackupDir, prefix + "/" + key + "/data");
            dataFileBackupDir.mkdirs();
            final Bundle b = (Bundle)bundlesWithData.get(key);
            FileUtils.copyDirectory(b.getDataFile(""), dataFileBackupDir, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || !b.getSymbolicName().equals("org.apache.felix.configadmin") || pathname.getName().endsWith(".config");
                }
            });
            properties.setProperty(key, key);
            properties.setProperty(String.format("%s$$%s", update.getSymbolicName(), update.getPreviousVersion()), key);
            if (update.getNewVersion() == null) continue;
            properties.setProperty(String.format("%s$$%s", update.getSymbolicName(), update.getNewVersion()), key);
        }
        FileOutputStream propsFile = new FileOutputStream(new File(dataBackupDir, "backup-" + prefix + ".properties"));
        properties.store(propsFile, "Data files to restore after \"" + result.getPatchData().getId() + "\" " + (pending == Pending.ROLLUP_INSTALLATION ? "installation" : "rollback"));
        propsFile.close();
    }
}

