/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.commands;

import io.fabric8.patch.Service;
import io.fabric8.patch.commands.PatchActionSupport;
import io.fabric8.patch.management.Patch;
import io.fabric8.patch.management.PatchException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(scope="patch", name="rollback", description="Rollback a patch installation")
public class RollbackAction
extends PatchActionSupport {
    @Argument(name="PATCH", description="name of the patch to rollback", required=true, multiValued=false)
    String patchId;
    @Option(name="--simulation", description="Simulates rollback of the patch")
    boolean simulation = false;

    RollbackAction(Service service) {
        super(service);
    }

    @Override
    protected void doExecute(Service service) throws Exception {
        Patch patch = service.getPatch(this.patchId);
        if (patch == null) {
            throw new PatchException("Patch '" + this.patchId + "' not found");
        }
        if (!patch.isInstalled()) {
            throw new PatchException("Patch '" + this.patchId + "' is not installed");
        }
        if (patch.getPatchData().getMigratorBundle() != null) {
            throw new PatchException("Patch '" + this.patchId + "' does not support rollback");
        }
        service.rollback(patch, this.simulation, false);
    }
}

