/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.commands;

import io.fabric8.patch.Service;
import io.fabric8.patch.commands.PatchActionSupport;
import io.fabric8.patch.management.Patch;
import io.fabric8.patch.management.PatchResult;
import io.fabric8.utils.shell.ShellUtils;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;

@Command(scope="patch", name="install", description="Install a patch")
public class InstallAction
extends PatchActionSupport {
    @Argument(name="PATCH", description="name of the patch to install", required=true, multiValued=false)
    String patchId;
    @Option(name="--simulation", description="Simulates installation of the patch")
    boolean simulation = false;
    @Option(name="--synchronous", description="Synchronous installation (use with caution)")
    boolean synchronous;

    InstallAction(Service service) {
        super(service);
    }

    @Override
    protected void doExecute(Service service) throws Exception {
        Patch patch;
        block3: {
            patch = super.getPatch(this.patchId);
            if (patch.getPatchData().getMigratorBundle() != null) {
                String response;
                System.out.println("This patch cannot be rolled back.  Are you sure you want to install?");
                do {
                    if ((response = ShellUtils.readLine((CommandSession)this.session, (String)"[y/n]: ", (boolean)false)) == null) {
                        return;
                    }
                    if ((response = response.trim().toLowerCase()).equals("y") || response.equals("yes")) break block3;
                } while (!response.equals("n") && !response.equals("no"));
                return;
            }
        }
        PatchResult result = service.install(patch, this.simulation, this.synchronous);
    }
}

