/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BufferedRunningLengthWord;
import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;

public class BufferedIterator
implements IteratingRLW {
    private BufferedRunningLengthWord brlw;
    private long[] buffer;
    private int literalWordStartPosition;
    private EWAHIterator iterator;
    private CloneableIterator<EWAHIterator> masteriterator;

    public BufferedIterator(CloneableIterator<EWAHIterator> iterator) {
        this.masteriterator = iterator;
        if (this.masteriterator.hasNext()) {
            this.iterator = this.masteriterator.next();
            this.brlw = new BufferedRunningLengthWord(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
            this.buffer = this.iterator.buffer();
        }
    }

    @Override
    public void discardFirstWords(long x) {
        while (x > 0L) {
            if (this.brlw.RunningLength > x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0L;
            long toDiscard = (x -= this.brlw.RunningLength) > (long)this.brlw.NumberOfLiteralWords ? (long)this.brlw.NumberOfLiteralWords : x;
            this.literalWordStartPosition = (int)((long)this.literalWordStartPosition + toDiscard);
            this.brlw.NumberOfLiteralWords = (int)((long)this.brlw.NumberOfLiteralWords - toDiscard);
            if ((x -= toDiscard) <= 0L && this.brlw.size() != 0L || this.next()) continue;
            break;
        }
    }

    @Override
    public boolean next() {
        if (!this.iterator.hasNext() && !this.reload()) {
            this.brlw.NumberOfLiteralWords = 0;
            this.brlw.RunningLength = 0L;
            return false;
        }
        this.brlw.reset(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords();
        return true;
    }

    private boolean reload() {
        if (!this.masteriterator.hasNext()) {
            return false;
        }
        this.iterator = this.masteriterator.next();
        this.buffer = this.iterator.buffer();
        return true;
    }

    @Override
    public long getLiteralWordAt(int index) {
        return this.buffer[this.literalWordStartPosition + index];
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    @Override
    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    @Override
    public long getRunningLength() {
        return this.brlw.RunningLength;
    }

    @Override
    public long size() {
        return this.brlw.size();
    }

    @Override
    public BufferedIterator clone() throws CloneNotSupportedException {
        BufferedIterator answer = (BufferedIterator)super.clone();
        answer.brlw = this.brlw.clone();
        answer.buffer = this.buffer;
        answer.iterator = this.iterator.clone();
        answer.literalWordStartPosition = this.literalWordStartPosition;
        answer.masteriterator = this.masteriterator.clone();
        return answer;
    }
}

