/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management;

public class Artifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final String classifier;

    public Artifact(String groupId, String artifactId, String version, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
    }

    public static boolean isSameButVersion(Artifact a1, Artifact a2) {
        return a1.getGroupId().equals(a2.getGroupId()) && a1.getArtifactId().equals(a2.getArtifactId()) && a1.hasClassifier() == a2.hasClassifier() && (!a1.hasClassifier() || a1.getClassifier().equals(a2.getClassifier())) && a1.getType().equals(a2.getType());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean hasClassifier() {
        return this.classifier != null;
    }

    public String getPath() {
        return this.groupId.replace('.', '/') + '/' + this.artifactId + '/' + this.version + '/' + this.artifactId + (this.classifier != null ? "-" + this.classifier : "") + '-' + this.version + '.' + this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(":").append(this.artifactId).append(":").append(this.version);
        if (!"jar".equals(this.type) || this.classifier != null) {
            sb.append(":").append(this.type);
            if (this.classifier != null) {
                sb.append(":").append(this.classifier);
            }
        }
        return sb.toString();
    }
}

