/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.conflicts;

import io.fabric8.patch.management.Artifact;
import io.fabric8.patch.management.Utils;
import io.fabric8.patch.management.conflicts.PropertiesFileResolver;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.properties.Properties;
import org.osgi.framework.Version;

public class KarafFeaturesPropertiesFileResolver
extends PropertiesFileResolver {
    @Override
    protected String specialPropertyMerge(String key, Properties firstProperties, Properties secondProperties, boolean rollback) {
        if ("featuresBoot".equals(key)) {
            String featuresFromPatch = (String)firstProperties.get(key);
            LinkedHashSet<String> featureNamesFromPatch = new LinkedHashSet<String>(Arrays.asList(featuresFromPatch.split("\\s*,\\s*")));
            String currentFeatures = (String)secondProperties.get(key);
            LinkedHashSet<String> currentFeatureNames = new LinkedHashSet<String>(Arrays.asList(currentFeatures.split("\\s*,\\s*")));
            featureNamesFromPatch.addAll(currentFeatureNames);
            StringBuilder sw = new StringBuilder();
            for (String fn : featureNamesFromPatch) {
                sw.append(",").append(fn);
            }
            return sw.toString().length() > 0 ? sw.toString().substring(1) : "";
        }
        if ("featuresRepositories".equals(key)) {
            String uri;
            String repositoriesFromPatch = (String)firstProperties.get(key);
            List<String> uriStringsFromPatch = Arrays.asList(repositoriesFromPatch.split("\\s*,\\s*"));
            Map<String, Artifact> urisFromPatch = this.uris(uriStringsFromPatch);
            String currentRepositories = (String)secondProperties.get(key);
            List<String> currentUriStrings = Arrays.asList(currentRepositories.split("\\s*,\\s*"));
            Map<String, Artifact> currentUris = this.uris(currentUriStrings);
            StringBuilder sw = new StringBuilder();
            if (!rollback) {
                for (String ga : urisFromPatch.keySet()) {
                    Artifact a1 = urisFromPatch.get(ga);
                    Artifact a2 = currentUris.get(ga);
                    if (a2 == null) {
                        a2 = a1;
                    }
                    Version v1 = Utils.getOsgiVersion(a1.getVersion());
                    Version v2 = Utils.getOsgiVersion(a2.getVersion());
                    String uri2 = String.format("mvn:%s/%s/%s/%s/%s", a1.getGroupId(), a1.getArtifactId(), v1.compareTo(v2) < 0 ? v2.toString() : v1.toString(), a1.getType(), a1.getClassifier());
                    sw.append(",").append(uri2);
                }
                for (String ga : currentUris.keySet()) {
                    if (urisFromPatch.containsKey(ga)) continue;
                    Artifact a2 = currentUris.get(ga);
                    String uri3 = String.format("mvn:%s/%s/%s/%s/%s", a2.getGroupId(), a2.getArtifactId(), a2.getVersion(), a2.getType(), a2.getClassifier());
                    sw.append(",").append(uri3);
                }
                return sw.toString().length() > 0 ? sw.toString().substring(1) : "";
            }
            for (String ga : currentUris.keySet()) {
                Artifact a2 = currentUris.get(ga);
                uri = String.format("mvn:%s/%s/%s/%s/%s", a2.getGroupId(), a2.getArtifactId(), a2.getVersion(), a2.getType(), a2.getClassifier());
                sw.append(",").append(uri);
            }
            for (String ga : urisFromPatch.keySet()) {
                if (currentUris.containsKey(ga)) continue;
                Artifact a1 = urisFromPatch.get(ga);
                uri = String.format("mvn:%s/%s/%s/%s/%s", a1.getGroupId(), a1.getArtifactId(), a1.getVersion(), a1.getType(), a1.getClassifier());
                sw.append(",").append(uri);
            }
            return sw.toString().length() > 0 ? sw.toString().substring(1) : "";
        }
        return super.specialPropertyMerge(key, firstProperties, secondProperties, rollback);
    }

    private Map<String, Artifact> uris(List<String> uriStringsFromPatch) {
        LinkedHashMap<String, Artifact> result = new LinkedHashMap<String, Artifact>();
        for (String uri : uriStringsFromPatch) {
            Artifact a = Utils.mvnurlToArtifact(uri, true);
            if (a == null) continue;
            String ga = String.format("%s/%s", a.getGroupId(), a.getArtifactId());
            result.put(ga, a);
        }
        return result;
    }
}

