/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.impl;

import io.fabric8.patch.management.BackupService;
import io.fabric8.patch.management.PatchManagement;
import io.fabric8.patch.management.impl.FileBackupService;
import io.fabric8.patch.management.impl.GitPatchManagementService;
import io.fabric8.patch.management.impl.GitPatchManagementServiceImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final int PATCH_MANAGEMENT_START_LEVEL = 2;
    private FrameworkStartLevel sl;
    private int activatedAt = 0;
    private GitPatchManagementService patchManagementService;
    private final Object serviceAccess = new Object();
    private Version startupVersion;
    private Version deployVersion;
    private StartLevelNotificationFrameworkListener startLevelNotificationFrameworkListener;
    private static Bundle bundle;
    private BundleContext systemContext;
    private ServiceRegistration<PatchManagement> patchManagementRegistration;
    private ServiceRegistration<BackupService> backupServiceRegistration;
    private static volatile ServiceTracker logServiceTracker;

    public void start(BundleContext context) throws Exception {
        bundle = context.getBundle();
        this.systemContext = context.getBundle(0L).getBundleContext();
        logServiceTracker = new ServiceTracker(context, "org.osgi.service.log.LogService", null);
        logServiceTracker.open();
        this.patchManagementService = new GitPatchManagementServiceImpl(context);
        int targetStartLevel = Integer.parseInt(System.getProperty("org.osgi.framework.startlevel.beginning"));
        this.sl = (FrameworkStartLevel)context.getBundle(0L).adapt(FrameworkStartLevel.class);
        this.activatedAt = this.sl.getStartLevel();
        if (!this.patchManagementService.isEnabled()) {
            Activator.log(3, "\nPatch management is disabled");
            return;
        }
        try {
            class E7
            extends Exception {
                public E7(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
                    super(message, cause, enableSuppression, writableStackTrace);
                }
            }
            new E7("test", null, false, false);
        }
        catch (Throwable t) {
            File[] files = new File(System.getProperty("karaf.home"), "lib/endorsed").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains("karaf.exception");
                }
            });
            if (files != null && files.length > 0) {
                Activator.log2(2, "Please remove \"" + files[0].getName() + "\" from lib/endorsed directory and restart. Patching won't succeed with this version of endorsed library.");
            } else {
                Activator.log2(2, "Available java.lang.Exception class is not compatible with JDK7 and later. Patching won't succeed. Please restart.");
            }
            return;
        }
        switch (this.activatedAt) {
            case 2: {
                this.startupVersion = context.getBundle().getVersion();
                this.patchManagementService.cleanupDeployDir();
                break;
            }
            default: {
                this.deployVersion = context.getBundle().getVersion();
            }
        }
        this.patchManagementService.start();
        this.patchManagementRegistration = this.systemContext.registerService(PatchManagement.class, PatchManagement.class.cast(this.patchManagementService), null);
        this.backupServiceRegistration = this.systemContext.registerService(BackupService.class, (Object)new FileBackupService(this.systemContext), null);
        if (this.startupVersion != null) {
            this.patchManagementService.checkPendingPatches();
        }
        if (this.sl.getStartLevel() == targetStartLevel) {
            this.patchManagementService.ensurePatchManagementInitialized();
        } else {
            this.startLevelNotificationFrameworkListener = new StartLevelNotificationFrameworkListener(targetStartLevel);
            this.systemContext.addFrameworkListener((FrameworkListener)this.startLevelNotificationFrameworkListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Object object = this.serviceAccess;
        synchronized (object) {
            this.patchManagementService.stop();
            this.patchManagementService = null;
        }
        if (this.patchManagementRegistration != null) {
            this.patchManagementRegistration.unregister();
            this.patchManagementRegistration = null;
        }
        if (this.backupServiceRegistration != null) {
            this.backupServiceRegistration.unregister();
            this.backupServiceRegistration = null;
        }
        if (logServiceTracker != null) {
            logServiceTracker.close();
            logServiceTracker = null;
        }
    }

    public static void log(int level, String message) {
        Activator.log(level, null, message, null, false);
    }

    public static void log2(int level, String message) {
        Activator.log(level, null, message, null, true);
    }

    public static void log(int level, Bundle bundle, String message, Throwable throwable, boolean twoWay) {
        Object service;
        ServiceTracker tracker = logServiceTracker;
        if (bundle == null) {
            bundle = Activator.bundle;
        }
        if (tracker != null && (service = tracker.getService()) != null) {
            ((LogService)service).log(level, message, throwable);
            if (!twoWay) {
                return;
            }
        }
        PrintStream out = level == 1 ? System.err : System.out;
        StringBuffer buf = new StringBuffer();
        switch (level) {
            case 4: {
                buf.append("DEBUG: ");
                break;
            }
            case 3: {
                buf.append("INFO : ");
                break;
            }
            case 2: {
                buf.append("WARN : ");
                break;
            }
            case 1: {
                buf.append("ERROR: ");
            }
        }
        if (bundle != null) {
            buf.append(bundle.getSymbolicName());
            buf.append(" (");
            buf.append(bundle.getBundleId());
            buf.append("): ");
        }
        buf.append(message);
        out.println(buf);
        if (throwable != null) {
            throwable.printStackTrace(out);
        }
        out.flush();
    }

    static {
        logServiceTracker = null;
    }

    private class StartLevelNotificationFrameworkListener
    implements FrameworkListener {
        private final int targetStartLevel;
        private boolean done = false;

        public StartLevelNotificationFrameworkListener(int targetStartLevel) {
            this.targetStartLevel = targetStartLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void frameworkEvent(FrameworkEvent event) {
            if (event.getType() == 8 && !this.done && Activator.this.sl.getStartLevel() == this.targetStartLevel) {
                this.done = true;
                Object object = Activator.this.serviceAccess;
                synchronized (object) {
                    if (Activator.this.patchManagementService != null) {
                        Activator.this.patchManagementService.ensurePatchManagementInitialized();
                        Activator.this.systemContext.removeFrameworkListener((FrameworkListener)this);
                    }
                }
            }
        }
    }
}

