/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.io;

import io.fabric8.patch.management.Utils;
import io.fabric8.patch.management.io.EOLFixingFileOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class EOLFixingFileUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;

    public static void copyDirectory(File srcDir, File baseDestDir, File destDir, boolean onlyModified) throws IOException {
        File[] srcFiles;
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' exists but is not a directory");
        }
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath()) && (srcFiles = srcDir.listFiles()) != null && srcFiles.length > 0) {
            exclusionList = new ArrayList<String>(srcFiles.length);
            for (File srcFile : srcFiles) {
                File copiedFile = new File(destDir, srcFile.getName());
                exclusionList.add(copiedFile.getCanonicalPath());
            }
        }
        EOLFixingFileUtils.doCopyDirectory(srcDir, baseDestDir, destDir, exclusionList, onlyModified);
    }

    private static void doCopyDirectory(File srcDir, File baseDestDir, File destDir, List<String> exclusionList, boolean onlyModified) throws IOException {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else {
            for (int i = 0; i < 10 && !destDir.mkdirs(); ++i) {
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' directory cannot be created");
            }
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                EOLFixingFileUtils.doCopyDirectory(srcFile, baseDestDir, dstFile, exclusionList, onlyModified);
                continue;
            }
            if (onlyModified && dstFile.exists()) {
                long crc2;
                long crc1 = Utils.checksum(new FileInputStream(srcFile));
                if (crc1 == (crc2 = Utils.checksum(new FileInputStream(dstFile)))) continue;
                EOLFixingFileUtils.doCopyFile(srcFile, baseDestDir, dstFile);
                continue;
            }
            EOLFixingFileUtils.doCopyFile(srcFile, baseDestDir, dstFile);
        }
        destDir.setLastModified(srcDir.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destDir, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        EOLFixingFileOutputStream eolFixingFos = null;
        BufferedOutputStream os = null;
        boolean skip = false;
        try {
            fis = new FileInputStream(srcFile);
            try {
                eolFixingFos = new EOLFixingFileOutputStream(destDir, destFile);
            }
            catch (FileNotFoundException e) {
                String path = Utils.relative(destDir, destFile);
                String[] tab = path.split(Pattern.quote(File.separator));
                if (tab.length >= 2 && "bin".equals(tab[0])) {
                    skip = true;
                }
                throw e;
            }
            if (!skip) {
                os = new BufferedOutputStream(eolFixingFos);
                IOUtils.copyLarge(fis, os);
            }
        }
        finally {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly(fis);
        }
        if (!skip) {
            if (srcFile.length() + eolFixingFos.additionalBytesWritten() != destFile.length()) {
                throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
            }
            destFile.setLastModified(srcFile.lastModified());
        }
    }
}

