/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownTracker {
    private static final transient Logger LOG = LoggerFactory.getLogger(ShutdownTracker.class);
    public static final boolean DISABLED = Boolean.getBoolean("io.fabric8.common.util.ShutdownTracker.DISABLED");
    private AtomicInteger retained = new AtomicInteger(1);
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private Runnable onStopCallback;

    public void retain() {
        if (!this.attemptRetain()) {
            if (!DISABLED) {
                throw new ShutdownException();
            }
            LOG.info("Ignoring: retain() failure, would have caused a ShutdownException");
        }
    }

    public boolean attemptRetain() {
        if (this.retained.getAndIncrement() == 0 || this.stopping.get()) {
            this.retained.getAndDecrement();
            return false;
        }
        return true;
    }

    public void release() {
        if (this.retained.decrementAndGet() == 0) {
            if (!this.stopping.get()) {
                if (!DISABLED) {
                    throw new IllegalStateException("Unbalanced calls to release detected.");
                }
                LOG.info("Ignoring: release() failure, would have caused an IllegalStateException");
            } else if (this.onStopCallback != null) {
                this.onStopCallback.run();
                this.onStopCallback = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T use(Callable<T> callable) throws Exception {
        this.retain();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.release();
        }
    }

    public void shutdown(Runnable onStopCallback) throws ShutdownException {
        if (this.stopping.compareAndSet(false, true)) {
            this.onStopCallback = onStopCallback;
            this.release();
        } else {
            if (!DISABLED) {
                throw new ShutdownException();
            }
            LOG.info("Ignoring: shutdown() failure, would have caused a ShutdownException");
        }
    }

    public void stop() throws ShutdownException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.shutdown(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
    }

    public Object proxy(final Object target) {
        Class<?> targetClass = target.getClass();
        return Proxy.newProxyInstance(targetClass.getClassLoader(), targetClass.getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ShutdownTracker.this.retain();
                try {
                    Object object = method.invoke(target, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                finally {
                    ShutdownTracker.this.release();
                }
            }
        });
    }

    public StandardMBean mbeanProxy(Object target) throws NotCompliantMBeanException {
        Class<?> targetClass = target.getClass();
        String targetClassName = targetClass.getSimpleName();
        for (Class<?> clazz : targetClass.getInterfaces()) {
            if (!clazz.getSimpleName().equals(targetClassName + "MBean") && !clazz.getSimpleName().equals(targetClassName + "MXBean")) continue;
            return new StandardMBean(this.proxy(target), clazz);
        }
        throw new NotCompliantMBeanException();
    }

    public static class ShutdownException
    extends IllegalStateException {
    }
}

