/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.web;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletContextListener;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerListener;
import org.ops4j.pax.cdi.web.impl.CdiServletContainerInitializer;
import org.ops4j.pax.cdi.web.impl.CdiWebAppDependencyHolder;
import org.ops4j.pax.web.service.WebAppDependencyHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CdiWebAppDependencyManager
implements CdiContainerListener {
    private static Logger log = LoggerFactory.getLogger(CdiWebAppDependencyManager.class);
    private Map<Bundle, ServiceRegistration<WebAppDependencyHolder>> registrations = new HashMap<Bundle, ServiceRegistration<WebAppDependencyHolder>>();

    protected abstract ServletContextListener getServletContextListener();

    private void register(Bundle bundle, CdiContainer cdiContainer) {
        CdiServletContainerInitializer initializer = new CdiServletContainerInitializer(cdiContainer, this.getServletContextListener());
        CdiWebAppDependencyHolder dependencyHolder = new CdiWebAppDependencyHolder(bundle.getBundleContext(), initializer);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("bundle.id", Long.toString(bundle.getBundleId()));
        ServiceRegistration registration = bundle.getBundleContext().registerService(WebAppDependencyHolder.class, (Object)dependencyHolder, props);
        this.registrations.put(bundle, (ServiceRegistration<WebAppDependencyHolder>)registration);
        log.info("registered WebAppDependencyHolder for bundle [{}]", (Object)cdiContainer.getBundle());
    }

    private void unregister(Bundle bundle) {
        ServiceRegistration<WebAppDependencyHolder> registration = this.registrations.remove(bundle);
        if (registration != null) {
            try {
                registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private boolean isWebBundle(Bundle bundle) {
        return bundle.getHeaders().get("Web-ContextPath") != null;
    }

    public synchronized void postCreate(CdiContainer container) {
        Bundle bundle = container.getBundle();
        if (this.isWebBundle(bundle)) {
            this.register(bundle, container);
        }
    }

    public synchronized void preDestroy(CdiContainer container) {
        this.unregister(container.getBundle());
    }

    public synchronized void unregisterAll() {
        while (!this.registrations.isEmpty()) {
            this.unregister(this.registrations.keySet().iterator().next());
        }
    }
}

