/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;

@Command(scope="jdbc", name="info", description="Display details about a JDBC datasource")
public class InfoCommand
extends JdbcCommandSupport {
    private static final String PROPERTIES_STRING_FORMAT = "%20s %20s";
    @Argument(index=0, name="datasource", description="The JDBC datasource name", required=true, multiValued=false)
    String datasource;

    public Object doExecute() throws Exception {
        System.out.println(String.format(PROPERTIES_STRING_FORMAT, "Property", "Value"));
        Map info = this.getJdbcService().info(this.datasource);
        for (String property : info.keySet()) {
            System.out.println(String.format(PROPERTIES_STRING_FORMAT, property, info.get(property)));
        }
        return null;
    }
}

