/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.pool.PooledConnection;
import org.apache.karaf.jms.JmsMessage;
import org.apache.karaf.jms.JmsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsServiceImpl
implements JmsService {
    private BundleContext bundleContext;

    @Override
    public void create(String name, String type, String url) throws Exception {
        if (!type.equalsIgnoreCase("activemq") && !type.equalsIgnoreCase("webspheremq")) {
            throw new IllegalArgumentException("JMS connection factory type not known");
        }
        File karafBase = new File(System.getProperty("karaf.base"));
        File deployFolder = new File(karafBase, "deploy");
        File outFile = new File(deployFolder, "connectionfactory-" + name + ".xml");
        if (type.equalsIgnoreCase("activemq")) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("${name}", name);
            properties.put("${url}", url);
            this.copyDataSourceFile(outFile, "connectionfactory-activemq.xml", properties);
        } else {
            String[] splitted = url.split("/");
            if (splitted.length != 4) {
                throw new IllegalStateException("WebsphereMQ URI should be in the following format: host/port/queuemanager/channel");
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("${name}", name);
            properties.put("${host}", splitted[0]);
            properties.put("${port}", splitted[1]);
            properties.put("${queuemanager}", splitted[2]);
            properties.put("${channel}", splitted[3]);
            this.copyDataSourceFile(outFile, "connectionfactory-webspheremq.xml", properties);
        }
    }

    @Override
    public void delete(String name) throws Exception {
        File karafBase = new File(System.getProperty("karaf.base"));
        File deployFolder = new File(karafBase, "deploy");
        File connectionFactoryFile = new File(deployFolder, "connectionfactory-" + name + ".xml");
        if (!connectionFactoryFile.exists()) {
            throw new IllegalStateException("The JMS connection factory file " + connectionFactoryFile.getPath() + " doesn't exist");
        }
        connectionFactoryFile.delete();
    }

    @Override
    public List<String> connectionFactories() throws Exception {
        ArrayList<String> connectionFactories = new ArrayList<String>();
        ServiceReference[] references = this.bundleContext.getServiceReferences(ConnectionFactory.class.getName(), null);
        if (references != null) {
            for (ServiceReference reference : references) {
                if (reference.getProperty("osgi.jndi.service.name") != null) {
                    connectionFactories.add((String)reference.getProperty("osgi.jndi.service.name"));
                    continue;
                }
                if (reference.getProperty("name") != null) {
                    connectionFactories.add((String)reference.getProperty("name"));
                    continue;
                }
                connectionFactories.add(reference.getProperty("service.id").toString());
            }
        }
        return connectionFactories;
    }

    @Override
    public List<String> connectionFactoryFileNames() throws Exception {
        File karafBase = new File(System.getProperty("karaf.base"));
        File deployFolder = new File(karafBase, "deploy");
        String[] connectionFactoryFileNames = deployFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("connectionfactory-") && name.endsWith(".xml");
            }
        });
        return Arrays.asList(connectionFactoryFileNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> info(String connectionFactory, String username, String password) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        ServiceReference reference = this.lookupConnectionFactory(connectionFactory);
        Connection connection = null;
        try {
            ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(reference);
            connection = cf.createConnection(username, password);
            connection.start();
            ConnectionMetaData metaData = connection.getMetaData();
            map.put("product", metaData.getJMSProviderName());
            map.put("version", metaData.getProviderVersion());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(String connectionFactory, String destination, String username, String password) throws Exception {
        ServiceReference reference = this.lookupConnectionFactory(connectionFactory);
        Connection connection = null;
        Session session = null;
        try {
            ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(reference);
            connection = cf.createConnection(username, password);
            connection.start();
            session = connection.createSession(false, 1);
            QueueBrowser browser = session.createBrowser(session.createQueue(destination));
            Enumeration enumeration = browser.getEnumeration();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++count;
            }
            browser.close();
            int n = count;
            return n;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> queues(String connectionFactory, String username, String password) throws Exception {
        ArrayList<String> queues = new ArrayList<String>();
        ServiceReference reference = this.lookupConnectionFactory(connectionFactory);
        Connection connection = null;
        try {
            ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(reference);
            connection = cf.createConnection(username, password);
            connection.start();
            if (connection instanceof PooledConnection) {
                connection = ((PooledConnection)connection).getConnection();
            }
            if (connection instanceof ActiveMQConnection) {
                DestinationSource destinationSource = ((ActiveMQConnection)connection).getDestinationSource();
                Set activeMQQueues = destinationSource.getQueues();
                for (ActiveMQQueue activeMQQueue : activeMQQueues) {
                    queues.add(activeMQQueue.getQueueName());
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> topics(String connectionFactory, String username, String password) throws Exception {
        ArrayList<String> topics = new ArrayList<String>();
        ServiceReference reference = this.lookupConnectionFactory(connectionFactory);
        Connection connection = null;
        try {
            ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(reference);
            connection = cf.createConnection(username, password);
            connection.start();
            if (connection instanceof PooledConnection) {
                connection = ((PooledConnection)connection).getConnection();
            }
            if (connection instanceof ActiveMQConnection) {
                DestinationSource destinationSource = ((ActiveMQConnection)connection).getDestinationSource();
                Set activeMQTopics = destinationSource.getTopics();
                for (ActiveMQTopic activeMQTopic : activeMQTopics) {
                    topics.add(activeMQTopic.getTopicName());
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
        return topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JmsMessage> browse(String connectionFactory, String queue, String filter, String username, String password) throws Exception {
        ArrayList<JmsMessage> messages = new ArrayList<JmsMessage>();
        ServiceReference reference = this.lookupConnectionFactory(connectionFactory);
        Connection connection = null;
        Session session = null;
        try {
            ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(reference);
            connection = cf.createConnection(username, password);
            connection.start();
            session = connection.createSession(false, 1);
            QueueBrowser browser = session.createBrowser(session.createQueue(queue), filter);
            Enumeration enumeration = browser.getEnumeration();
            while (enumeration.hasMoreElements()) {
                Message message = (Message)enumeration.nextElement();
                messages.add(new JmsMessage(message));
            }
            browser.close();
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String connectionFactory, String queue, String body, String replyTo, String username, String password) throws Exception {
        ServiceReference reference = this.lookupConnectionFactory(connectionFactory);
        Connection connection = null;
        Session session = null;
        try {
            ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(reference);
            connection = cf.createConnection(username, password);
            connection.start();
            session = connection.createSession(false, 1);
            TextMessage message = session.createTextMessage(body);
            if (replyTo != null) {
                message.setJMSReplyTo((Destination)session.createQueue(replyTo));
            }
            MessageProducer producer = session.createProducer((Destination)session.createQueue(queue));
            producer.send((Message)message);
            producer.close();
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int consume(String connectionFactory, String queue, String selector, String username, String password) throws Exception {
        int count = 0;
        ServiceReference reference = this.lookupConnectionFactory(connectionFactory);
        Connection connection = null;
        Session session = null;
        try {
            Message message;
            ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(reference);
            connection = cf.createConnection(username, password);
            connection.start();
            session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queue), selector);
            do {
                if ((message = consumer.receive(5000L)) == null) continue;
                ++count;
            } while (message != null);
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int move(String connectionFactory, String sourceQueue, String targetQueue, String selector, String username, String password) throws Exception {
        int count = 0;
        ServiceReference reference = this.lookupConnectionFactory(connectionFactory);
        Connection connection = null;
        Session session = null;
        try {
            Message message;
            ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(reference);
            connection = cf.createConnection(username, password);
            connection.start();
            session = connection.createSession(true, 0);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(sourceQueue), selector);
            do {
                if ((message = consumer.receive(5000L)) == null) continue;
                MessageProducer producer = session.createProducer((Destination)session.createQueue(targetQueue));
                producer.send(message);
                ++count;
            } while (message != null);
            session.commit();
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
        return count;
    }

    private ServiceReference lookupConnectionFactory(String name) throws Exception {
        ServiceReference[] references = this.bundleContext.getServiceReferences(ConnectionFactory.class.getName(), "(|(osgi.jndi.service.name=" + name + ")(name=" + name + ")(service.id=" + name + "))");
        if (references == null || references.length == 0) {
            throw new IllegalArgumentException("No JMS connection factory found for " + name);
        }
        if (references.length > 1) {
            throw new IllegalArgumentException("Multiple JMS connection factories found for " + name);
        }
        return references[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDataSourceFile(File outFile, String resource, HashMap<String, String> properties) throws Exception {
        block9: {
            if (!outFile.exists()) {
                InputStream is = JmsServiceImpl.class.getResourceAsStream(resource);
                if (is == null) {
                    throw new IllegalArgumentException("Resource " + resource + " doesn't exist");
                }
                try {
                    PrintStream out = new PrintStream(new FileOutputStream(outFile));
                    try {
                        Scanner scanner = new Scanner(is);
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            line = this.filter(line, properties);
                            out.println(line);
                        }
                        break block9;
                    }
                    finally {
                        this.safeClose(out);
                    }
                }
                finally {
                    this.safeClose(is);
                }
            }
            throw new IllegalArgumentException("File " + outFile.getPath() + " already exists. Remove it if you wish to recreate it.");
        }
    }

    private void safeClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String filter(String line, HashMap<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = line.indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = line.substring(0, p1);
            String l2 = line.substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

