/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.command;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jms.JmsMessage;
import org.apache.karaf.jms.command.JmsCommandSupport;

@Command(scope="jms", name="browse", description="Browse a JMS queue")
public class BrowseCommand
extends JmsCommandSupport {
    @Argument(index=0, name="connectionFactory", description="The JMS connection factory name", required=true, multiValued=false)
    String connectionFactory;
    @Argument(index=1, name="queue", description="The JMS queue to browse", required=true, multiValued=false)
    String queue;
    @Option(name="-s", aliases={"--selector"}, description="The selector to select the messages to browse", required=false, multiValued=false)
    String selector;
    @Option(name="-u", aliases={"--username"}, description="Username to connect to the JMS broker", required=false, multiValued=false)
    String username = "karaf";
    @Option(name="-p", aliases={"--password"}, description="Password to connect to the JMS broker", required=false, multiValued=false)
    String password = "karaf";
    private static final String JMS_QUEUE_FORMAT = "%15s %40% %5s %10s %10s %10s %10s %10s %10s %10s %10s %10s";

    public Object doExecute() throws Exception {
        System.out.println(String.format(JMS_QUEUE_FORMAT, "ID", "Content", "Charset", "Type", "Correlation", "Delivery", "Destination", "Expiration", "Priority", "Redelivered", "ReplyTo", "Timestamp"));
        List messages = this.getJmsService().browse(this.connectionFactory, this.queue, this.selector, this.username, this.password);
        for (JmsMessage message : messages) {
            System.out.println(String.format(JMS_QUEUE_FORMAT, message.getMessageId(), message.getContent(), message.getCharset(), message.getType(), message.getCorrelationID(), message.getDeliveryMode(), message.getDestination(), message.getExpiration(), message.getPriority(), message.isRedelivered(), message.getReplyTo(), message.getTimestamp()));
        }
        return null;
    }
}

