/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.command;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jms.command.JmsCommandSupport;

@Command(scope="jms", name="consume", description="Consume messages from a JMS queue.")
public class ConsumeCommand
extends JmsCommandSupport {
    @Argument(index=0, name="connectionFactory", description="The JMS connection factory name", required=true, multiValued=false)
    String connectionFactory;
    @Argument(index=1, name="queue", description="The JMS queue where to consume messages", required=true, multiValued=false)
    String queue;
    @Option(name="-s", aliases={"--selector"}, description="The selector to use to select the messages to consume", required=false, multiValued=false)
    String selector;
    @Option(name="-u", aliases={"--username"}, description="Username to connect to the JMS broker", required=false, multiValued=false)
    String username = "karaf";
    @Option(name="-p", aliases={"--password"}, description="Password to connect to the JMS broker", required=false, multiValued=false)
    String password = "karaf";

    public Object doExecute() throws Exception {
        System.out.println(this.getJmsService().consume(this.connectionFactory, this.queue, this.selector, this.username, this.password) + " message(s) consumed");
        return null;
    }
}

