/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.command;

import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jms.command.JmsCommandSupport;

@Command(scope="jms", name="info", description="Provides details about a JMS connection factory.")
public class InfoCommand
extends JmsCommandSupport {
    @Argument(index=0, name="connectionFactory", description="The JMS connection factory name", required=true, multiValued=false)
    String connectionFactory;
    @Option(name="-u", aliases={"--username"}, description="Username to connect to the JMS broker", required=false, multiValued=false)
    String username = "karaf";
    @Option(name="-p", aliases={"--password"}, description="Password to connect to the JMS broker", required=false, multiValued=false)
    String password = "karaf";
    private static final String PROPERTIES_FORMAT = "%20s %20s";

    public Object doExecute() throws Exception {
        System.out.println(String.format(PROPERTIES_FORMAT, "Property", "Value"));
        Map info = this.getJmsService().info(this.connectionFactory, this.username, this.password);
        for (String key : info.keySet()) {
            System.out.println(String.format(PROPERTIES_FORMAT, key, info.get(key)));
        }
        return null;
    }
}

