/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.command;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jms.command.JmsCommandSupport;

@Command(scope="jms", name="move", description="Move messages from one JMS queue to another one.")
public class MoveCommand
extends JmsCommandSupport {
    @Argument(index=0, name="connectionFactory", description="The JMS connection factory name", required=true, multiValued=false)
    String connectionFactory;
    @Argument(index=1, name="source", description="The source JMS queue", required=true, multiValued=false)
    String source;
    @Argument(index=2, name="destination", description="The destination JMS queue", required=true, multiValued=false)
    String destination;
    @Option(name="-s", aliases={"--selector"}, description="Selector to move only some messages", required=false, multiValued=false)
    String selector;
    @Option(name="-u", aliases={"--username"}, description="Username to connect to the JMS broker", required=false, multiValued=false)
    String username = "karaf";
    @Option(name="-p", aliases={"--password"}, description="Password to connect to the JMS broker", required=false, multiValued=false)
    String password = "karaf";

    public Object doExecute() throws Exception {
        System.out.println(this.getJmsService().move(this.connectionFactory, this.source, this.destination, this.selector, this.username, this.password) + " message(s) moved");
        return null;
    }
}

