/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.command;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jms.command.JmsCommandSupport;

@Command(scope="jms", name="queues", description="List the JMS queues.")
public class QueuesCommand
extends JmsCommandSupport {
    @Argument(index=0, name="connectionFactory", description="The JMS connection factory name", required=true, multiValued=false)
    String connectionFactory;
    @Option(name="-u", aliases={"--username"}, description="Username to connect to the JMS broker", required=false, multiValued=false)
    String username = "karaf";
    @Option(name="-p", aliases={"--password"}, description="Password to connect to the JMS broker", required=false, multiValued=false)
    String password = "karaf";

    public Object doExecute() throws Exception {
        System.out.println("JMS Queues");
        for (String queue : this.getJmsService().queues(this.connectionFactory, this.username, this.password)) {
            System.out.println(queue);
        }
        return null;
    }
}

