/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.LocalResourceImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class LazyLocalResourceImpl
implements Resource {
    private final Bundle m_bundle;
    private final Logger m_logger;
    private volatile Resource m_resource = null;

    LazyLocalResourceImpl(Bundle bundle, Logger logger) {
        this.m_bundle = bundle;
        this.m_logger = logger;
    }

    public boolean isLocal() {
        return true;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public String toString() {
        return this.m_bundle.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resource getResource() {
        if (this.m_resource == null) {
            LazyLocalResourceImpl lazyLocalResourceImpl = this;
            synchronized (lazyLocalResourceImpl) {
                try {
                    this.m_resource = new LocalResourceImpl(this.m_bundle);
                }
                catch (InvalidSyntaxException ex) {
                    this.m_logger.log(2, ex.getMessage(), ex);
                    this.m_resource = new ResourceImpl();
                }
            }
        }
        return this.m_resource;
    }

    public Map getProperties() {
        return this.getResource().getProperties();
    }

    public String getId() {
        return this.getResource().getId();
    }

    public String getSymbolicName() {
        return this.getResource().getSymbolicName();
    }

    public Version getVersion() {
        return this.getResource().getVersion();
    }

    public String getPresentationName() {
        return this.getResource().getPresentationName();
    }

    public String getURI() {
        return this.getResource().getURI();
    }

    public Long getSize() {
        return this.getResource().getSize();
    }

    public String[] getCategories() {
        return this.getResource().getCategories();
    }

    public Capability[] getCapabilities() {
        return this.getResource().getCapabilities();
    }

    public Requirement[] getRequirements() {
        return this.getResource().getRequirements();
    }
}

