/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.CipherInputStream;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CipherPair;
import org.apache.camel.util.IOHelper;

public final class FileInputStreamCache
extends InputStream
implements StreamCache {
    private InputStream stream;
    private final File file;
    private final CipherPair ciphers;
    private final long length;
    private final FileInputStreamCloser closer;

    public FileInputStreamCache(File file) throws FileNotFoundException {
        this(file, null, new FileInputStreamCloser());
    }

    FileInputStreamCache(File file, CipherPair ciphers, FileInputStreamCloser closer) throws FileNotFoundException {
        this.file = file;
        this.stream = null;
        this.ciphers = ciphers;
        this.length = file.length();
        this.closer = closer;
        this.closer.add(this);
    }

    @Override
    public void close() {
        if (this.stream != null) {
            IOHelper.close((Closeable)this.stream);
        }
    }

    @Override
    public void reset() {
        this.close();
        this.stream = null;
        if (!this.file.exists()) {
            throw new RuntimeCamelException("Cannot reset stream from file " + this.file);
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.stream == null && this.ciphers == null) {
            long i;
            FileInputStream s = new FileInputStream(this.file);
            long len = this.file.length();
            WritableByteChannel out = os instanceof WritableByteChannel ? (WritableByteChannel)((Object)os) : Channels.newChannel(os);
            FileChannel fc = s.getChannel();
            for (long pos = 0L; pos < len; pos += i) {
                i = fc.transferTo(pos, len - pos, out);
            }
            s.close();
            fc.close();
        } else {
            IOHelper.copy(this.getInputStream(), os);
        }
    }

    @Override
    public StreamCache copy() throws IOException {
        FileInputStreamCache copy = new FileInputStreamCache(this.file, this.ciphers, this.closer);
        return copy;
    }

    @Override
    public boolean inMemory() {
        return false;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public int available() throws IOException {
        return this.getInputStream().available();
    }

    @Override
    public int read() throws IOException {
        return this.getInputStream().read();
    }

    protected InputStream getInputStream() throws IOException {
        if (this.stream == null) {
            this.stream = this.createInputStream(this.file);
        }
        return this.stream;
    }

    private InputStream createInputStream(File file) throws IOException {
        FilterInputStream in = new BufferedInputStream(new FileInputStream(file));
        if (this.ciphers != null) {
            in = new CipherInputStream(in, this.ciphers.getDecryptor()){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        super.close();
                        this.closed = true;
                    }
                }
            };
        }
        return in;
    }

    static class FileInputStreamCloser {
        private List<FileInputStreamCache> fileInputStreamCaches;

        FileInputStreamCloser() {
        }

        synchronized void add(FileInputStreamCache fileInputStreamCache) {
            if (this.fileInputStreamCaches == null) {
                this.fileInputStreamCaches = new ArrayList<FileInputStreamCache>(3);
            }
            this.fileInputStreamCaches.add(fileInputStreamCache);
        }

        void close() {
            if (this.fileInputStreamCaches != null) {
                for (FileInputStreamCache fileInputStreamCache : this.fileInputStreamCaches) {
                    fileInputStreamCache.close();
                }
                this.fileInputStreamCaches.clear();
            }
        }
    }
}

