/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.web.weld.impl;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.ops4j.pax.cdi.spi.Injector;

public class JettyDecorator
implements ServletContextHandler.Decorator {
    public static final String INJECTOR_KEY = "org.ops4j.pax.cdi.injector";
    private ServletContext servletContext;
    private Injector injector;

    protected JettyDecorator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static void process(ServletContext context) {
        ContextHandler.Context cc;
        ContextHandler handler;
        if (context instanceof ContextHandler.Context && (handler = (cc = (ContextHandler.Context)context).getContextHandler()) instanceof ServletContextHandler) {
            ServletContextHandler sch = (ServletContextHandler)handler;
            sch.addDecorator((ServletContextHandler.Decorator)new JettyDecorator(context));
        }
    }

    protected Injector getInjector() {
        if (this.injector == null) {
            this.injector = (Injector)this.servletContext.getAttribute(INJECTOR_KEY);
            if (this.injector == null) {
                throw new IllegalArgumentException("no injector found in servlet context attributes");
            }
        }
        return this.injector;
    }

    public <T extends Filter> T decorateFilterInstance(T filter) {
        this.getInjector().inject(filter);
        return filter;
    }

    public <T extends Servlet> T decorateServletInstance(T servlet) {
        this.getInjector().inject(servlet);
        return servlet;
    }

    public <T extends EventListener> T decorateListenerInstance(T listener) {
        this.getInjector().inject(listener);
        return listener;
    }

    public void decorateFilterHolder(FilterHolder filter) {
    }

    public void decorateServletHolder(ServletHolder servlet) {
    }

    public void destroyServletInstance(Servlet servlet) {
        this.getInjector().destroy((Object)servlet);
    }

    public void destroyFilterInstance(Filter filter) {
        this.getInjector().destroy((Object)filter);
    }

    public void destroyListenerInstance(EventListener listener) {
        this.getInjector().destroy((Object)listener);
    }
}

