/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.quickstarts.fuse.rest.secure;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.quickstarts.fuse.rest.secure.Product;

@XmlRootElement(name="Order")
public class Order {
    private long id;
    private String description;
    private Map<Long, Product> products = new HashMap<Long, Product>();

    public Order() {
        this.init();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/xml"})
    public Order getThisOrder() {
        return this;
    }

    @GET
    @Path(value="products/{productId}/")
    @Produces(value={"application/xml"})
    public Product getProduct(@PathParam(value="productId") int productId) {
        System.out.println("----invoking getProduct with id: " + productId);
        Product p = this.products.get(new Long(productId));
        return p;
    }

    final void init() {
        Product p = new Product();
        p.setId(323L);
        p.setDescription("product 323");
        this.products.put(p.getId(), p);
    }
}

