/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.WeakIdentityHashMap;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.ClassValue;
import org.jruby.util.collections.ClassValueCalculator;
import org.jruby.util.collections.MapBasedClassValue;

public class JavaSupport {
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private final Ruby runtime;
    private final ObjectProxyCache<IRubyObject, RubyClass> objectProxyCache = new ObjectProxyCache<IRubyObject, RubyClass>(ObjectProxyCache.ReferenceType.WEAK){

        @Override
        public IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
            return Java.allocateProxy(javaObject, clazz);
        }
    };
    private final ClassValue<JavaClass> javaClassCache;
    private final ClassValue<RubyModule> proxyClassCache;
    private static final Constructor<? extends ClassValue> CLASS_VALUE_CONSTRUCTOR;
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyModule javaArrayUtilitiesModule;
    private RubyClass javaObjectClass;
    private JavaClass objectJavaClass;
    private RubyClass javaClassClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyClass arrayJavaProxyCreatorClass;
    private RubyClass javaFieldClass;
    private RubyClass javaMethodClass;
    private RubyClass javaConstructorClass;
    private RubyModule javaInterfaceTemplate;
    private RubyModule packageModuleTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;
    private RubyClass mapJavaProxy;
    private final Map<String, JavaClass> nameClassMap = new HashMap<String, JavaClass>();
    private final Map<Object, Object[]> javaObjectVariables = new WeakIdentityHashMap();
    private Map<Set<?>, JavaProxyClass> javaProxyClassCache = Collections.synchronizedMap(new HashMap());

    public static Class getPrimitiveClass(String primitiveType) {
        return PRIMITIVE_CLASSES.get(primitiveType);
    }

    public JavaSupport(Ruby ruby2) {
        this.runtime = ruby2;
        try {
            this.javaClassCache = CLASS_VALUE_CONSTRUCTOR.newInstance(new ClassValueCalculator<JavaClass>(){

                @Override
                public JavaClass computeValue(Class<?> cls) {
                    return new JavaClass(JavaSupport.this.runtime, cls);
                }
            });
            this.proxyClassCache = CLASS_VALUE_CONSTRUCTOR.newInstance(new ClassValueCalculator<RubyModule>(){

                @Override
                public RubyModule computeValue(Class<?> cls) {
                    return Java.createProxyClassForClass(JavaSupport.this.runtime, cls);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Class loadJavaClass(String className) throws ClassNotFoundException {
        Class primitiveClass = PRIMITIVE_CLASSES.get(className);
        if (primitiveClass == null) {
            if (!Ruby.isSecurityRestricted()) {
                return Class.forName(className, true, this.runtime.getJRubyClassLoader());
            }
            return Class.forName(className);
        }
        return primitiveClass;
    }

    public Class loadJavaClassVerbose(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className, cnfExcptn);
        }
        catch (ExceptionInInitializerError eiie) {
            throw this.runtime.newNameError("cannot initialize Java class " + className, className, eiie);
        }
        catch (LinkageError le) {
            throw this.runtime.newNameError("cannot link Java class " + className + ", probable missing dependency: " + le.getLocalizedMessage(), className, le);
        }
        catch (SecurityException se) {
            if (this.runtime.isVerbose()) {
                se.printStackTrace(this.runtime.getErrorStream());
            }
            throw this.runtime.newSecurityError(se.getLocalizedMessage());
        }
    }

    public Class loadJavaClassQuiet(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className, cnfExcptn, false);
        }
        catch (ExceptionInInitializerError eiie) {
            throw this.runtime.newNameError("cannot initialize Java class " + className, className, eiie, false);
        }
        catch (LinkageError le) {
            throw this.runtime.newNameError("cannot link Java class " + className, className, le, false);
        }
        catch (SecurityException se) {
            throw this.runtime.newSecurityError(se.getLocalizedMessage());
        }
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    public RubyModule getProxyClassFromCache(Class clazz) {
        return this.proxyClassCache.get(clazz);
    }

    public void handleNativeException(Throwable exception2, Member target) {
        if (exception2 instanceof RaiseException) {
            throw (RaiseException)exception2;
        }
        if (exception2 instanceof Unrescuable) {
            if (exception2 instanceof Error) {
                throw (Error)exception2;
            }
            if (exception2 instanceof RuntimeException) {
                throw (RuntimeException)exception2;
            }
        }
        throw this.createRaiseException(exception2, target);
    }

    private RaiseException createRaiseException(Throwable exception2, Member target) {
        return RaiseException.createNativeRaiseException(this.runtime, exception2, target);
    }

    public ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache() {
        return this.objectProxyCache;
    }

    public Map<String, JavaClass> getNameClassMap() {
        return this.nameClassMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaObjectVariable(Object o, int i2, Object v) {
        Map<Object, Object[]> map = this.javaObjectVariables;
        synchronized (map) {
            Object[] vars = this.javaObjectVariables.get(o);
            if (vars == null) {
                vars = new Object[i2 + 1];
                this.javaObjectVariables.put(o, vars);
            } else if (vars.length <= i2) {
                Object[] newVars = new Object[i2 + 1];
                System.arraycopy(vars, 0, newVars, 0, vars.length);
                this.javaObjectVariables.put(o, newVars);
                vars = newVars;
            }
            vars[i2] = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getJavaObjectVariable(Object o, int i2) {
        if (i2 == -1) {
            return null;
        }
        Map<Object, Object[]> map = this.javaObjectVariables;
        synchronized (map) {
            Object[] vars = this.javaObjectVariables.get(o);
            if (vars == null || vars.length <= i2) {
                return null;
            }
            return vars[i2];
        }
    }

    public RubyModule getJavaModule() {
        RubyModule module = this.javaModule;
        if (module != null) {
            return module;
        }
        this.javaModule = this.runtime.getModule("Java");
        return this.javaModule;
    }

    public RubyModule getJavaUtilitiesModule() {
        RubyModule module = this.javaUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaUtilitiesModule = this.runtime.getModule("JavaUtilities");
        return this.javaUtilitiesModule;
    }

    public RubyModule getJavaArrayUtilitiesModule() {
        RubyModule module = this.javaArrayUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaArrayUtilitiesModule = this.runtime.getModule("JavaArrayUtilities");
        return this.javaArrayUtilitiesModule;
    }

    public RubyClass getJavaObjectClass() {
        RubyClass clazz = this.javaObjectClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaObjectClass = this.getJavaModule().getClass("JavaObject");
        return this.javaObjectClass;
    }

    public JavaClass getObjectJavaClass() {
        return this.objectJavaClass;
    }

    public void setObjectJavaClass(JavaClass objectJavaClass) {
        this.objectJavaClass = objectJavaClass;
    }

    public RubyClass getJavaArrayClass() {
        RubyClass clazz = this.javaArrayClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaArrayClass = this.getJavaModule().getClass("JavaArray");
        return this.javaArrayClass;
    }

    public RubyClass getJavaClassClass() {
        RubyClass clazz = this.javaClassClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaClassClass = this.getJavaModule().getClass("JavaClass");
        return this.javaClassClass;
    }

    public RubyModule getJavaInterfaceTemplate() {
        RubyModule module = this.javaInterfaceTemplate;
        if (module != null) {
            return module;
        }
        this.javaInterfaceTemplate = this.runtime.getModule("JavaInterfaceTemplate");
        return this.javaInterfaceTemplate;
    }

    public RubyModule getPackageModuleTemplate() {
        RubyModule module = this.packageModuleTemplate;
        if (module != null) {
            return module;
        }
        this.packageModuleTemplate = this.runtime.getModule("JavaPackageModuleTemplate");
        return this.packageModuleTemplate;
    }

    public RubyClass getJavaProxyClass() {
        RubyClass clazz = this.javaProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaProxyClass = this.runtime.getClass("JavaProxy");
        return this.javaProxyClass;
    }

    public RubyClass getArrayJavaProxyCreatorClass() {
        RubyClass clazz = this.arrayJavaProxyCreatorClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayJavaProxyCreatorClass = this.runtime.getClass("ArrayJavaProxyCreator");
        return this.arrayJavaProxyCreatorClass;
    }

    public RubyClass getConcreteProxyClass() {
        RubyClass clazz = this.concreteProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.concreteProxyClass = this.runtime.getClass("ConcreteJavaProxy");
        return this.concreteProxyClass;
    }

    public RubyClass getMapJavaProxyClass() {
        RubyClass clazz = this.mapJavaProxy;
        if (clazz != null) {
            return clazz;
        }
        this.mapJavaProxy = this.runtime.getClass("MapJavaProxy");
        return this.mapJavaProxy;
    }

    public RubyClass getArrayProxyClass() {
        RubyClass clazz = this.arrayProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayProxyClass = this.runtime.getClass("ArrayJavaProxy");
        return this.arrayProxyClass;
    }

    public RubyClass getJavaFieldClass() {
        RubyClass clazz = this.javaFieldClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaFieldClass = this.getJavaModule().getClass("JavaField");
        return this.javaFieldClass;
    }

    public RubyClass getJavaMethodClass() {
        RubyClass clazz = this.javaMethodClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaMethodClass = this.getJavaModule().getClass("JavaMethod");
        return this.javaMethodClass;
    }

    public RubyClass getJavaConstructorClass() {
        RubyClass clazz = this.javaConstructorClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaConstructorClass = this.getJavaModule().getClass("JavaConstructor");
        return this.javaConstructorClass;
    }

    public Map<Set<?>, JavaProxyClass> getJavaProxyClassCache() {
        return this.javaProxyClassCache;
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        Constructor<Object> constructor2 = null;
        if (Options.INVOKEDYNAMIC_CLASS_VALUES.load().booleanValue()) {
            try {
                Class.forName("java.lang.ClassValue");
                constructor2 = Class.forName("org.jruby.util.collections.Java7ClassValue").getConstructor(ClassValueCalculator.class);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (constructor2 == null) {
            try {
                constructor2 = MapBasedClassValue.class.getConstructor(ClassValueCalculator.class);
            }
            catch (Exception ex2) {
                throw new RuntimeException(ex2);
            }
        }
        CLASS_VALUE_CONSTRUCTOR = constructor2;
    }
}

