/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WeakValuedMap<Key, Value> {
    private final ReferenceQueue deadReferences = new ReferenceQueue();
    private final Map<Key, KeyedReference<Key, Value>> references = this.newMap();

    public void put(Key key2, Value value2) {
        this.cleanReferences();
        this.references.put(key2, new KeyedReference<Key, Value>(value2, key2, this.deadReferences));
    }

    public Value get(Key key2) {
        this.cleanReferences();
        KeyedReference<Key, Value> reference2 = this.references.get(key2);
        if (reference2 == null) {
            return null;
        }
        return (Value)reference2.get();
    }

    protected Map<Key, KeyedReference<Key, Value>> newMap() {
        return new ConcurrentHashMap();
    }

    private void cleanReferences() {
        KeyedReference ref;
        while ((ref = (KeyedReference)this.deadReferences.poll()) != null) {
            this.references.remove(ref.key());
        }
    }

    protected static class KeyedReference<Key, Value>
    extends WeakReference<Value> {
        private final Key key;

        public KeyedReference(Value object, Key key2, ReferenceQueue queue) {
            super(object, queue);
            this.key = key2;
        }

        public Key key() {
            return this.key;
        }
    }
}

