/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.ops4j.io.StreamUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.monitors.stream.StreamMonitor;

public final class FileUtils {
    static /* synthetic */ Class class$org$ops4j$io$FileUtils;

    private FileUtils() {
    }

    public static void copyFile(File src, File dest, StreamMonitor monitor) throws IOException, FileNotFoundException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        int length = (int)src.length();
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            StreamUtils.copyStream(monitor, src.toURL(), length, fis, fos, true);
        }
        catch (FileNotFoundException e) {
            FileUtils.reportError(monitor, e, src.toURL());
            throw e;
        }
        catch (NullArgumentException e) {
            FileUtils.reportError(monitor, e, src.toURL());
            throw e;
        }
        catch (MalformedURLException e) {
            FileUtils.reportError(monitor, e, src.toURL());
            throw e;
        }
        catch (IOException e) {
            FileUtils.reportError(monitor, e, src.toURL());
            throw e;
        }
    }

    private static void reportError(StreamMonitor monitor, Exception e, URL url) {
        if (monitor != null) {
            monitor.notifyError(url, e.getMessage());
        }
    }

    public static File getFileFromClasspath(String filePath) throws FileNotFoundException {
        try {
            URL fileURL;
            Class<?> clazz = class$org$ops4j$io$FileUtils;
            if (clazz == null) {
                clazz = class$org$ops4j$io$FileUtils = new FileUtils[0].getClass().getComponentType();
            }
            if ((fileURL = clazz.getClassLoader().getResource(filePath)) == null) {
                throw new FileNotFoundException("File [" + filePath + "] could not be found in classpath");
            }
            return new File(fileURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException("File [" + filePath + "] could not be found: " + e.getMessage());
        }
    }

    public static boolean delete(File file) {
        File[] childs;
        boolean delete = false;
        if (file != null && file.exists() && !(delete = file.delete()) && file.isDirectory() && (childs = file.listFiles()) != null && childs.length > 0) {
            File[] arr$ = childs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                File child = arr$[i$];
                FileUtils.delete(child);
            }
            delete = file.delete();
        }
        return delete;
    }
}

