/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.commons.handler;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.url.commons.handler.ConnectionFactory;
import org.ops4j.pax.url.commons.handler.OptionalConfigAdminHelper;
import org.ops4j.util.property.PropertyResolver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerActivator<T>
implements BundleActivator {
    private static final Log LOG;
    private final String[] m_protocols;
    private final String m_pid;
    private final ConnectionFactory<T> m_connectionFactory;
    private BundleContext m_bundleContext;
    private PropertyResolver m_propertyResolver;
    private T m_configuration;
    private ServiceRegistration m_handlerReg;
    private ServiceRegistration m_managedServiceReg;
    static /* synthetic */ Class class$org$ops4j$pax$url$commons$handler$HandlerActivator;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;

    public HandlerActivator(String[] protocols, String pid, ConnectionFactory<T> connectionFactory) {
        NullArgumentException.validateNotNull(protocols, "Protocols");
        NullArgumentException.validateNotNull(pid, "PID");
        NullArgumentException.validateNotNull(connectionFactory, "Connection factory");
        this.m_protocols = protocols;
        this.m_pid = pid;
        this.m_connectionFactory = connectionFactory;
    }

    public void start(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        this.m_bundleContext = bundleContext;
        this.registerManagedService();
        this.registerHandler();
        LOG.debug(new StringBuffer().append("Handler for protocols ").append(Arrays.deepToString(this.m_protocols)).append(" started").toString());
    }

    public void stop(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        if (this.m_handlerReg != null) {
            this.m_handlerReg.unregister();
        }
        if (this.m_managedServiceReg != null) {
            this.m_managedServiceReg.unregister();
        }
        this.m_bundleContext = null;
        LOG.debug(new StringBuffer().append("Handler for protocols ").append(Arrays.deepToString(this.m_protocols)).append(" stopped").toString());
    }

    private void registerHandler() {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("url.handler.protocol", this.m_protocols);
        Class<?> clazz = class$org$osgi$service$url$URLStreamHandlerService;
        if (clazz == null) {
            clazz = class$org$osgi$service$url$URLStreamHandlerService = new URLStreamHandlerService[0].getClass().getComponentType();
        }
        this.m_handlerReg = this.m_bundleContext.registerService(clazz.getName(), (Object)new Handler(), props);
    }

    private void registerManagedService() {
        try {
            this.m_managedServiceReg = OptionalConfigAdminHelper.registerManagedService(this.m_bundleContext, this.m_pid, this);
        }
        catch (Throwable ignore) {
            this.setResolver(new BundleContextPropertyResolver(this.m_bundleContext));
            this.m_managedServiceReg = null;
        }
    }

    synchronized PropertyResolver getResolver() {
        return this.m_propertyResolver;
    }

    synchronized void setResolver(PropertyResolver propertyResolver) {
        this.m_propertyResolver = propertyResolver;
        this.m_configuration = this.m_connectionFactory.createConfiguration(propertyResolver);
    }

    static {
        Class<?> clazz = class$org$ops4j$pax$url$commons$handler$HandlerActivator;
        if (clazz == null) {
            clazz = class$org$ops4j$pax$url$commons$handler$HandlerActivator = new HandlerActivator[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog(clazz);
    }

    private class Handler
    extends AbstractURLStreamHandlerService {
        private Handler() {
        }

        public URLConnection openConnection(URL url) throws IOException {
            return HandlerActivator.this.m_connectionFactory.createConection(HandlerActivator.this.m_bundleContext, url, HandlerActivator.this.m_configuration);
        }
    }
}

