/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.maven.commons;

import java.io.File;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.maven.commons.MavenConfiguration;
import org.ops4j.pax.url.maven.commons.MavenRepositoryURL;
import org.ops4j.pax.url.maven.commons.MavenSettings;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenConfigurationImpl
extends PropertyStore
implements MavenConfiguration {
    private static final Log LOGGER;
    private static final String REPOSITORIES_APPEND_SIGN = "+";
    private static final String REPOSITORIES_SEPARATOR = ",";
    private MavenSettings m_settings;
    private final String m_pid;
    private final PropertyResolver m_propertyResolver;
    static /* synthetic */ Class class$org$ops4j$pax$url$maven$commons$MavenConfigurationImpl;

    public MavenConfigurationImpl(PropertyResolver propertyResolver, String pid) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        NullArgumentException.validateNotEmpty(pid, true, "Configuration pid");
        this.m_pid = pid;
        this.m_propertyResolver = propertyResolver;
    }

    public void setSettings(MavenSettings settings) {
        this.m_settings = settings;
    }

    @Override
    public Boolean getCertificateCheck() {
        if (!this.contains(new StringBuffer().append(this.m_pid).append(".certificateCheck").toString())) {
            return this.set(new StringBuffer().append(this.m_pid).append(".certificateCheck").toString(), Boolean.valueOf(this.m_propertyResolver.get(new StringBuffer().append(this.m_pid).append(".certificateCheck").toString())));
        }
        return (Boolean)this.get(new StringBuffer().append(this.m_pid).append(".certificateCheck").toString());
    }

    @Override
    public URL getSettingsFileUrl() {
        block6: {
            String spec;
            if (!this.contains(new StringBuffer().append(this.m_pid).append(".settings").toString()) && (spec = this.m_propertyResolver.get(new StringBuffer().append(this.m_pid).append(".settings").toString())) != null) {
                try {
                    return this.set(new StringBuffer().append(this.m_pid).append(".settings").toString(), new URL(spec));
                }
                catch (MalformedURLException e) {
                    File file = new File(spec);
                    if (file.exists()) {
                        try {
                            return this.set(new StringBuffer().append(this.m_pid).append(".settings").toString(), file.toURL());
                        }
                        catch (MalformedURLException ignore) {
                            break block6;
                        }
                    }
                    LOGGER.warn(new StringBuffer().append("Settings file [").append(spec).append("] cannot be used and will be skipped (malformed url or file does not exist)").toString());
                    this.set(new StringBuffer().append(this.m_pid).append(".settings").toString(), null);
                }
            }
        }
        return (URL)this.get(new StringBuffer().append(this.m_pid).append(".settings").toString());
    }

    @Override
    public List<MavenRepositoryURL> getDefaultRepositories() throws MalformedURLException {
        if (!this.contains(new StringBuffer().append(this.m_pid).append(".defaultRepositories").toString())) {
            String defaultRepositoriesProp = this.m_propertyResolver.get(new StringBuffer().append(this.m_pid).append(".defaultRepositories").toString());
            ArrayList<MavenRepositoryURL> defaultRepositoriesProperty = new ArrayList<MavenRepositoryURL>();
            MavenRepositoryURL localRepository = this.getLocalRepository();
            if (defaultRepositoriesProp != null && defaultRepositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = defaultRepositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    defaultRepositoriesProperty.add(new MavenRepositoryURL(repositoryURL));
                }
            }
            LOGGER.trace(new StringBuffer().append("Using repositories [").append(defaultRepositoriesProperty).append("]").toString());
            return this.set(new StringBuffer().append(this.m_pid).append(".defaultRepositories").toString(), defaultRepositoriesProperty);
        }
        return (List)this.get(new StringBuffer().append(this.m_pid).append(".defaultRepositories").toString());
    }

    @Override
    public List<MavenRepositoryURL> getRepositories() throws MalformedURLException {
        if (!this.contains(new StringBuffer().append(this.m_pid).append(".repositories").toString())) {
            String settingsRepos;
            String repositoriesProp = this.m_propertyResolver.get(new StringBuffer().append(this.m_pid).append(".repositories").toString());
            if ((repositoriesProp == null || repositoriesProp.startsWith(REPOSITORIES_APPEND_SIGN)) && this.m_settings != null && (settingsRepos = this.m_settings.getRepositories()) != null) {
                repositoriesProp = repositoriesProp == null ? settingsRepos : new StringBuffer().append(repositoriesProp.substring(1)).append(REPOSITORIES_SEPARATOR).append(settingsRepos).toString();
            }
            ArrayList<MavenRepositoryURL> repositoriesProperty = new ArrayList<MavenRepositoryURL>();
            MavenRepositoryURL localRepository = this.getLocalRepository();
            if (localRepository != null) {
                repositoriesProperty.add(localRepository);
            }
            if (repositoriesProp != null && repositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = repositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    repositoriesProperty.add(new MavenRepositoryURL(repositoryURL));
                }
            }
            LOGGER.trace(new StringBuffer().append("Using repositories [").append(repositoriesProperty).append("]").toString());
            return this.set(new StringBuffer().append(this.m_pid).append(".repositories").toString(), repositoriesProperty);
        }
        return (List)this.get(new StringBuffer().append(this.m_pid).append(".repositories").toString());
    }

    @Override
    public MavenRepositoryURL getLocalRepository() {
        if (!this.contains(new StringBuffer().append(this.m_pid).append(".localRepository").toString())) {
            String spec = this.m_propertyResolver.get(new StringBuffer().append(this.m_pid).append(".localRepository").toString());
            if (spec == null && this.m_settings != null) {
                spec = this.m_settings.getLocalRepository();
            }
            if (spec != null) {
                if (!spec.toLowerCase().contains("@snapshots")) {
                    spec = new StringBuffer().append(spec).append("@snapshots").toString();
                }
                try {
                    return this.set(new StringBuffer().append(this.m_pid).append(".localRepository").toString(), new MavenRepositoryURL(spec));
                }
                catch (MalformedURLException e) {
                    try {
                        return this.set(new StringBuffer().append(this.m_pid).append(".localRepository").toString(), new MavenRepositoryURL(new File(spec).toURI().toASCIIString()));
                    }
                    catch (MalformedURLException ignore) {
                        LOGGER.warn(new StringBuffer().append("Local repository [").append(spec).append("] cannot be used and will be skipped").toString());
                        return this.set(new StringBuffer().append(this.m_pid).append(".localRepository").toString(), null);
                    }
                }
            }
        }
        return (MavenRepositoryURL)this.get(new StringBuffer().append(this.m_pid).append(".localRepository").toString());
    }

    @Override
    public Boolean useFallbackRepositories() {
        if (!this.contains(new StringBuffer().append(this.m_pid).append(".useFallbackRepositories").toString())) {
            String useFallbackRepoProp = this.m_propertyResolver.get(new StringBuffer().append(this.m_pid).append(".useFallbackRepositories").toString());
            return this.set(new StringBuffer().append(this.m_pid).append(".useFallbackRepositories").toString(), Boolean.valueOf(useFallbackRepoProp == null ? "true" : useFallbackRepoProp));
        }
        return (Boolean)this.get(new StringBuffer().append(this.m_pid).append(".useFallbackRepositories").toString());
    }

    @Override
    public void enableProxy(URL url) {
        String proxySupport = this.m_propertyResolver.get(new StringBuffer().append(this.m_pid).append(".proxySupport").toString());
        if ("false".equalsIgnoreCase(proxySupport)) {
            return;
        }
        String protocol = url.getProtocol();
        if (protocol == null || protocol.equals(this.get(new StringBuffer().append(this.m_pid).append(".proxySupport").toString()))) {
            return;
        }
        Map<String, String> proxyDetails = this.m_settings.getProxySettings().get(protocol);
        if (proxyDetails != null) {
            LOGGER.trace(new StringBuffer().append("Enabling proxy [").append(proxyDetails).append("]").toString());
            final String user = proxyDetails.get("user");
            final String pass = proxyDetails.get("pass");
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            });
            System.setProperty(new StringBuffer().append(protocol).append(".proxyHost").toString(), proxyDetails.get("host"));
            System.setProperty(new StringBuffer().append(protocol).append(".proxyPort").toString(), proxyDetails.get("port"));
            System.setProperty(new StringBuffer().append(protocol).append(".nonProxyHosts").toString(), proxyDetails.get("nonProxyHosts"));
            this.set(new StringBuffer().append(this.m_pid).append(".proxySupport").toString(), protocol);
        }
    }

    @Override
    public Boolean isAetherDisabled() {
        if (!this.contains(new StringBuffer().append(this.m_pid).append(".disableAether").toString())) {
            return this.set(new StringBuffer().append(this.m_pid).append(".disableAether").toString(), Boolean.valueOf(this.m_propertyResolver.get(new StringBuffer().append(this.m_pid).append(".disableAether").toString())));
        }
        return (Boolean)this.get(new StringBuffer().append(this.m_pid).append(".disableAether").toString());
    }

    static {
        Class<?> clazz = class$org$ops4j$pax$url$maven$commons$MavenConfigurationImpl;
        if (clazz == null) {
            clazz = class$org$ops4j$pax$url$maven$commons$MavenConfigurationImpl = new MavenConfigurationImpl[0].getClass().getComponentType();
        }
        LOGGER = LogFactory.getLog(clazz);
    }
}

