/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.maven.commons;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.url.maven.commons.MavenSettings;
import org.ops4j.util.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenSettingsImpl
implements MavenSettings {
    private static final Log LOGGER;
    private static final String LOCAL_REPOSITORY_TAG = "localRepository";
    private static final String SERVER_TAG = "servers/server";
    private static final String PROFILE_TAG = "profiles/profile";
    private static final String REPOSITORY_TAG = "repositories/repository";
    private static final String ACTIVE_PROFILES_TAG = "activeProfiles/activeProfile";
    private static final String PROXY_TAG = "proxies/proxy";
    private static final String FALLBACK_REPOSITORIES = "http://osgi.sonatype.org/content/groups/pax-runner,http://repo1.maven.org/maven2,http://repository.ops4j.org/maven2,http://repository.springsource.com/maven/bundles/release,http://repository.springsource.com/maven/bundles/external";
    private Document m_document;
    private URL m_settingsURL;
    private final boolean m_useFallbackRepositories;
    private String m_localRepository;
    private String m_repositories;
    private Map<String, Map<String, String>> m_proxySettings;
    static /* synthetic */ Class class$org$ops4j$pax$url$maven$commons$MavenSettingsImpl;

    public MavenSettingsImpl(URL settingsURL, boolean useFallbackRepositories) {
        this.m_settingsURL = settingsURL;
        this.m_useFallbackRepositories = useFallbackRepositories;
        if (this.m_settingsURL == null) {
            this.m_settingsURL = MavenSettingsImpl.safeGetFile(new StringBuffer().append(System.getProperty("user.home")).append("/.m2/settings.xml").toString());
            if (this.m_settingsURL == null) {
                this.m_settingsURL = MavenSettingsImpl.safeGetFile(new StringBuffer().append(System.getProperty("maven.home")).append("/conf/settings.xml").toString());
                if (this.m_settingsURL == null) {
                    try {
                        this.m_settingsURL = MavenSettingsImpl.safeGetFile(new StringBuffer().append(System.getenv("M2_HOME")).append("/conf/settings.xml").toString());
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public MavenSettingsImpl(URL settingsURL) {
        this(settingsURL, false);
    }

    @Override
    public String getLocalRepository() {
        if (this.m_localRepository == null) {
            Element settingsElement;
            this.readSettings();
            if (this.m_document != null && (settingsElement = XmlUtils.getElement(this.m_document, LOCAL_REPOSITORY_TAG)) != null) {
                this.m_localRepository = XmlUtils.getTextContent(settingsElement);
            }
            if (this.m_localRepository == null || this.m_localRepository.trim().length() == 0) {
                this.m_localRepository = new StringBuffer().append(System.getProperty("user.home")).append("/.m2/repository").toString();
            }
        }
        return this.m_localRepository;
    }

    @Override
    public String getRepositories() {
        if (this.m_repositories == null) {
            this.readSettings();
            if (this.m_document != null) {
                Set<String> activeProfiles = this.getActiveProfiles();
                HashMap<String, String> repositories = null;
                ArrayList<String> order = null;
                List<Element> profiles = XmlUtils.getElements(this.m_document, PROFILE_TAG);
                if (profiles != null) {
                    List<Element> servers;
                    for (Element profile : profiles) {
                        String profileId;
                        Element profileIdElement = XmlUtils.getElement(profile, "id");
                        if (profileIdElement == null || (profileId = XmlUtils.getTextContent(profileIdElement)) == null) continue;
                        if (activeProfiles.contains(profileId)) {
                            List<Element> repos = XmlUtils.getElements(profile, REPOSITORY_TAG);
                            if (repos == null) continue;
                            for (Element repo : repos) {
                                String url;
                                Element element = XmlUtils.getElement(repo, "id");
                                if (element == null) continue;
                                String id = XmlUtils.getTextContent(element);
                                element = XmlUtils.getElement(repo, "layout");
                                String layout = null;
                                if (element != null) {
                                    layout = XmlUtils.getTextContent(element);
                                }
                                if (layout != null && !"default".equals(layout)) continue;
                                String snapshots = XmlUtils.getTextContentOfElement(repo, "snapshots/enabled");
                                String releases = XmlUtils.getTextContentOfElement(repo, "releases/enabled");
                                element = XmlUtils.getElement(repo, "url");
                                if (element == null || (url = XmlUtils.getTextContent(element)) == null) continue;
                                if (repositories == null) {
                                    repositories = new HashMap<String, String>();
                                    order = new ArrayList<String>();
                                }
                                if (snapshots != null && Boolean.valueOf(snapshots).booleanValue()) {
                                    url = new StringBuffer().append(url).append("@snapshots").toString();
                                }
                                if (releases != null && !Boolean.valueOf(releases).booleanValue()) {
                                    url = new StringBuffer().append(url).append("@noreleases").toString();
                                }
                                repositories.put(id, url);
                                order.add(id);
                            }
                            continue;
                        }
                        LOGGER.debug(new StringBuffer().append("Profile [").append(profileId).append("] is inactive (ignored).").toString());
                    }
                    if (repositories != null && (servers = XmlUtils.getElements(this.m_document, SERVER_TAG)) != null) {
                        for (Element server : servers) {
                            String password;
                            String username;
                            String id;
                            String repository;
                            Element element = XmlUtils.getElement(server, "id");
                            if (element == null || (repository = (String)repositories.get(id = XmlUtils.getTextContent(element))) == null || !repository.contains("://") || (element = XmlUtils.getElement(server, "username")) == null || (username = XmlUtils.getTextContent(element)) == null) continue;
                            element = XmlUtils.getElement(server, "password");
                            if (element != null && (password = XmlUtils.getTextContent(element)) != null) {
                                username = new StringBuffer().append(username).append(":").append(password).toString();
                            }
                            String repo = new StringBuffer().append("://").append(username).append("@").toString();
                            repo = Matcher.quoteReplacement(repo);
                            repositories.put(id, repository.replaceFirst("://", repo));
                        }
                    }
                    StringBuffer builder = new StringBuffer();
                    if (order != null) {
                        for (String repositoryId : order) {
                            if (builder.length() > 0) {
                                builder.append(",");
                            }
                            builder.append((String)repositories.get(repositoryId));
                        }
                    }
                    this.m_repositories = builder.toString();
                }
            }
            if (this.m_useFallbackRepositories) {
                this.m_repositories = this.m_repositories == null || this.m_repositories.length() == 0 ? FALLBACK_REPOSITORIES : new StringBuffer().append(this.m_repositories).append(",").append(FALLBACK_REPOSITORIES).toString();
            }
        }
        return this.m_repositories;
    }

    private Set<String> getActiveProfiles() {
        HashSet<String> ret = new HashSet<String>();
        List<Element> activeProfiles = XmlUtils.getElements(this.m_document, ACTIVE_PROFILES_TAG);
        if (activeProfiles != null) {
            for (Element active : activeProfiles) {
                ret.add(XmlUtils.getTextContent(active));
            }
        }
        return ret;
    }

    private void readSettings() {
        if (this.m_document == null && this.m_settingsURL != null) {
            try {
                this.m_document = XmlUtils.parseDoc(this.m_settingsURL.openStream());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(new StringBuffer().append("Could not parse settings [").append(this.m_settingsURL).append("]").toString(), e);
            }
            catch (SAXException e) {
                throw new RuntimeException(new StringBuffer().append("Could not parse settings [").append(this.m_settingsURL).append("]").toString(), e);
            }
            catch (IOException e) {
                throw new RuntimeException(new StringBuffer().append("Could not parse settings [").append(this.m_settingsURL).append("]").toString(), e);
            }
        }
    }

    private static URL safeGetFile(String filePath) {
        File file;
        if (filePath != null && (file = new File(filePath)).exists() && file.canRead() && file.isFile()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getSetting(Element element, String settingName, String defaultSetting) {
        String setting = XmlUtils.getTextContentOfElement(element, settingName);
        if (setting == null) {
            return defaultSetting;
        }
        return setting;
    }

    @Override
    public Map<String, Map<String, String>> getProxySettings() {
        if (this.m_proxySettings == null) {
            List<Element> proxies;
            this.m_proxySettings = new HashMap<String, Map<String, String>>();
            this.readSettings();
            if (this.m_document != null && (proxies = XmlUtils.getElements(this.m_document, PROXY_TAG)) != null) {
                for (Element proxy : proxies) {
                    String active = this.getSetting(proxy, "active", "false");
                    String protocol = this.getSetting(proxy, "protocol", "http");
                    if (this.m_proxySettings.containsKey(protocol) && !"true".equalsIgnoreCase(active)) continue;
                    HashMap<String, String> proxyDetails = new HashMap<String, String>();
                    proxyDetails.put("user", this.getSetting(proxy, "username", ""));
                    proxyDetails.put("pass", this.getSetting(proxy, "password", ""));
                    proxyDetails.put("host", this.getSetting(proxy, "host", "127.0.0.1"));
                    proxyDetails.put("port", this.getSetting(proxy, "port", "8080"));
                    proxyDetails.put("nonProxyHosts", this.getSetting(proxy, "nonProxyHosts", ""));
                    this.m_proxySettings.put(protocol, proxyDetails);
                }
            }
        }
        return Collections.unmodifiableMap(this.m_proxySettings);
    }

    static {
        Class<?> clazz = class$org$ops4j$pax$url$maven$commons$MavenSettingsImpl;
        if (clazz == null) {
            clazz = class$org$ops4j$pax$url$maven$commons$MavenSettingsImpl = new MavenSettingsImpl[0].getClass().getComponentType();
        }
        LOGGER = LogFactory.getLog(clazz);
    }
}

